/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.IRegisterable;
import com.ferreusveritas.dynamictrees.api.backport.PropertyInteger;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDynamicLeaves
extends BlockLeaves
implements ITreePart,
IAgeable,
IRegisterable {
    public static final PropertyInteger HYDRO = PropertyInteger.create("hydro", 1, 4, PropertyInteger.Bits.B00XX);
    public static final PropertyInteger TREE = PropertyInteger.create("tree", 0, 3, PropertyInteger.Bits.BXX00);
    private String[] species = new String[]{"X", "X", "X", "X"};
    private DynamicTree[] trees = new DynamicTree[4];
    protected ResourceLocation name;

    public BlockDynamicLeaves() {
        this.field_150121_P = true;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    @Override
    public void setRegistryName(ResourceLocation regName) {
        this.name = regName;
    }

    public ResourceLocation setRegistryName(String ModID, String regName) {
        this.name = new ResourceLocation(ModID, regName);
        return this.name;
    }

    public void setRegistryName(String name) {
        ModContainer mc = Loader.instance().activeModContainer();
        String domain = mc.getModId().toLowerCase();
        this.setRegistryName(new ResourceLocation(domain, name));
    }

    @Override
    public void setUnlocalizedNameReg(String unlocalName) {
        this.func_149663_c(unlocalName);
    }

    public void setTree(int treeNum, DynamicTree tree) {
        this.trees[treeNum & 3] = tree;
        this.species[treeNum & 3] = tree.getName().func_110623_a();
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        return this.getTree(blockAccess.getBlockState(pos));
    }

    public DynamicTree getTree(IBlockState blockState) {
        return this.getTree(blockState.getValue(TREE));
    }

    public DynamicTree getTree(int treeNum) {
        return this.trees[treeNum & 3];
    }

    protected static int getSubBlockNum(IBlockAccess blockAccess, BlockPos pos) {
        return new BlockAccess(blockAccess).getBlockState(pos).getValue(TREE);
    }

    public int getFlammability(net.minecraft.world.IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return (int)((float)this.getTree(new BlockAccess(world), new BlockPos(x, y, z)).getPrimitiveLeaves().getBlock().getFlammability(world, x, y, z, face) * 0.75f);
    }

    public int getFireSpreadSpeed(net.minecraft.world.IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.getTree(new BlockAccess(world), new BlockPos(x, y, z)).getPrimitiveLeaves().getBlock().getFireSpreadSpeed(world, x, y, z, face);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        com.ferreusveritas.dynamictrees.api.backport.World worldIn = new com.ferreusveritas.dynamictrees.api.backport.World(world);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = worldIn.getBlockState(pos);
        this.age(worldIn, pos, state, rand, false);
    }

    @Override
    public boolean age(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, IBlockState state, Random rand, boolean rapid) {
        DynamicTree tree = this.getTree(state);
        int preHydro = this.getHydrationLevel(state);
        int hydro = this.getHydrationLevelFromNeighbors(world, pos, tree);
        if (hydro == 0 || !rapid && !this.hasAdequateLight(world, tree, pos)) {
            BlockDynamicLeaves.removeLeaves(world, pos);
            return true;
        }
        if (preHydro != hydro && BlockDynamicLeaves.setHydrationLevel(world, pos, hydro, state)) {
            return true;
        }
        if (hydro > 1) {
            for (EnumFacing dir : EnumFacing.VALUES) {
                this.growLeaves(world, tree, pos.offset(dir));
            }
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        BlockPos deltaPos = new BlockPos(x, y, z).offset(dir);
        DynamicTree tree = TreeHelper.getSafeTreePart(new BlockAccess((net.minecraft.world.IBlockAccess)world), deltaPos).getTree(new com.ferreusveritas.dynamictrees.api.backport.World(world), deltaPos);
        if (tree != null && tree.getDynamicLeaves() == this) {
            return tree.getDynamicLeavesSub() << 2;
        }
        return 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        this.onFallenUpon(new com.ferreusveritas.dynamictrees.api.backport.World(world), new BlockPos(x, y, z), entity, fallDistance);
    }

    public void onFallenUpon(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70143_R -= 1.0f;
            AxisAlignedBB aabb = entity.field_70121_D;
            int minX = MathHelper.floor(aabb.field_72340_a + 0.001);
            int minZ = MathHelper.floor(aabb.field_72339_c + 0.001);
            int maxX = MathHelper.floor(aabb.field_72336_d - 0.001);
            int maxZ = MathHelper.floor(aabb.field_72334_f - 0.001);
            boolean crushing = true;
            boolean hasLeaves = true;
            float volume = MathHelper.clamp(this.field_149762_H.func_150497_c() / 16.0f * fallDistance, 0.0f, 3.0f);
            world.real().func_72956_a(entity, this.field_149762_H.func_150495_a(), volume, this.field_149762_H.func_150494_d());
            int iy = 0;
            while (entity.field_70143_R > 3.0f && crushing && pos.getY() - iy > 0) {
                if (hasLeaves) {
                    entity.field_70143_R *= 0.66f;
                    hasLeaves = false;
                }
                for (int ix = minX; ix <= maxX; ++ix) {
                    for (int iz = minZ; iz <= maxZ; ++iz) {
                        BlockPos iPos = new BlockPos(ix, pos.getY() - iy, iz);
                        IBlockState state = world.getBlockState(iPos);
                        if (TreeHelper.isLeaves(state)) {
                            hasLeaves = true;
                            DynamicTrees.proxy.crushLeavesBlock(world, iPos, state, entity);
                            world.setBlockToAir(iPos);
                            continue;
                        }
                        if (world.isAirBlock(iPos)) continue;
                        crushing = false;
                    }
                }
                ++iy;
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity.field_70181_x < 0.0 && entity.field_70143_R < 2.0f) {
            entity.field_70143_R = 0.0f;
            entity.field_70181_x *= 0.5;
        } else if (entity.field_70181_x > 0.0 && entity.field_70181_x < 0.25) {
            entity.field_70181_x += 0.025;
        }
        entity.func_70031_b(false);
        entity.field_70159_w *= 0.25;
        entity.field_70179_y *= 0.25;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
    }

    public void growLeaves(com.ferreusveritas.dynamictrees.api.backport.World world, DynamicTree tree, BlockPos pos) {
        if (this.isLocationSuitableForNewLeaves(world, tree, pos)) {
            int hydro = this.getHydrationLevelFromNeighbors(world, pos, tree);
            this.setBlockToLeaves(world, tree, pos, hydro);
        }
    }

    public boolean growLeaves(com.ferreusveritas.dynamictrees.api.backport.World world, DynamicTree tree, BlockPos pos, int hydro) {
        int n = hydro = hydro == 0 ? (int)tree.getDefaultHydration() : hydro;
        if (this.isLocationSuitableForNewLeaves(world, tree, pos)) {
            return this.setBlockToLeaves(world, tree, pos, hydro);
        }
        return false;
    }

    public boolean isLocationSuitableForNewLeaves(com.ferreusveritas.dynamictrees.api.backport.World world, DynamicTree tree, BlockPos pos) {
        int meta;
        IBlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof BlockDynamicLeaves) {
            return false;
        }
        IBlockState belowBlockState = world.getBlockState(pos.down());
        if (belowBlockState.isOpaqueCube() || belowBlockState.getBlock() instanceof BlockLiquid) {
            return false;
        }
        if (block == Blocks.field_150398_cm && ((meta = world.getBlockMetadata(pos)) & 8) != 0 && ((meta = world.getBlockMetadata(pos.down())) == 2 || meta == 3)) {
            world.setBlockToAir(pos);
            world.setBlockState(pos.down(), new BlockState((Block)Blocks.field_150329_H, meta - 1));
        }
        return world.isAirBlock(pos) && this.hasAdequateLight(world, tree, pos);
    }

    public boolean setBlockToLeaves(com.ferreusveritas.dynamictrees.api.backport.World world, DynamicTree tree, BlockPos pos, int hydro) {
        if ((hydro = MathHelper.clamp(hydro, 0, 4)) != 0) {
            world.setBlockState(pos, tree.getDynamicLeavesState().withProperty(HYDRO, hydro), 2);
            return true;
        }
        BlockDynamicLeaves.removeLeaves(world, pos);
        return false;
    }

    public boolean hasAdequateLight(com.ferreusveritas.dynamictrees.api.backport.World world, DynamicTree tree, BlockPos pos) {
        if (world.canBlockSeeSky(pos)) {
            return true;
        }
        int smother = tree.getSmotherLeavesMax();
        if (smother != 0 && BlockDynamicLeaves.isBottom(world, pos, world.getBlockState(pos.down()).getBlock())) {
            int smotherLeaves = 0;
            for (int i = 0; i < smother; ++i) {
                smotherLeaves += TreeHelper.isTreePart(world, pos.up(i + 1)) ? 1 : 0;
            }
            if (smotherLeaves >= smother) {
                return false;
            }
        }
        return world.getLightFor(EnumSkyBlock.Sky, pos) >= (TreeHelper.isLeaves(world, pos) ? tree.getLightRequirement() - 2 : tree.getLightRequirement());
    }

    public static boolean isBottom(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        Block belowBlock = world.getBlockState(pos.down()).getBlock();
        return BlockDynamicLeaves.isBottom(world, pos, belowBlock);
    }

    public static boolean isBottom(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, Block belowBlock) {
        if (TreeHelper.isTreePart(belowBlock)) {
            ITreePart belowTreepart = (ITreePart)belowBlock;
            return belowTreepart.getRadius(world, pos.down()) > 1;
        }
        return true;
    }

    public int getHydrationLevelFromNeighbors(IBlockAccess world, BlockPos pos, DynamicTree tree) {
        ICell[] cells = new ICell[6];
        for (EnumFacing dir : EnumFacing.VALUES) {
            BlockPos deltaPos = pos.offset(dir);
            IBlockState state = world.getBlockState(deltaPos);
            cells[dir.ordinal()] = TreeHelper.getSafeTreePart(state).getHydrationCell(world, deltaPos, state, dir, tree);
        }
        return tree.getCellSolver().solve(cells);
    }

    public int getHydrationLevel(IBlockState blockState) {
        if (blockState.getBlock() instanceof BlockDynamicLeaves) {
            return blockState.getValue(HYDRO);
        }
        return 0;
    }

    public int getHydrationLevel(IBlockAccess blockAccess, BlockPos pos) {
        return this.getHydrationLevel(blockAccess.getBlockState(pos));
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        int hydro = this.getHydrationLevel(blockState);
        DynamicTree tree = this.getTree(blockState);
        if (dir != null && tree != null) {
            return tree.getCellForLeaves(hydro);
        }
        return Cells.normalCells[hydro];
    }

    public static void removeLeaves(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        world.setBlockToAir(pos);
        world.real().func_147459_d(pos.getX(), pos.getY(), pos.getZ(), Blocks.field_150350_a);
    }

    public static boolean setHydrationLevel(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, int hydro, IBlockState currentBlockState) {
        if ((hydro = MathHelper.clamp(hydro, 0, 4)) == 0) {
            BlockDynamicLeaves.removeLeaves(world, pos);
            return true;
        }
        world.setBlockState(pos, currentBlockState.withProperty(HYDRO, hydro), 4);
        return false;
    }

    @Override
    public GrowSignal growSignal(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            this.branchOut(world, pos, signal);
        }
        return signal;
    }

    public boolean needLeaves(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, DynamicTree tree) {
        if (world.isAirBlock(pos)) {
            return this.growLeaves(world, tree, pos, tree.getDefaultHydration());
        }
        IBlockState blockState = world.getBlockState(pos);
        ITreePart treepart = TreeHelper.getSafeTreePart(blockState);
        return treepart == this && tree == this.getTree(blockState);
    }

    public GrowSignal branchOut(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, GrowSignal signal) {
        DynamicTree tree = signal.getSpecies().getTree();
        if (tree == null || !this.needLeaves(world, pos, tree)) {
            signal.success = false;
            return signal;
        }
        EnumFacing originDir = signal.dir.getOpposite();
        for (EnumFacing dir : EnumFacing.VALUES) {
            if (dir.equals((Object)originDir) || !TreeHelper.isBranch(world, pos.offset(dir))) continue;
            signal.success = false;
            return signal;
        }
        boolean hasLeaves = false;
        for (EnumFacing dir : EnumFacing.VALUES) {
            if (!this.needLeaves(world, pos.offset(dir), tree)) continue;
            hasLeaves = true;
        }
        if (hasLeaves) {
            world.setBlockState(pos, tree.getDynamicBranch().getDefaultState(), 2);
            signal.radius = signal.getSpecies().getSecondaryThickness();
        }
        signal.success = hasLeaves;
        return signal;
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return from.getTree().isCompatibleDynamicLeaves(blockAccess, pos) ? 2 : 0;
    }

    public ArrayList<ItemStack> getDrops(World _world, int x, int y, int z, int metadata, int fortune) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(_world);
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = new BlockState((Block)this, metadata);
        Species species = this.getExactSpecies(world, pos, this.getTree(state));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (species != null) {
            Random rand;
            int chance = this.func_150123_b(metadata);
            if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                chance = 10;
            }
            Random random = rand = world instanceof com.ferreusveritas.dynamictrees.api.backport.World ? world.rand : new Random();
            if (rand.nextInt(chance) == 0) {
                ret.add(species.getSeedStack(1));
            }
            chance = 200;
            if (fortune > 0 && (chance -= 10 << fortune) < 40) {
                chance = 40;
            }
            ret = species.getDrops(world, pos, chance, ret);
        }
        return ret;
    }

    Species getExactSpecies(IBlockAccess access, BlockPos pos, DynamicTree tree) {
        if (access instanceof com.ferreusveritas.dynamictrees.api.backport.World) {
            com.ferreusveritas.dynamictrees.api.backport.World world = (com.ferreusveritas.dynamictrees.api.backport.World)access;
            ArrayList<BlockPos> branchList = new ArrayList<BlockPos>();
            for (BlockPos dPos : tree.getLeafCluster().getAllNonZero()) {
                BlockBranch branch;
                IBlockState state = access.getBlockState(dPos = pos.add(BlockPos.ORIGIN.subtract(dPos)));
                if (!TreeHelper.isBranch(state) || (branch = TreeHelper.getBranch(state)).getTree() != tree || branch.getRadius(state) != 1) continue;
                branchList.add(dPos);
            }
            if (!branchList.isEmpty()) {
                BlockPos closest = (BlockPos)branchList.get(0);
                double minDist = 999.0;
                for (BlockPos dPos : branchList) {
                    double d = pos.distanceSq(dPos);
                    if (!(d < minDist)) continue;
                    minDist = d;
                    closest = dPos;
                }
                return DynamicTree.getExactSpecies(world, closest);
            }
        }
        return null;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, net.minecraft.world.IBlockAccess _blockAccess, int x, int y, int z, int fortune) {
        DynamicTree tree = this.getTree(new BlockAccess(_blockAccess), new BlockPos(x, y, z));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(tree.getPrimitiveLeavesItemStack(1));
        return ret;
    }

    @Override
    public int getRadiusForConnection(IBlockAccess blockAccess, BlockPos pos, BlockBranch from, int fromRadius) {
        return fromRadius == 1 && from.getTree().isCompatibleDynamicLeaves(blockAccess, pos) ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.getTree(new BlockState((Block)this, metadata)).getPrimitiveLeaves().getIcon(side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int metadata) {
        BlockState state = new BlockState((Block)this, metadata);
        return this.getTree(state).foliageColorMultiplier(null, null, null);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(net.minecraft.world.IBlockAccess access, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        return this.getTree(new BlockAccess(access), pos).foliageColorMultiplier(null, new BlockAccess(access), pos);
    }

    public boolean isFoliage(net.minecraft.world.IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return 0;
    }

    @Override
    public MapSignal analyse(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public boolean isRootNode() {
        return false;
    }

    @Override
    public boolean isBranch() {
        return false;
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return radius == 1 && branch.getTree() == this.getTree(blockAccess, pos) ? 1 : 0;
    }

    public int func_149656_h() {
        return 2;
    }

    public String[] func_150125_e() {
        return this.species;
    }
}

