/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.PropertyInteger;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.renderers.RendererRootyDirt;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;

public class BlockRootyDirt
extends BlockBackport
implements ITreePart {
    static String name = "rootydirt";
    public static final PropertyInteger LIFE = PropertyInteger.create("life", 0, 15, PropertyInteger.Bits.BXXXX);
    public IIcon dirtIcon;
    public IIcon grassIcon;
    public IIcon myceliumIcon;
    public IIcon podzolIcon;

    public BlockRootyDirt() {
        this(name);
    }

    public BlockRootyDirt(String name) {
        super(Material.field_151578_c);
        this.func_149672_a(field_149779_h);
        this.setDefaultState(this.getDefaultState().withProperty(LIFE, 15));
        this.func_149675_a(true);
        this.setUnlocalizedNameReg(name);
        this.setRegistryName(name);
    }

    @Override
    public void updateTick(World world, BlockPos pos, IBlockState state, Random random) {
        this.updateTree(world, pos, random, false);
    }

    public EnumFacing getTrunkDirection(IBlockAccess access, BlockPos rootPos) {
        return EnumFacing.UP;
    }

    public boolean updateTree(World world, BlockPos rootPos, Random random, boolean rapid) {
        BlockPos treePos;
        ITreePart treeBase;
        Species species = this.getSpecies(world, rootPos);
        boolean viable = false;
        if (species != null && (treeBase = TreeHelper.getTreePart(world, treePos = rootPos.offset(this.getTrunkDirection(world, rootPos)))) != null && CoordUtils.isSurroundedByLoadedChunks(world, rootPos)) {
            viable = species.update(world, this, rootPos, this.getSoilLife(world, rootPos), treeBase, treePos, random, rapid);
        }
        if (!viable) {
            world.setBlockState(rootPos, this.getDecayBlockState(world, rootPos), 3);
        }
        return viable;
    }

    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return ModBlocks.blockStates.dirt;
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    @Override
    public float getBlockHardness(IBlockState state, World world, BlockPos pos) {
        return 20.0f;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    @Override
    public int getComparatorInputOverride(World world, BlockPos pos, int side) {
        return this.getSoilLife(world, pos);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DynamicTree tree = this.getTree(world, pos);
        if (tree != null) {
            return tree.onTreeActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public void destroyTree(World world, BlockPos pos) {
        BlockBranch branch = TreeHelper.getBranch(world, pos.up());
        if (branch != null) {
            branch.destroyEntireTree(world, pos.up());
        }
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, int localMeta, EntityPlayer player) {
        this.destroyTree(world, pos);
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.destroyTree(world, pos);
    }

    public int getSoilLife(IBlockAccess blockAccess, BlockPos pos) {
        return blockAccess.getBlockMetadata(pos);
    }

    public void setSoilLife(World world, BlockPos pos, int life) {
        world.real().func_72921_c(pos.getX(), pos.getY(), pos.getZ(), MathHelper.func_76125_a((int)life, (int)0, (int)15), 3);
        world.real().func_147453_f(pos.getX(), pos.getY(), pos.getZ(), (Block)this);
    }

    public boolean fertilize(World world, BlockPos pos, int amount) {
        int soilLife = this.getSoilLife(world, pos);
        if (soilLife == 0 && amount < 0 || soilLife == 15 && amount > 0) {
            return false;
        }
        this.setSoilLife(world, pos, soilLife + amount);
        return true;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        return Cells.nullCell;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadiusForConnection(IBlockAccess blockAccess, BlockPos pos, BlockBranch from, int fromRadius) {
        return 8;
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return 0;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return 0;
    }

    public MapSignal startAnalysis(World world, BlockPos rootPos, MapSignal signal) {
        EnumFacing dir = this.getTrunkDirection(world, rootPos);
        BlockPos treePos = rootPos.offset(dir);
        TreeHelper.getSafeTreePart(world, treePos).analyse(world, treePos, null, signal);
        return signal;
    }

    @Override
    public MapSignal analyse(World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        signal.run(world, this, pos, fromDir);
        signal.root = pos;
        signal.found = true;
        return signal;
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return dir == EnumFacing.DOWN ? 17 : 0;
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        BlockPos treePos = pos.offset(this.getTrunkDirection(blockAccess, pos));
        return TreeHelper.isBranch(blockAccess, treePos) ? TreeHelper.getBranch(blockAccess, treePos).getTree(blockAccess, treePos) : null;
    }

    public Species getSpecies(World world, BlockPos pos) {
        BlockPos treePos = pos.offset(this.getTrunkDirection(world, pos));
        return TreeHelper.isBranch(world, treePos) ? TreeHelper.getBranch(world, treePos).getTree(world, treePos).getSpeciesForLocation(world, treePos) : null;
    }

    public int func_149656_h() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(net.minecraft.world.IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (RendererRootyDirt.renderPass == 1) {
            switch (side) {
                case 0: {
                    return this.dirtIcon;
                }
                case 1: {
                    switch (RendererRootyDirt.renderType) {
                        case GRASS: {
                            return Blocks.field_150349_c.func_149691_a(side, 0);
                        }
                        case MYCELIUM: {
                            return Blocks.field_150391_bh.func_149691_a(side, 0);
                        }
                        case PODZOL: {
                            return Blocks.field_150346_d.func_149691_a(side, 2);
                        }
                    }
                    return Blocks.field_150346_d.func_149691_a(side, 0);
                }
            }
            switch (RendererRootyDirt.renderType) {
                case GRASS: {
                    return this.grassIcon;
                }
                case MYCELIUM: {
                    return this.myceliumIcon;
                }
                case PODZOL: {
                    return this.podzolIcon;
                }
            }
            return this.dirtIcon;
        }
        if (RendererRootyDirt.renderType == RendererRootyDirt.RenderType.GRASS) {
            if (side == 1) {
                return Blocks.field_150349_c.func_149691_a(side, 0);
            }
            if (side != 0) {
                return BlockGrass.func_149990_e();
            }
        }
        return this.dirtIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 1) {
            return Blocks.field_150346_d.func_149691_a(side, 0);
        }
        return this.dirtIcon;
    }

    public RendererRootyDirt.RenderType getRenderType(BlockAccess blockAccess, int x, int y, int z) {
        int[] dMap = new int[]{0, -1, 1};
        for (int depth = 0; depth < 3; ++depth) {
            for (EnumFacing d : EnumFacing.HORIZONTALS) {
                BlockPos pos = new BlockPos(x + d.getFrontOffsetX(), y + dMap[depth], z + d.getFrontOffsetZ());
                IBlockState mimic = blockAccess.getBlockState(pos);
                if (mimic.equals((Block)Blocks.field_150349_c)) {
                    return RendererRootyDirt.RenderType.GRASS;
                }
                if (mimic.equals((Block)Blocks.field_150391_bh)) {
                    return RendererRootyDirt.RenderType.MYCELIUM;
                }
                if (!mimic.equals(Blocks.field_150346_d, 2)) continue;
                return RendererRootyDirt.RenderType.PODZOL;
            }
        }
        return RendererRootyDirt.RenderType.DIRT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(net.minecraft.world.IBlockAccess access, int x, int y, int z, int side) {
        if (super.func_149646_a(access, x, y, z, side)) {
            if (RendererRootyDirt.renderPass == 1) {
                if (RendererRootyDirt.renderType == RendererRootyDirt.RenderType.GRASS) {
                    return side != 1;
                }
                return true;
            }
            if (RendererRootyDirt.renderType == RendererRootyDirt.RenderType.GRASS) {
                return side != 0;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(net.minecraft.world.IBlockAccess blockAccess, int x, int y, int z) {
        if (RendererRootyDirt.renderType == RendererRootyDirt.RenderType.GRASS && RendererRootyDirt.renderPass == 2) {
            return Blocks.field_150349_c.func_149720_d(blockAccess, x, y, z);
        }
        return super.func_149720_d(blockAccess, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.dirtIcon = register.func_94245_a("dynamictrees:rootydirt-dirt");
        this.grassIcon = register.func_94245_a("dynamictrees:rootydirt-grass");
        this.myceliumIcon = register.func_94245_a("dynamictrees:rootydirt-mycelium");
        this.podzolIcon = register.func_94245_a("dynamictrees:rootydirt-podzol");
    }

    public int func_149645_b() {
        return RendererRootyDirt.renderId;
    }

    @Override
    public boolean isRootNode() {
        return true;
    }

    @Override
    public boolean isBranch() {
        return false;
    }
}

