/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.IRegisterable;
import com.ferreusveritas.dynamictrees.api.backport.PropertyInteger;
import com.ferreusveritas.dynamictrees.api.network.IBurningListener;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVerboseFire
extends BlockFire
implements IRegisterable {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 15, PropertyInteger.Bits.BXXXX);
    ResourceLocation name;

    public BlockVerboseFire() {
        this.setRegistryName("fire");
        this.func_149711_c(0.0f);
        this.func_149715_a(1.0f);
        this.func_149672_a(field_149775_l);
        this.setUnlocalizedNameReg("fire");
        this.func_149649_H();
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            com.ferreusveritas.dynamictrees.api.backport.World worldIn = new com.ferreusveritas.dynamictrees.api.backport.World(world);
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = worldIn.getBlockState(pos);
            if (!this.func_149742_c(world, x, y, z)) {
                worldIn.setBlockToAir(pos);
            }
            Block block = worldIn.getBlockState(pos.down()).getBlock();
            boolean onFireSource = block.isFireSource(world, x, y - 1, z, EnumFacing.UP.toForgeDirection());
            int age = state.getValue(AGE);
            if (!onFireSource && worldIn.isRaining() && this.canDie(worldIn, pos) && rand.nextFloat() < 0.2f + (float)age * 0.03f) {
                worldIn.setBlockToAir(pos);
            } else {
                if (age < 15) {
                    state = state.withProperty(AGE, age + rand.nextInt(3) / 2);
                    worldIn.setBlockState(pos, state, 4);
                }
                worldIn.scheduleUpdate(pos, (Block)this, this.func_149738_a(worldIn.real()) + rand.nextInt(10));
                if (!onFireSource) {
                    if (!this.canNeighborCatchFire(worldIn, pos)) {
                        if (!worldIn.getBlockState(pos.down()).isSideSolid(worldIn, pos.down(), EnumFacing.UP) || age > 3) {
                            worldIn.setBlockToAir(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire(worldIn, pos.getX(), pos.down().getY(), pos.getZ(), EnumFacing.UP.toForgeDirection()) && age == 15 && rand.nextInt(4) == 0) {
                        worldIn.setBlockToAir(pos);
                        return;
                    }
                }
                int humidityFactor = worldIn.isBlockinHighHumidity(pos) ? 1 : 0;
                int chanceDelta = humidityFactor * -50;
                for (EnumFacing dir : EnumFacing.VALUES) {
                    int baseChance = dir.getFrontOffsetY() != 0 ? 250 : 300;
                    this.tryCatchFire(worldIn, pos.offset(dir), baseChance + chanceDelta, rand, age, dir.getOpposite());
                }
                for (BlockPos dPos : BlockPos.getAllInBox(pos.add(-1, -1, -1), pos.add(1, 4, 1))) {
                    int heat;
                    int neighEncrg;
                    if (dPos.equals(pos)) continue;
                    int distance = 100;
                    int dy = dPos.getY() - pos.getY();
                    if (dy > 1) {
                        distance += (dy - 1) * 100;
                    }
                    if ((neighEncrg = this.getNeighborEncouragement(worldIn, dPos)) <= 0 || (heat = (neighEncrg + 40 + worldIn.getDifficulty().func_151525_a() * 7) / (age + 30) >> humidityFactor) <= 0 || rand.nextInt(distance) > heat || worldIn.isRaining() && this.canDie(worldIn, dPos)) continue;
                    int newAge = MathHelper.clamp(age + rand.nextInt(5) / 4, 0, 15);
                    worldIn.setBlockState(dPos, new BlockState((Block)this).withProperty(AGE, newAge), 3);
                }
            }
        }
    }

    protected boolean canDie(com.ferreusveritas.dynamictrees.api.backport.World worldIn, BlockPos pos) {
        if (worldIn.isRainingAt(pos)) {
            return true;
        }
        for (EnumFacing dir : EnumFacing.HORIZONTALS) {
            if (!worldIn.isRainingAt(pos.offset(dir))) continue;
            return true;
        }
        return false;
    }

    public void tryCatchFire(com.ferreusveritas.dynamictrees.api.backport.World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int flammability = worldIn.getBlockState(pos).getBlock().getFlammability((IBlockAccess)worldIn.real(), pos.getX(), pos.getY(), pos.getZ(), face.toForgeDirection());
        if (random.nextInt(chance) < flammability) {
            IBlockState iblockstate = worldIn.getBlockState(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.isRainingAt(pos)) {
                int newAge = MathHelper.clamp(age + random.nextInt(5) / 4, 0, 15);
                worldIn.setBlockState(pos, new BlockState((Block)this).withProperty(AGE, newAge), 3);
            } else {
                worldIn.setBlockToAir(pos);
                Block block = iblockstate.getBlock();
                if (block instanceof IBurningListener) {
                    ((IBurningListener)block).onBurned(worldIn, iblockstate, pos);
                }
            }
            if (iblockstate.getBlock() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_149664_b(worldIn.real(), pos.getX(), pos.getY(), pos.getZ(), 1);
            }
        }
    }

    public boolean canNeighborCatchFire(com.ferreusveritas.dynamictrees.api.backport.World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos dPos = pos.offset(enumfacing);
            if (!this.canCatchFire(worldIn, dPos.getX(), dPos.getY(), dPos.getZ(), enumfacing.getOpposite().toForgeDirection())) continue;
            return true;
        }
        return false;
    }

    public int getNeighborEncouragement(com.ferreusveritas.dynamictrees.api.backport.World worldIn, BlockPos pos) {
        if (worldIn.isAirBlock(pos)) {
            int encouragementAccumulator = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                BlockPos dPos = pos.offset(enumfacing);
                encouragementAccumulator = Math.max(worldIn.getBlockState(dPos).getBlock().getFireSpreadSpeed((IBlockAccess)worldIn.real(), dPos.getX(), dPos.getY(), dPos.getZ(), enumfacing.getOpposite().toForgeDirection()), encouragementAccumulator);
            }
            return encouragementAccumulator;
        }
        return 0;
    }

    public void setRegistryName(String name) {
        ModContainer mc = Loader.instance().activeModContainer();
        String domain = mc.getModId().toLowerCase();
        this.setRegistryName(new ResourceLocation(domain, name));
    }

    @Override
    public void setRegistryName(ResourceLocation name) {
        this.name = name;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    @Override
    public void setUnlocalizedNameReg(String unlocalName) {
        this.func_149663_c(unlocalName);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149840_c(int arg) {
        return Blocks.field_150480_ab.func_149840_c(arg);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150480_ab.func_149691_a(side, meta);
    }
}

