/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.genfeatures;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.PropertyInteger;
import com.ferreusveritas.dynamictrees.api.backport.RayTraceResult;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.List;
import net.minecraft.init.Blocks;

public class GenFeatureVine
implements IGenFeature {
    PropertyInteger SOUTH = PropertyInteger.create("south", 0, 1, PropertyInteger.Bits.B000X);
    PropertyInteger WEST = PropertyInteger.create("west", 0, 1, PropertyInteger.Bits.B00X0);
    PropertyInteger NORTH = PropertyInteger.create("north", 0, 1, PropertyInteger.Bits.B0X00);
    PropertyInteger EAST = PropertyInteger.create("east", 0, 1, PropertyInteger.Bits.BX000);
    protected final PropertyInteger[] vineMap = new PropertyInteger[]{null, null, this.NORTH, this.SOUTH, this.WEST, this.EAST};
    protected int qty = 4;
    protected int maxLength = 8;
    protected float verSpread = 60.0f;
    protected float rayDistance = 5.0f;
    protected Species species;

    public GenFeatureVine(Species species) {
        this.species = species;
    }

    public GenFeatureVine setQuantity(int qty) {
        this.qty = qty;
        return this;
    }

    public GenFeatureVine setMaxLength(int length) {
        this.maxLength = length;
        return this;
    }

    public GenFeatureVine setVerSpread(float verSpread) {
        this.verSpread = verSpread;
        return this;
    }

    public GenFeatureVine setRayDistance(float rayDistance) {
        this.rayDistance = rayDistance;
        return this;
    }

    @Override
    public void gen(World world, BlockPos treePos, List<BlockPos> endPoints) {
        if (!endPoints.isEmpty()) {
            for (int i = 0; i < this.qty; ++i) {
                BlockPos endPoint = endPoints.get(world.rand.nextInt(endPoints.size()));
                this.addVine(world, this.species, treePos, endPoint);
            }
        }
    }

    protected void addVine(World world, Species species, BlockPos treePos, BlockPos branchPos) {
        RayTraceResult result = species.branchRayTrace(world, treePos, branchPos, 90.0f, this.verSpread, this.rayDistance);
        if (result != null) {
            BlockPos vinePos = result.getBlockPos().offset(result.sideHit);
            PropertyInteger vineSide = this.vineMap[result.sideHit.getOpposite().getIndex()];
            if (vineSide != null) {
                IBlockState vineState = new BlockState(Blocks.field_150395_bd).withProperty(vineSide, 1);
                int len = MathHelper.clamp(world.rand.nextInt(this.maxLength) + 3, 3, this.maxLength);
                for (int i = 0; i < len && world.isAirBlock(vinePos); ++i) {
                    world.setBlockState(vinePos, vineState);
                    vinePos = vinePos.down();
                }
            }
        }
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.getX() * 4111 ^ pos.getY() * 271 ^ pos.getZ() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

