/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;

public class NodeDestroyer
implements INodeInspector {
    Species species;

    public NodeDestroyer(Species species) {
        this.species = species;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null && this.species.getTree() == branch.getTree()) {
            if (branch.getRadius(world, pos) == 1) {
                this.killSurroundingLeaves(world, pos);
            }
            world.setBlockToAir(pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void killSurroundingLeaves(World world, BlockPos twigPos) {
        if (!world.isRemote && !world.restoringBlockSnapshots()) {
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            DynamicTree tree = this.species.getTree();
            for (BlockPos leavesPos : BlockPos.getAllInBox(twigPos.add(-3, -3, -3), twigPos.add(3, 3, 3))) {
                if (!tree.isCompatibleGenericLeaves(world, leavesPos)) continue;
                world.setBlockToAir(leavesPos);
                dropList.clear();
                this.species.getTreeHarvestDrops(world, leavesPos, dropList, world.rand);
                for (ItemStack stack : dropList) {
                    EntityItem itemEntity = new EntityItem(world.real(), (double)leavesPos.getX() + 0.5, (double)leavesPos.getY() + 0.5, (double)leavesPos.getZ() + 0.5, stack);
                    CompatHelper.spawnEntity(world, (Entity)itemEntity);
                }
            }
        }
    }
}

