/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;

public class NodeFindEnds
implements INodeInspector {
    private List<BlockPos> endPoints;
    private BlockPos last;

    public NodeFindEnds() {
        this.endPoints = new ArrayList<BlockPos>();
        this.last = BlockPos.ORIGIN;
    }

    public NodeFindEnds(List<BlockPos> ends) {
        this.endPoints = ends;
        this.last = BlockPos.ORIGIN;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockPos dPos = pos.subtract(this.last);
        if (dPos.getX() * dPos.getX() + dPos.getY() * dPos.getY() + dPos.getZ() * dPos.getZ() != 1) {
            this.endPoints.add(pos);
        }
        this.last = pos;
        return false;
    }

    public List<BlockPos> getEnds() {
        if (this.endPoints.isEmpty()) {
            this.endPoints.add(this.last);
        }
        return this.endPoints;
    }
}

