/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import net.minecraft.block.Block;

public class NodeFreezer
implements INodeInspector {
    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null && (radius = branch.getRadius(world, pos)) == 1) {
            this.freezeSurroundingLeaves(world, branch, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void freezeSurroundingLeaves(World world, BlockBranch branch, BlockPos twigPos) {
        if (!world.isRemote && !world.restoringBlockSnapshots()) {
            DynamicTree tree = branch.getTree();
            IBlockState primLeaves = tree.getPrimitiveLeaves();
            for (BlockPos leavesPos : BlockPos.getAllInBox(twigPos.add(-3, -3, -3), twigPos.add(3, 3, 3))) {
                if (!tree.isCompatibleGenericLeaves(world, leavesPos)) continue;
                world.setBlockState(leavesPos, primLeaves);
            }
        }
    }
}

