/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.GameRegistry;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.ItemBackport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DirtBucket
extends ItemBackport {
    public static final String name = "dirtbucket";

    public DirtBucket() {
        this(name);
    }

    public DirtBucket(String name) {
        this.func_77637_a(DynamicTrees.dynamicTreesTab);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_111206_d("dynamictrees:" + name);
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    public ItemStack func_77659_a(ItemStack stack, World _world, EntityPlayer player) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(_world);
        MovingObjectPosition movingobjectposition = this.func_77621_a(world.real(), player, false);
        if (movingobjectposition == null) {
            return stack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockPos pos = new BlockPos(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
            if (!world.canMineBlock(player, pos)) {
                return stack;
            }
            if (!player.func_82247_a((pos = pos.offset(EnumFacing.getFront(movingobjectposition.field_72310_e))).getX(), pos.getY(), pos.getZ(), movingobjectposition.field_72310_e, stack)) {
                return stack;
            }
            if (this.tryPlaceContainedDirt(player, world, pos) && !player.field_71075_bZ.field_75098_d) {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return stack;
    }

    public boolean tryPlaceContainedDirt(EntityPlayer player, com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos) {
        IBlockState blockState = world.getBlockState(pos);
        boolean replaceable = blockState.getBlock().isReplaceable((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
        if (replaceable) {
            if (!world.isRemote) {
                world.real().func_147480_a(pos.getX(), pos.getY(), pos.getZ(), true);
            }
            String soundevent = "dig.grass";
            world.playSoundEffect(pos, soundevent, 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            world.setBlockState(pos, new BlockState(Blocks.field_150346_d, 0), 3);
        }
        return true;
    }

    public DirtBucket registerRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ModItems.dirtBucket), (Object[])new Object[]{Blocks.field_150346_d, Items.field_151133_ar});
        return this;
    }

    public boolean func_77630_h(ItemStack itemStack) {
        return false;
    }
}

