/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumActionResult;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.ItemBackport;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class Staff
extends ItemBackport {
    IIcon overlayIcon;
    IIcon glimmerIcon;

    public Staff() {
        this("staff");
    }

    public Staff(String name) {
        this.func_77637_a(DynamicTrees.dynamicTreesTab);
        this.func_77625_d(1);
        this.func_111206_d("dynamictrees:" + name);
        this.setUnlocalizedNameReg(name);
        this.setRegistryName(name);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack heldStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        IBlockState clickedBlock = world.getBlockState(pos);
        ITreePart treePart = TreeHelper.getSafeTreePart(clickedBlock);
        BlockPos rootPos = pos;
        BlockBranch branch = TreeHelper.getBranch(treePart);
        if (branch != null) {
            MapSignal signal = branch.analyse(world, pos, null, new MapSignal());
            if (signal.found) {
                rootPos = signal.root;
                treePart = TreeHelper.getSafeTreePart(world, rootPos);
                if (world.isRemote && treePart.isRootNode()) {
                    BlockRootyDirt rootyDirt = (BlockRootyDirt)treePart;
                    int soilLife = rootyDirt.getSoilLife(world, rootPos);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Rooty Soil Life: " + soilLife));
                }
            }
        }
        if (!this.isReadOnly(heldStack) && treePart.isRootNode() && (species = DynamicTree.getExactSpecies(world, rootPos)) != null) {
            if (!player.func_70093_af()) {
                String code = new JoCode().buildFromTree(world, rootPos, this.getPlayerDirection(player)).toString();
                this.setCode(heldStack, code);
                GuiScreen.func_146275_d((String)code);
            }
            this.setSpecies(heldStack, species);
            return EnumActionResult.SUCCESS;
        }
        species = this.getSpecies(heldStack);
        if (species != null && species.isAcceptableSoil(world, pos, clickedBlock)) {
            new JoCode(this.getCode(heldStack)).setCareful(true).generate(world, species, pos, world.getBiome(pos), this.getPlayerDirection(player), 8);
            CompatHelper.shrinkStack(heldStack, 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public NBTTagCompound getNBT(ItemStack itemStack) {
        return itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
    }

    public boolean isReadOnly(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74767_n("readonly");
    }

    public Staff setReadOnly(ItemStack itemStack, boolean readonly) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74757_a("readonly", readonly);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Staff setSpecies(ItemStack itemStack, Species species) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a("tree", species.toString());
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Staff setCode(ItemStack itemStack, String code) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a("code", code);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Species getSpecies(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b("tree")) {
            return TreeRegistry.findSpecies(new ResourceLocation(nbt.func_74779_i("tree")));
        }
        Species species = TreeRegistry.findSpeciesSloppy("oak");
        this.setSpecies(itemStack, species);
        return species;
    }

    public int getColor(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        int color = 65535;
        if (nbt.func_74764_b("color")) {
            try {
                color = Color.decode(nbt.func_74779_i("color")).getRGB();
            }
            catch (NumberFormatException e) {
                nbt.func_82580_o("color");
            }
        }
        return color;
    }

    public Staff setColor(ItemStack itemStack, String colStr) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a("color", colStr);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public String getCode(ItemStack itemStack) {
        String code = "P";
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b("code")) {
            code = nbt.func_74779_i("code");
        } else {
            nbt.func_74778_a("code", code);
            itemStack.func_77982_d(nbt);
        }
        return code;
    }

    public EnumFacing getPlayerDirection(EntityPlayer player) {
        switch (MathHelper.func_76141_d((float)(player.field_70177_z * 4.0f / 360.0f + 0.5f)) & 3) {
            case 0: {
                return EnumFacing.SOUTH;
            }
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.block;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advancedTooltips) {
        Species species = this.getSpecies(stack);
        tooltip.add("Tree: " + (species != null ? species : "none"));
        tooltip.add("Code: \u00a76" + this.getCode(stack));
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return pass == 1 ? this.getColor(stack) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        switch (pass) {
            default: {
                return this.field_77791_bV;
            }
            case 1: {
                return this.overlayIcon;
            }
            case 2: 
        }
        return this.glimmerIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.overlayIcon = iconRegister.func_94245_a(this.func_111208_A() + "-overlay");
        this.glimmerIcon = iconRegister.func_94245_a(this.func_111208_A() + "-glimmer");
    }
}

