/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.potion;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumParticleTypes;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.inspectors.NodeFreezer;

public class SubstanceFreeze
implements ISubstanceEffect {
    @Override
    public boolean apply(World world, BlockPos rootPos) {
        BlockRootyDirt dirt = TreeHelper.getRootyDirt(world, rootPos);
        if (dirt != null) {
            if (world.isRemote) {
                TreeHelper.treeParticles(world, rootPos, EnumParticleTypes.FIREWORKS_SPARK, 8);
            } else {
                dirt.startAnalysis(world, rootPos, new MapSignal(new NodeFreezer()));
                dirt.fertilize(world, rootPos, -15);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(World world, BlockPos rootPos, int deltaTicks) {
        return false;
    }

    @Override
    public String getName() {
        return "freeze";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

