/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.potion;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumParticleTypes;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;

public class SubstanceGrowth
implements ISubstanceEffect {
    int duration = 1600;

    @Override
    public boolean apply(World world, BlockPos rootPos) {
        return true;
    }

    @Override
    public boolean update(World world, BlockPos rootPos, int deltaTicks) {
        if (deltaTicks > this.duration) {
            return false;
        }
        if (world.isRemote) {
            if (deltaTicks % 8 == 0) {
                TreeHelper.treeParticles(world, rootPos, EnumParticleTypes.SPELL, 2);
            }
        } else if (deltaTicks % 40 == 0) {
            TreeHelper.growPulse(world, rootPos);
        }
        return true;
    }

    @Override
    public String getName() {
        return "growth";
    }

    @Override
    public boolean isLingering() {
        return true;
    }

    public SubstanceGrowth setDuration(int duration) {
        this.duration = duration;
        return this;
    }
}

