/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.proxy;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumParticleTypes;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.proxy.CommonProxy;
import com.ferreusveritas.dynamictrees.renderers.RendererBonsai;
import com.ferreusveritas.dynamictrees.renderers.RendererBranch;
import com.ferreusveritas.dynamictrees.renderers.RendererRootyDirt;
import com.ferreusveritas.dynamictrees.renderers.RendererSapling;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityBlockDustFX;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registerClientEventHandlers();
    }

    @Override
    public void init() {
        super.init();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RendererBonsai());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RendererBranch());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RendererRootyDirt());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RendererSapling());
    }

    @Override
    public void registerModels() {
    }

    public void makePlantsBlue() {
    }

    public void registerClientEventHandlers() {
    }

    @Override
    public void addDustParticle(World world, double fx, double fy, double fz, double mx, double my, double mz, int x, int y, int z, Block block, int metadata) {
        if (world.isRemote) {
            EntityDiggingFX entityfx = new EntityBlockDustFX(world.real(), fx, fy, fz, mx, my, mz, block, metadata).func_70596_a(x, y, z);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
        }
    }

    @Override
    public void spawnParticle(World world, EnumParticleTypes particleType, double x, double y, double z, double mx, double my, double mz) {
        if (world.isRemote) {
            world.real().func_72869_a(particleType.getName(), x, y, z, mx, my, mz);
        }
    }

    @Override
    public void crushLeavesBlock(World world, BlockPos pos, IBlockState blockState, Entity entity) {
        if (world.isRemote) {
            BlockDynamicLeaves leaves;
            DynamicTree tree;
            Random random = world.rand;
            ITreePart treePart = TreeHelper.getTreePart(blockState);
            if (treePart instanceof BlockDynamicLeaves && (tree = (leaves = (BlockDynamicLeaves)treePart).getTree(blockState)) != null) {
                for (int dz = 0; dz < 8; ++dz) {
                    for (int dy = 0; dy < 8; ++dy) {
                        for (int dx = 0; dx < 8; ++dx) {
                            if (random.nextInt(8) != 0) continue;
                            double fx = (double)pos.getX() + (double)dx / 8.0;
                            double fy = (double)pos.getY() + (double)dy / 8.0;
                            double fz = (double)pos.getZ() + (double)dz / 8.0;
                            this.addDustParticle(world, fx, fy, fz, 0.0, (double)random.nextFloat() * entity.field_70181_x, 0.0, pos.getX(), pos.getY(), pos.getZ(), blockState.getBlock(), blockState.getMeta());
                        }
                    }
                }
            }
        }
    }
}

