/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.renderers;

import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.renderers.RendererSapling;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RendererBonsai
implements ISimpleBlockRenderingHandler {
    public static int id;

    public RendererBonsai() {
        id = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = new BlockAccess(blockAccess).getBlockState(pos);
        DynamicTree tree = ((BlockBonsaiPot)block).getTree(blockState);
        RendererBonsai.renderBlockFlowerpot(block, x, y, z, renderer);
        RendererSapling.renderSapling(blockAccess, x, y, z, tree, renderer, 0.25);
        return true;
    }

    public static void renderBlockFlowerpot(Block block, int x, int y, int z, RenderBlocks renderer) {
        renderer.func_147784_q(block, x, y, z);
        int colorMultiplier = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float r = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorMultiplier & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        tessellator.func_78386_a(r, g, b);
        float halfsize = 0.1875f;
        IIcon iconSide = Blocks.field_150457_bL.func_149691_a(0, 0);
        renderer.func_147764_f(block, (double)((float)x - 0.5f + halfsize), (double)y, (double)z, iconSide);
        renderer.func_147798_e(block, (double)((float)x + 0.5f - halfsize), (double)y, (double)z, iconSide);
        renderer.func_147734_d(block, (double)x, (double)y, (double)((float)z - 0.5f + halfsize), iconSide);
        renderer.func_147761_c(block, (double)x, (double)y, (double)((float)z + 0.5f - halfsize), iconSide);
        renderer.func_147806_b(block, (double)x, (double)((float)y - 0.5f + halfsize + 0.1875f), (double)z, renderer.func_147745_b(Blocks.field_150346_d));
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return id;
    }
}

