/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDensityProvider;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.worldgen.IRadiusCoordinator;
import java.util.Random;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class BiomeRadiusCoordinator
implements IRadiusCoordinator {
    NoiseGeneratorPerlin noiseGenerator = new NoiseGeneratorPerlin(new Random(96L), 1);
    IBiomeDensityProvider densityProvider;

    public BiomeRadiusCoordinator(IBiomeDensityProvider densityProvider) {
        this.densityProvider = densityProvider;
    }

    @Override
    public int getRadiusAtCoords(World world, double x, double z) {
        double scale = 128.0;
        Biome biome = world.getBiome(new BlockPos((int)x, 0, (int)z));
        double noiseDensity = (this.noiseGenerator.func_151601_a(x / scale, z / scale) + 1.0) / 2.0;
        double density = this.densityProvider.getDensity(biome, noiseDensity, world.rand);
        double size = (1.0 - density) * 9.0;
        int kindaRandom = ((int)x * 674365771 ^ (int)z * 254326997) >> 4;
        int shakelow = kindaRandom & 3;
        int shakehigh = kindaRandom >> 2 & 3;
        int n = shakelow == 2 ? 1 : (shakelow = shakelow == 3 ? 2 : 0);
        shakehigh = shakehigh == 2 ? 1 : (shakehigh == 3 ? 2 : 0);
        return MathHelper.clamp((int)size, 2 + shakelow, 8 - shakehigh);
    }
}

