/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.util.Circle;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class CircleDebug {
    public static int scale = 8;

    public static void outputCirclesToPng(ArrayList<Circle> circles, int chunkX, int chunkZ, String name) {
        int width = 48 * scale;
        int height = 48 * scale;
        BufferedImage img = new BufferedImage(width, height, 2);
        Color lightGrey = new Color(186, 189, 182);
        Color darkGrey = new Color(136, 138, 133);
        for (int gz = 0; gz < 3; ++gz) {
            for (int gx = 0; gx < 3; ++gx) {
                CircleDebug.drawRect(img, gx * 16 * scale, gz * 16 * scale, 16 * scale, 16 * scale, (gz * 3 + gx) % 2 == 0 ? lightGrey : darkGrey);
            }
        }
        Color blue1 = new Color(0, 0, 128, 32);
        Color blue2 = new Color(0, 64, 128, 32);
        for (int gz = 0; gz < 3; ++gz) {
            for (int gx = 0; gx < 3; ++gx) {
                CircleDebug.drawRect(img, (gx * 16 - 8) * scale, (gz * 16 - 8) * scale, 16 * scale, 16 * scale, (gz * 3 + gx) % 2 == 0 ? blue1 : blue2);
            }
        }
        for (Circle c : circles) {
            CircleDebug.drawCircle(img, c, (chunkX - 1) * 16, (chunkZ - 1) * 16);
        }
        CircleDebug.drawLine(img, 4, 4, 4, 12, Color.BLACK);
        CircleDebug.drawLine(img, 4, 4, 12, 12, Color.BLACK);
        CircleDebug.drawLine(img, 12, 4, 12, 12, Color.BLACK);
        CircleDebug.drawLine(img, 8, 16, 8, 32, Color.RED);
        CircleDebug.drawLine(img, 8, 16, 3, 21, Color.RED);
        CircleDebug.drawLine(img, 8, 16, 13, 21, Color.RED);
        if (name.isEmpty()) {
            name = "unresolved-" + chunkX + ":" + chunkZ;
        }
        Logger.getLogger("dynamictrees").log(Level.INFO, "Writing:" + name + ".png");
        try {
            ImageIO.write((RenderedImage)img, "png", new File("./unsolved/" + name + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void drawCircle(BufferedImage image, Circle circle, int xOffset, int zOffset) {
        Color green = new Color(115, 210, 22, circle.real ? 192 : 64);
        Color red = new Color(204, 0, 0, circle.real ? 192 : 64);
        Color col = circle.hasFreeAngles() ? red : green;
        int startX = circle.x - circle.radius;
        int stopX = circle.x + circle.radius;
        int startZ = circle.z - circle.radius;
        int stopZ = circle.z + circle.radius;
        for (int z = startZ; z <= stopZ; ++z) {
            for (int x = startX; x <= stopX; ++x) {
                if (!circle.isInside(x, z)) continue;
                CircleDebug.drawRect(image, (x - xOffset) * scale, (z - zOffset) * scale, scale, scale, col);
            }
        }
        double radius = (float)circle.radius + 0.5f;
        for (int i = 0; i < 32; ++i) {
            boolean isOn = (circle.arc & 1 << i) != 0;
            double x1 = (double)circle.x + 0.5 + Math.cos(Math.PI * 2 * (double)i / 32.0) * radius;
            double z1 = (double)circle.z + 0.5 + Math.sin(Math.PI * 2 * (double)i / 32.0) * radius;
            double x2 = (double)circle.x + 0.5 + Math.cos(Math.PI * 2 * (double)(i + 1) / 32.0) * radius;
            double z2 = (double)circle.z + 0.5 + Math.sin(Math.PI * 2 * (double)(i + 1) / 32.0) * radius;
            CircleDebug.drawLine(image, (int)((x1 - (double)xOffset) * (double)scale), (int)((z1 - (double)zOffset) * (double)scale), (int)((x2 - (double)xOffset) * (double)scale), (int)((z2 - (double)zOffset) * (double)scale), (i & 1) == 0 ? (isOn ? Color.BLACK : Color.PINK) : (isOn ? Color.DARK_GRAY : Color.CYAN));
        }
    }

    public static void drawLine(BufferedImage image, int x1, int z1, int x2, int z2, Color color) {
        int w = x2 - x1;
        int h = z2 - z1;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
        }
        int numerator = longest >> 1;
        for (int i = 0; i <= longest; ++i) {
            CircleDebug.safeSetRGB(image, x1, z1, color);
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                x1 += dx1;
                z1 += dy1;
                continue;
            }
            x1 += dx2;
            z1 += dy2;
        }
    }

    public static void drawRect(BufferedImage image, int x, int z, int w, int h, Color color) {
        for (int zi = 0; zi < h; ++zi) {
            for (int xi = 0; xi < w; ++xi) {
                CircleDebug.safeSetRGB(image, x + xi, z + zi, color);
            }
        }
    }

    public static void safeSetRGB(BufferedImage image, int x, int z, Color color) {
        if (x >= 0 && z >= 0 && x < image.getWidth() && z < image.getHeight()) {
            color.getAlpha();
            Color dst = new Color(image.getRGB(x, z));
            float dr = (float)dst.getRed() / 255.0f;
            float dg = (float)dst.getGreen() / 255.0f;
            float db = (float)dst.getBlue() / 255.0f;
            float sr = (float)color.getRed() / 255.0f;
            float sg = (float)color.getGreen() / 255.0f;
            float sb = (float)color.getBlue() / 255.0f;
            float sa = (float)color.getAlpha() / 255.0f;
            image.setRGB(x, z, new Color(sr * sa + dr * (1.0f - sa), sg * sa + dg * (1.0f - sa), sb * sa + db * (1.0f - sa)).getRGB());
        }
    }

    public static void initNoisetest() {
        int width = 128;
        int height = 128;
        NoiseGeneratorPerlin noiseGenerator = new NoiseGeneratorPerlin(new Random(2L), 1);
        BufferedImage img = new BufferedImage(width, height, 2);
        for (int oct = 0; oct < 7; ++oct) {
            System.out.println("Noise" + oct);
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    float noise = (float)((noiseGenerator.func_151601_a((double)i / 64.0, (double)j / 64.0) + 1.0) / 2.0);
                    switch (oct) {
                        case 6: {
                            noise += (float)((noiseGenerator.func_151601_a((double)i / 1.0, (double)j / 1.0) + 1.0) / 2.0) / 64.0f;
                        }
                        case 5: {
                            noise += (float)((noiseGenerator.func_151601_a((double)i / 2.0, (double)j / 2.0) + 1.0) / 2.0) / 32.0f;
                        }
                        case 4: {
                            noise += (float)((noiseGenerator.func_151601_a((double)i / 4.0, (double)j / 4.0) + 1.0) / 2.0) / 16.0f;
                        }
                        case 3: {
                            noise += (float)((noiseGenerator.func_151601_a((double)i / 8.0, (double)j / 8.0) + 1.0) / 2.0) / 8.0f;
                        }
                        case 2: {
                            noise += (float)((noiseGenerator.func_151601_a((double)i / 16.0, (double)j / 16.0) + 1.0) / 2.0) / 4.0f;
                        }
                        case 1: {
                            noise += (float)((noiseGenerator.func_151601_a((double)i / 32.0, (double)j / 32.0) + 1.0) / 2.0) / 2.0f;
                        }
                    }
                    int value = (int)(255.0f * (noise /= 2.0f));
                    img.setRGB(i, j, new Color(value, value, value).getRGB());
                }
            }
            try {
                ImageIO.write((RenderedImage)img, "png", new File("./noise" + oct + ".png"));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveImage(BufferedImage img, String directory, String name) throws IOException {
        ImageIO.write((RenderedImage)img, "png", new File(directory + name + ".png"));
    }

    public static void setAlpha(BufferedImage img, int alpha) {
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                Color currentColor = new Color(img.getRGB(i, j));
                Color newColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), alpha);
                img.setRGB(i, j, newColor.getRGB());
            }
        }
    }
}

