/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.util.Circle;
import com.ferreusveritas.dynamictrees.util.Vec2i;
import com.ferreusveritas.dynamictrees.worldgen.CircleDebug;
import java.util.ArrayList;

public class CircleHelper {
    private static int[][] looseMasks = new int[7][7];
    private static byte[][][] pairdata = new byte[7][7][];

    private static void createPairData(int rad1, int rad2, int codeSize, int curveCode, int looseMask) {
        int idx1 = rad1 - 2;
        int idx2 = rad2 - 2;
        byte[] byArray = CircleHelper.uncompressCurve(codeSize, curveCode);
        CircleHelper.pairdata[idx2][idx1] = byArray;
        CircleHelper.pairdata[idx1][idx2] = byArray;
        int n = looseMask;
        CircleHelper.looseMasks[idx2][idx1] = n;
        CircleHelper.looseMasks[idx1][idx2] = n;
    }

    private static byte[] uncompressCurve(int codeSize, long curveCode) {
        byte[] wave = new byte[codeSize + 2];
        for (int i = 0; i <= codeSize; ++i) {
            wave[i + 1] = (byte)((long)wave[i] + (curveCode >> i & 1L));
        }
        return wave;
    }

    private static Vec2i[] getCoordsForPair(int rad1, int rad2, int startAngle, int stopAngle) {
        int idx1 = rad1 - 2;
        int idx2 = rad2 - 2;
        byte[] vsdata = pairdata[idx1][idx2];
        int looseMask = looseMasks[idx1][idx2];
        int codesize = vsdata.length - 2;
        int numAngles = stopAngle - startAngle + 1;
        Vec2i[] c = new Vec2i[numAngles];
        int coordIter = 0;
        for (int angleIter = startAngle; angleIter <= stopAngle; ++angleIter) {
            int vAngle = angleIter % (codesize * 4);
            if (vAngle < 0) {
                vAngle += codesize * 4;
            }
            int modulus = Math.abs((vAngle + codesize) % (codesize * 2) - codesize);
            int n = coordIter++;
            Vec2i vec2i = new Vec2i();
            c[n % c.length] = vec2i;
            Vec2i tc = vec2i;
            tc.x = (-(vAngle / codesize + 1 & 2) + 1) * vsdata[codesize - modulus];
            tc.z = (-(vAngle / codesize & 2) + 1) * vsdata[modulus];
            tc.setLoose((looseMask >> Math.min(modulus - 1, 32) & 1) != 0);
        }
        return c;
    }

    private static int getNumAnglesInPair(int rad1, int rad2) {
        return (pairdata[rad1 - 2][rad2 - 2].length - 2) * 4;
    }

    public static double wrapAngle(double angle) {
        double TwoPi = Math.PI * 2;
        return angle + ((angle %= Math.PI * 2) < 0.0 ? Math.PI * 2 : 0.0);
    }

    public static float radiansToTurns(double angle) {
        return (float)(CircleHelper.wrapAngle(angle) / (Math.PI * 2));
    }

    private static double deltaAngle(double alpha, double beta) {
        double phi = Math.abs(beta - alpha) % (Math.PI * 2);
        double distance = phi > Math.PI ? Math.PI * 2 - phi : phi;
        return distance;
    }

    public static Circle findSecondCircle(Circle cA, int cBrad) {
        double angle = cA.getFreeAngle();
        int pos = (int)(CircleHelper.radiansToTurns(angle) * (float)CircleHelper.getNumAnglesInPair(cA.radius, cBrad));
        Vec2i[] coordList = CircleHelper.getCoordsForPair(cA.radius, cBrad, pos - 2, pos + 2);
        Vec2i closestCoord = coordList[0];
        double closestAngle = Math.PI;
        for (Vec2i c : coordList) {
            double deltaAngle;
            if (c.isLoose() || !((deltaAngle = CircleHelper.deltaAngle(c.angle(), angle)) < closestAngle)) continue;
            closestCoord = c;
            closestAngle = deltaAngle;
        }
        return (Circle)new Circle(closestCoord, cBrad).add(cA.x, cA.z);
    }

    public static Circle findSecondCircle(Circle cA, int cBrad, double angle) {
        angle = Math.toRadians(angle);
        int pos = (int)(CircleHelper.radiansToTurns(angle) * (float)CircleHelper.getNumAnglesInPair(cA.radius, cBrad));
        Vec2i[] coordList = CircleHelper.getCoordsForPair(cA.radius, cBrad, pos - 2, pos + 2);
        Vec2i closestCoord = coordList[0];
        double closestAngle = Math.PI;
        boolean isLoose = false;
        for (Vec2i c : coordList) {
            double deltaAngle = CircleHelper.deltaAngle(c.angle(), angle);
            if (!(deltaAngle < closestAngle)) continue;
            closestCoord = c;
            closestAngle = deltaAngle;
            isLoose = c.isLoose();
        }
        Circle result = (Circle)new Circle(closestCoord, cBrad).add(cA.x, cA.z);
        result.loose = isLoose;
        return result;
    }

    public static Circle findThirdCircle(Circle cA, Circle cB, int cCrad) {
        if (cA == null || cB == null || cCrad < 2 || cCrad > 8) {
            System.err.println("3rd circle condition: Radius out of bounds or null circles");
            return null;
        }
        Circle cC = new Circle(0, 0, cCrad);
        Vec2i delta = new Vec2i(cB.x - cA.x, cB.z - cA.z);
        double lenAB = delta.len();
        int lenAC = cA.radius + cC.radius;
        int lenBC = cB.radius + cC.radius;
        double angA = Math.acos(((double)(lenAC * lenAC) + lenAB * lenAB - (double)(lenBC * lenBC)) / ((double)(2 * lenAC) * lenAB));
        double angB = Math.acos(((double)(lenBC * lenBC) + lenAB * lenAB - (double)(lenAC * lenAC)) / ((double)(2 * lenBC) * lenAB));
        double angAB = delta.angle();
        double angBAC = CircleHelper.wrapAngle(angAB - angA);
        double angABC = CircleHelper.wrapAngle(-Math.PI + angAB + angB);
        int posAC = (int)(CircleHelper.radiansToTurns(angBAC) * (float)CircleHelper.getNumAnglesInPair(cA.radius, cC.radius));
        int posBC = (int)(CircleHelper.radiansToTurns(angABC) * (float)CircleHelper.getNumAnglesInPair(cB.radius, cC.radius));
        Vec2i[] coordListAC = CircleHelper.getCoordsForPair(cA.radius, cC.radius, posAC - 2, posAC + 2);
        Vec2i[] coordListBC = CircleHelper.getCoordsForPair(cB.radius, cC.radius, posBC - 2, posBC + 2);
        Vec2i a = new Vec2i();
        Vec2i b = new Vec2i();
        boolean solution = false;
        for (int ac = 0; ac < coordListAC.length; ++ac) {
            for (int bc = 0; bc < coordListBC.length; ++bc) {
                a.set(coordListAC[ac]).add(cA.x, cA.z);
                b.set(coordListBC[bc]).add(cB.x, cB.z);
                if (a.x != b.x || a.z != b.z) continue;
                cC.set(a);
                boolean bl = solution = !a.loose || !b.loose;
                if (a.loose || b.loose) continue;
                return cC;
            }
        }
        if (!solution && ModConfigs.worldGenDebug) {
            ArrayList<Circle> circles = new ArrayList<Circle>();
            Circle cAtemp = new Circle(cA);
            Circle cBtemp = new Circle(cB);
            if (cAtemp.x < cBtemp.x) {
                cBtemp.x -= cAtemp.x;
                cAtemp.x = 0;
            } else {
                cAtemp.x -= cBtemp.x;
                cBtemp.x = 0;
            }
            if (cAtemp.z < cBtemp.z) {
                cBtemp.z -= cAtemp.z;
                cAtemp.z = 0;
            } else {
                cAtemp.z -= cBtemp.z;
                cBtemp.z = 0;
            }
            circles.add(cAtemp);
            circles.add(cBtemp);
            circles.add(new Circle(24, 24, cCrad));
            CircleDebug.outputCirclesToPng(circles, 0, 0, "NSF:" + System.currentTimeMillis());
            System.err.println("3rd circle condition: No solution found");
            System.err.println("CircleA:" + cA);
            System.err.println("CircleB:" + cB);
            System.err.println("RadiusC:" + cCrad);
        }
        return solution ? cC : null;
    }

    public static void maskCircles(Circle c1, Circle c2) {
        CircleHelper.maskCircles(c1, c2, false);
    }

    public static void maskCircles(Circle c1, Circle c2, boolean force) {
        if (c1 == c2) {
            return;
        }
        Vec2i delta = new Vec2i(c2.x - c1.x, c2.z - c1.z);
        double angle = delta.angle();
        double dist = delta.len();
        if (force || c2.isInside(c1.x + (int)((double)(delta.x * (c1.radius + 2)) / dist), c1.z + (int)((double)(delta.z * (c1.radius + 2)) / dist))) {
            double ang;
            if (c1.hasFreeAngles()) {
                ang = Math.asin(((double)c2.radius + 1.5) / dist);
                c1.maskArc(angle - ang, angle + ang);
            }
            if (c2.hasFreeAngles()) {
                ang = Math.asin(((double)c1.radius + 1.5) / dist);
                c2.maskArc(angle - ang + Math.PI, angle + ang + Math.PI);
            }
        }
    }

    public static void solveCircles(ArrayList<Circle> unsolved, ArrayList<Circle> allCircles) {
        for (Circle u : unsolved) {
            for (Circle c : allCircles) {
                CircleHelper.maskCircles(u, c);
            }
        }
    }

    public static ArrayList<Circle> gatherUnsolved(ArrayList<Circle> unsolved, ArrayList<Circle> allCircles) {
        unsolved.clear();
        for (int ci = 0; ci < allCircles.size(); ++ci) {
            Circle c = allCircles.get(ci);
            if (!c.hasFreeAngles()) continue;
            unsolved.add(c);
        }
        return unsolved;
    }

    public static void fastRemove(ArrayList<Circle> circles, int index) {
        Circle c = circles.remove(circles.size() - 1);
        if (index < circles.size()) {
            circles.set(index, c);
        }
    }

    static {
        CircleHelper.createPairData(8, 8, 32, 76895967, 76895376);
        CircleHelper.createPairData(8, 7, 30, 19224287, 19223680);
        CircleHelper.createPairData(8, 6, 28, 4806367, 4805776);
        CircleHelper.createPairData(8, 5, 26, 1223391, 1223312);
        CircleHelper.createPairData(8, 4, 24, 305887, 305808);
        CircleHelper.createPairData(8, 3, 22, 152943, 152904);
        CircleHelper.createPairData(8, 2, 20, 38255, 38216);
        CircleHelper.createPairData(7, 7, 28, 4806367, 4805776);
        CircleHelper.createPairData(7, 6, 26, 1201887, 1201296);
        CircleHelper.createPairData(7, 5, 24, 305887, 305808);
        CircleHelper.createPairData(7, 4, 22, 76511, 76432);
        CircleHelper.createPairData(7, 3, 20, 38255, 38216);
        CircleHelper.createPairData(7, 2, 18, 9583, 9544);
        CircleHelper.createPairData(6, 6, 24, 300767, 300176);
        CircleHelper.createPairData(6, 5, 22, 76511, 76432);
        CircleHelper.createPairData(6, 4, 20, 19167, 19088);
        CircleHelper.createPairData(6, 3, 18, 9583, 9544);
        CircleHelper.createPairData(6, 2, 16, 2415, 2376);
        CircleHelper.createPairData(5, 5, 20, 21855, 21840);
        CircleHelper.createPairData(5, 4, 18, 5471, 5456);
        CircleHelper.createPairData(5, 3, 16, 2735, 2728);
        CircleHelper.createPairData(5, 2, 14, 687, 680);
        CircleHelper.createPairData(4, 4, 16, 1375, 1360);
        CircleHelper.createPairData(4, 3, 14, 687, 680);
        CircleHelper.createPairData(4, 2, 12, 175, 168);
        CircleHelper.createPairData(3, 3, 12, 343, 340);
        CircleHelper.createPairData(3, 2, 10, 87, 84);
        CircleHelper.createPairData(2, 2, 8, 23, 20);
    }
}

