/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackTile;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import train.common.entity.rollingStock.EntityTracksBuilder;
import train.common.items.ItemTCRail;

public abstract class RailTools {
    public static boolean isRailBlockAt(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockRailBase;
    }

    public static boolean placeRailAt(EntityTracksBuilder builder, ItemStack stack, World world, int i, int j, int k) {
        return false;
    }

    public static boolean isTrackItem(ItemStack stack) {
        return stack != null && (stack.func_77973_b() instanceof ITrackItem || stack.func_77973_b() instanceof ItemTCRail);
    }

    public static boolean isCartLockedDown(EntityMinecart cart) {
        TileEntity tile;
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)cart.field_70165_t);
        if (BlockRailBase.func_150049_b_((World)cart.field_70170_p, (int)x, (int)((y = MathHelper.func_76128_c((double)cart.field_70163_u)) - 1), (int)(z = MathHelper.func_76128_c((double)cart.field_70161_v)))) {
            --y;
        }
        if ((tile = cart.field_70170_p.func_147438_o(x, y, z)) instanceof ITrackTile) {
            ITrackInstance track = ((ITrackTile)tile).getTrackInstance();
            return track instanceof ITrackLockdown && ((ITrackLockdown)track).isCartLockedDown(cart);
        }
        if (tile instanceof ITrackLockdown) {
            return ((ITrackLockdown)tile).isCartLockedDown(cart);
        }
        return false;
    }

    public static int countAdjecentTracks(World world, int x, int y, int z) {
        int i = 0;
        if (RailTools.isTrackFuzzyAt(world, x, y, z - 1)) {
            ++i;
        }
        if (RailTools.isTrackFuzzyAt(world, x, y, z + 1)) {
            ++i;
        }
        if (RailTools.isTrackFuzzyAt(world, x - 1, y, z)) {
            ++i;
        }
        if (RailTools.isTrackFuzzyAt(world, x + 1, y, z)) {
            ++i;
        }
        return i;
    }

    public static boolean isTrackFuzzyAt(World world, int x, int y, int z) {
        return BlockRailBase.func_150049_b_((World)world, (int)x, (int)y, (int)z) ? true : (BlockRailBase.func_150049_b_((World)world, (int)x, (int)(y + 1), (int)z) ? true : BlockRailBase.func_150049_b_((World)world, (int)x, (int)(y - 1), (int)z));
    }

    public static Set<ITrackTile> getAdjecentTrackTiles(World world, int x, int y, int z) {
        HashSet<ITrackTile> tracks = new HashSet<ITrackTile>();
        ITrackTile tile = RailTools.getTrackFuzzyAt(world, x, y, z - 1);
        if (tile != null) {
            tracks.add(tile);
        }
        if ((tile = RailTools.getTrackFuzzyAt(world, x, y, z + 1)) != null) {
            tracks.add(tile);
        }
        if ((tile = RailTools.getTrackFuzzyAt(world, x - 1, y, z)) != null) {
            tracks.add(tile);
        }
        if ((tile = RailTools.getTrackFuzzyAt(world, x + 1, y, z)) != null) {
            tracks.add(tile);
        }
        return tracks;
    }

    public static ITrackTile getTrackFuzzyAt(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ITrackTile) {
            return (ITrackTile)tile;
        }
        tile = world.func_147438_o(x, y + 1, z);
        if (tile instanceof ITrackTile) {
            return (ITrackTile)tile;
        }
        tile = world.func_147438_o(x, y - 1, z);
        if (tile instanceof ITrackTile) {
            return (ITrackTile)tile;
        }
        return null;
    }

    public static <T> Set<T> getAdjecentTrackObjects(World world, int x, int y, int z, Class<T> type) {
        HashSet<T> tracks = new HashSet<T>();
        T object = RailTools.getTrackObjectFuzzyAt(world, x, y, z - 1, type);
        if (object != null) {
            tracks.add(object);
        }
        if ((object = RailTools.getTrackObjectFuzzyAt(world, x, y, z + 1, type)) != null) {
            tracks.add(object);
        }
        if ((object = RailTools.getTrackObjectFuzzyAt(world, x - 1, y, z, type)) != null) {
            tracks.add(object);
        }
        if ((object = RailTools.getTrackObjectFuzzyAt(world, x + 1, y, z, type)) != null) {
            tracks.add(object);
        }
        return tracks;
    }

    public static <T> T getTrackObjectFuzzyAt(World world, int x, int y, int z, Class<T> type) {
        T object = RailTools.getTrackObjectAt(world, x, y, z, type);
        if (object != null) {
            return object;
        }
        object = RailTools.getTrackObjectAt(world, x, y + 1, z, type);
        if (object != null) {
            return object;
        }
        object = RailTools.getTrackObjectAt(world, x, y - 1, z, type);
        if (object != null) {
            return object;
        }
        return null;
    }

    public static <T> T getTrackObjectAt(World world, int x, int y, int z, Class<T> type) {
        ITrackInstance track;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        if (type.isInstance(tile)) {
            return (T)tile;
        }
        if (tile instanceof ITrackTile && type.isInstance(track = ((ITrackTile)tile).getTrackInstance())) {
            return (T)track;
        }
        return null;
    }
}

