/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import java.util.ArrayList;
import tmt.ModelRendererTurbo;
import tmt.TexturedPolygon;
import tmt.TexturedVertex;
import tmt.Vec3f;

public class CylinderBuilder {
    private ModelRendererTurbo root;
    private float x;
    private float y;
    private float z;
    private float radius;
    private float radius2;
    private float length;
    private float base_scale;
    private float top_scale;
    private int segments;
    private int seglimit;
    private int direction;
    private int texDiameterW;
    private int texDiameterH;
    private int texHeight;
    private Vec3f topoff = new Vec3f();
    private boolean[] togglesides = new boolean[]{false, false, false, false};
    private Vec3f toprot;
    private boolean radialtexture = false;
    private float seg_width;
    private float seg_height;

    public CylinderBuilder(ModelRendererTurbo root) {
        this.root = root == null ? new ModelRendererTurbo("") : root;
    }

    public CylinderBuilder setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public CylinderBuilder setRadius(float first, float second) {
        this.radius = first;
        this.radius2 = second;
        this.texDiameterW = (int)Math.floor(this.radius * 2.0f);
        this.texDiameterH = (int)Math.floor(this.radius * 2.0f);
        return this;
    }

    public CylinderBuilder setTextureDiameter(int width, int height) {
        this.texDiameterW = width;
        this.texDiameterH = height;
        return this;
    }

    public CylinderBuilder setLength(float length) {
        this.length = length;
        this.texHeight = (int)Math.floor(length);
        return this;
    }

    public CylinderBuilder setTextureHeight(int height) {
        this.texHeight = height;
        return this;
    }

    public CylinderBuilder setTopOffset(float x, float y, float z) {
        this.topoff = new Vec3f(x, y, z);
        return this;
    }

    public CylinderBuilder setTopOffset(Vec3f vec) {
        this.topoff = vec;
        return this;
    }

    public CylinderBuilder setSidesVisible(boolean[] arr) {
        this.togglesides = arr;
        return this;
    }

    public CylinderBuilder setSidesVisible(boolean base, boolean top, boolean outer, boolean inner) {
        this.togglesides = new boolean[]{base, top, outer, inner};
        return this;
    }

    public CylinderBuilder setSegments(int amount, int limit) {
        this.segments = amount;
        this.seglimit = limit;
        return this;
    }

    public CylinderBuilder setScale(float base, float top) {
        this.base_scale = base;
        this.top_scale = top;
        return this;
    }

    public CylinderBuilder setRadialTexture(float seg_width, float seg_height) {
        if (seg_width == 0.0f && seg_height == 0.0f) {
            return this;
        }
        this.radialtexture = true;
        this.seg_width = seg_width;
        this.seg_height = seg_height;
        return this;
    }

    public CylinderBuilder setDirection(int dir) {
        this.direction = dir;
        return this;
    }

    public CylinderBuilder setTopRotation(float x, float y, float z) {
        this.toprot = new Vec3f(x, y, z);
        return this;
    }

    public CylinderBuilder setTopRotation(Vec3f vec) {
        return this.setTopRotation(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    public CylinderBuilder removePolygon(int index) {
        if (index >= 0 && index < 4) {
            this.togglesides[index] = true;
        }
        return this;
    }

    public CylinderBuilder removePolygons(int ... poly_indices) {
        for (int index : poly_indices) {
            if (index < 0 || index >= 4) continue;
            this.togglesides[index] = true;
        }
        return this;
    }

    public CylinderBuilder removePolygons(boolean ... sides) {
        for (int index = 0; index < 4; ++index) {
            if (sides.length < index + 1 || !sides[index]) continue;
            this.togglesides[index] = true;
        }
        return this;
    }

    public ModelRendererTurbo build() {
        boolean dirMirror;
        if (this.radius2 == 0.0f && this.toprot == null) {
            return this.root.addCylinder(this.x, this.y, this.z, this.radius, this.length, this.segments, this.base_scale, this.top_scale, this.direction, this.texDiameterW, this.texDiameterH, this.texHeight, this.topoff);
        }
        if (this.radius < 1.0f) {
            this.texDiameterW = 2;
            this.texDiameterH = 2;
        }
        if (this.length < 1.0f) {
            this.texHeight = 2;
        }
        boolean dirTop = this.direction == 4 || this.direction == 5;
        boolean dirSide = this.direction == 3 || this.direction == 2;
        boolean dirFront = this.direction == 0 || this.direction == 1;
        boolean bl = dirMirror = this.direction == 2 || this.direction == 5 || this.direction == 1;
        if (this.base_scale == 0.0f) {
            this.base_scale = 1.0f;
        }
        if (this.top_scale == 0.0f) {
            this.top_scale = 1.0f;
        }
        if (this.segments < 3) {
            this.segments = 3;
        }
        if (this.seglimit <= 0) {
            this.seglimit = this.segments;
        }
        boolean segl = this.seglimit < this.segments;
        ArrayList<TexturedPolygon> polis = new ArrayList<TexturedPolygon>();
        float xLength = dirSide ? this.length : 0.0f;
        float yLength = dirTop ? this.length : 0.0f;
        float zLength = dirFront ? this.length : 0.0f;
        float xStart = dirMirror ? this.x + xLength : this.x;
        float yStart = dirMirror ? this.y + yLength : this.y;
        float zStart = dirMirror ? this.z + zLength : this.z;
        float xEnd = (!dirMirror ? this.x + xLength : this.x) + (this.topoff == null ? 0.0f : this.topoff.xCoord);
        float yEnd = (!dirMirror ? this.y + yLength : this.y) + (this.topoff == null ? 0.0f : this.topoff.yCoord);
        float zEnd = (!dirMirror ? this.z + zLength : this.z) + (this.topoff == null ? 0.0f : this.topoff.zCoord);
        float xCur = xStart;
        float yCur = yStart;
        float zCur = zStart;
        float sCur = this.base_scale;
        float uScale = 1.0f / (float)this.root.textureWidth;
        float vScale = 1.0f / (float)this.root.textureHeight;
        float uOffset = uScale / 20.0f;
        float vOffset = vScale / 20.0f;
        float uCircle = (float)this.texDiameterW * uScale;
        float vCircle = (float)this.texDiameterH * vScale;
        float uCircle2 = (float)((int)Math.floor(this.radius2 * 2.0f)) * uScale;
        float vCircle2 = (float)((int)Math.floor(this.radius2 * 2.0f)) * vScale;
        float uWidth = (uCircle * 2.0f - uOffset * 2.0f) / (float)this.segments;
        float vHeight = (float)this.texHeight * vScale - uOffset * 2.0f;
        float uStart = (float)this.root.textureOffsetX * uScale;
        float vStart = (float)this.root.textureOffsetY * vScale;
        ArrayList<TexturedVertex> verts0 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts1 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts2 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts3 = new ArrayList<TexturedVertex>();
        for (int repeat = 0; repeat < 2; ++repeat) {
            float mul;
            float xSize;
            for (int index = 0; index < this.segments; ++index) {
                xSize = (float)((double)(this.root.mirror ^ dirMirror ? -1 : 1) * Math.sin((float)Math.PI / (float)this.segments * (float)index * 2.0f + (float)Math.PI) * (double)this.radius * (double)sCur);
                float zSize = (float)(-Math.cos((float)Math.PI / (float)this.segments * (float)index * 2.0f + (float)Math.PI) * (double)this.radius * (double)sCur);
                float xPlace = xCur + (!dirSide ? xSize : 0.0f);
                float yPlace = yCur + (!dirTop ? zSize : 0.0f);
                float zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                verts0.add(new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f));
                if (index == this.segments - 1) {
                    verts0.add(new TexturedVertex((TexturedVertex)verts0.get(0)));
                }
                xSize = (float)((double)(this.root.mirror ^ dirMirror ? -1 : 1) * Math.sin((float)Math.PI / (float)this.segments * (float)index * 2.0f + (float)Math.PI) * (double)this.radius2 * (double)sCur);
                zSize = (float)(-Math.cos((float)Math.PI / (float)this.segments * (float)index * 2.0f + (float)Math.PI) * (double)this.radius2 * (double)sCur);
                xPlace = xCur + (!dirSide ? xSize : 0.0f);
                yPlace = yCur + (!dirTop ? zSize : 0.0f);
                zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                verts1.add(new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f));
                if (index != this.segments - 1) continue;
                verts1.add(new TexturedVertex((TexturedVertex)verts1.get(0)));
            }
            if (repeat == 0) {
                verts2.addAll(verts0);
                verts2.addAll(verts1);
            } else {
                verts3.addAll(verts0);
                verts3.addAll(verts1);
            }
            float f = this.radialtexture ? (repeat == 0 ? 0.0f : this.seg_height) : (mul = repeat == 0 ? 0.5f : 1.5f);
            if (repeat == 0 && !this.togglesides[0] || repeat == 1 && !this.togglesides[1]) {
                for (int i = 0; i < verts0.size(); ++i) {
                    if (i >= verts0.size() - 1 || i >= this.seglimit) {
                        if (repeat == 0 || this.toprot == null) break;
                        ((TexturedVertex)verts0.get((int)i)).vector3F = this.toprot.getRelativeVector(((TexturedVertex)verts0.get((int)i)).vector3F);
                        ((TexturedVertex)verts1.get((int)i)).vector3F = this.toprot.getRelativeVector(((TexturedVertex)verts1.get((int)i)).vector3F);
                        break;
                    }
                    TexturedVertex[] arr = new TexturedVertex[4];
                    if (!this.radialtexture) {
                        xSize = (float)(Math.sin((float)Math.PI / (float)this.segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
                        float ySize = (float)(Math.cos((float)Math.PI / (float)this.segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
                        arr[0] = ((TexturedVertex)verts0.get(i)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                        xSize = (float)(Math.sin((float)Math.PI / (float)this.segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle2 - 2.0f * uOffset));
                        ySize = (float)(Math.cos((float)Math.PI / (float)this.segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle2 - 2.0f * vOffset));
                        arr[1] = ((TexturedVertex)verts1.get(i)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                        xSize = (float)(Math.sin((float)Math.PI / (float)this.segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle2 - 2.0f * uOffset));
                        ySize = (float)(Math.cos((float)Math.PI / (float)this.segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle2 - 2.0f * vOffset));
                        arr[2] = ((TexturedVertex)verts1.get(i + 1)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                        xSize = (float)(Math.sin((float)Math.PI / (float)this.segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
                        ySize = (float)(Math.cos((float)Math.PI / (float)this.segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
                        arr[3] = ((TexturedVertex)verts0.get(i + 1)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                    } else {
                        float diff = (this.radius - this.radius2) * uScale / 4.0f;
                        arr[0] = ((TexturedVertex)verts0.get(i)).setTexturePosition(uStart + (float)i * this.seg_width * uScale, vStart + mul * vScale);
                        arr[1] = ((TexturedVertex)verts1.get(i)).setTexturePosition(uStart + (float)i * this.seg_width * uScale + diff, vStart + (this.seg_height + mul) * vScale);
                        arr[2] = ((TexturedVertex)verts1.get(i + 1)).setTexturePosition(uStart + (float)(i + 1) * this.seg_width * uScale - diff, vStart + (this.seg_height + mul) * vScale);
                        arr[3] = ((TexturedVertex)verts0.get(i + 1)).setTexturePosition(uStart + (float)(i + 1) * this.seg_width * uScale, vStart + mul * vScale);
                    }
                    if (repeat != 0 && this.toprot != null) {
                        arr[0].vector3F = ((TexturedVertex)verts0.get((int)i)).vector3F = this.toprot.getRelativeVector(arr[0].vector3F);
                        arr[1].vector3F = ((TexturedVertex)verts1.get((int)i)).vector3F = this.toprot.getRelativeVector(arr[1].vector3F);
                        arr[2].vector3F = this.toprot.getRelativeVector(arr[2].vector3F);
                        arr[3].vector3F = this.toprot.getRelativeVector(arr[3].vector3F);
                    }
                    polis.add(new TexturedPolygon(arr));
                    if (repeat == 0 == dirFront) continue;
                    ((TexturedPolygon)polis.get(polis.size() - 1)).flipFace();
                }
            }
            verts0.clear();
            verts1.clear();
            xCur = xEnd;
            yCur = yEnd;
            zCur = zEnd;
            sCur = this.top_scale;
        }
        int halfv2 = verts2.size() / 2;
        if (this.radialtexture) {
            vCircle = (this.seg_height + this.seg_height) * vScale;
        }
        for (int i = 0; i < halfv2; ++i) {
            if (i >= this.seglimit && segl) {
                TexturedVertex[] arr = new TexturedVertex[4];
                float xpos = uStart + uOffset + uCircle * 2.0f;
                arr[0] = ((TexturedVertex)verts2.get(0)).setTexturePosition(xpos, vStart + vOffset + vCircle);
                arr[1] = ((TexturedVertex)verts3.get(0)).setTexturePosition(xpos, vStart + vOffset + vCircle + vHeight);
                arr[2] = ((TexturedVertex)verts3.get(halfv2)).setTexturePosition(xpos + (this.radius - this.radius2) * uScale, vStart + vOffset + vCircle + vHeight);
                arr[3] = ((TexturedVertex)verts2.get(halfv2)).setTexturePosition(xpos + (this.radius - this.radius2) * uScale, vStart + vOffset + vCircle);
                polis.add(new TexturedPolygon(arr));
                if (!dirFront) {
                    ((TexturedPolygon)polis.get(polis.size() - 1)).flipFace();
                }
                arr = new TexturedVertex[]{((TexturedVertex)verts2.get(this.seglimit)).setTexturePosition(xpos, vStart + vOffset + vCircle + vHeight), ((TexturedVertex)verts3.get(this.seglimit)).setTexturePosition(xpos, vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts3.get(this.seglimit + halfv2)).setTexturePosition(xpos + (this.radius - this.radius2) * uScale, vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts2.get(this.seglimit + halfv2)).setTexturePosition(xpos + (this.radius - this.radius2) * uScale, vStart + vOffset + vCircle + vHeight)};
                polis.add(new TexturedPolygon(arr));
                if (!dirFront) break;
                ((TexturedPolygon)polis.get(polis.size() - 1)).flipFace();
                break;
            }
            if (i >= halfv2 - 1) break;
            TexturedVertex[] arr = new TexturedVertex[4];
            if (!this.togglesides[2]) {
                arr[0] = ((TexturedVertex)verts2.get(i + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle);
                arr[1] = ((TexturedVertex)verts3.get(i + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle + vHeight);
                arr[2] = ((TexturedVertex)verts3.get(i + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle + vHeight);
                arr[3] = ((TexturedVertex)verts2.get(i + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle);
                polis.add(new TexturedPolygon(arr));
                if (dirFront) {
                    ((TexturedPolygon)polis.get(polis.size() - 1)).flipFace();
                }
            }
            if (this.togglesides[3]) continue;
            arr = new TexturedVertex[]{((TexturedVertex)verts2.get(i + halfv2 + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle + vHeight), ((TexturedVertex)verts3.get(i + halfv2 + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts3.get(i + halfv2 + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts2.get(i + halfv2 + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle + vHeight)};
            polis.add(new TexturedPolygon(arr));
            if (dirFront) continue;
            ((TexturedPolygon)polis.get(polis.size() - 1)).flipFace();
        }
        return this.root.copyTo(null, polis.toArray(new TexturedPolygon[0]));
    }
}

