/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import tmt.Coord2D;
import tmt.CylinderBuilder;
import tmt.ModelPool;
import tmt.ModelPoolEntry;
import tmt.Shape2D;
import tmt.Shape3D;
import tmt.Tessellator;
import tmt.TextureGroup;
import tmt.TexturedPolygon;
import tmt.TexturedVertex;
import tmt.Vec3f;

public class ModelRendererTurbo {
    public List<TexturedPolygon> faces = new ArrayList<TexturedPolygon>();
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public int textureOffsetX;
    public int textureWidth;
    public int textureOffsetY;
    public int textureHeight;
    public boolean compiled = false;
    private int displayList = 0;
    private int[] displayListArray;
    public Map<String, TextureGroup> textureGroup = new HashMap<String, TextureGroup>();
    private TextureGroup currentTextureGroup;
    public boolean mirror = false;
    public boolean flip = false;
    public boolean rotorder = false;
    public boolean showModel = true;
    public boolean field_1402_i = false;
    public boolean forcedRecompile = false;
    public boolean useLegacyCompiler;
    public List<?> childModels;
    public String boxName;
    public boolean isShape = false;
    private String defaultTexture;
    public static final int MR_FRONT = 0;
    public static final int MR_BACK = 1;
    public static final int MR_LEFT = 2;
    public static final int MR_RIGHT = 3;
    public static final int MR_TOP = 4;
    public static final int MR_BOTTOM = 5;
    public float xScale;
    public float yScale;
    public float zScale;
    public static final float pi = (float)Math.PI;

    public ModelRendererTurbo(Object Object2, String s) {
        this.textureGroup.put("0", new TextureGroup());
        this.currentTextureGroup = this.textureGroup.get("0");
        this.boxName = s;
        this.defaultTexture = "";
        this.useLegacyCompiler = true;
    }

    public ModelRendererTurbo(Object Object2) {
        this(Object2, "");
    }

    public ModelRendererTurbo(Object Object2, int textureX, int textureY) {
        this(Object2, textureX, textureY, 64, 32);
    }

    public ModelRendererTurbo(Object Object2, int textureX, int textureY, int textureU, int textureV) {
        this(Object2);
        this.textureOffsetX = textureX;
        this.textureOffsetY = textureY;
        this.textureWidth = textureU;
        this.textureHeight = textureV;
    }

    public ModelRendererTurbo(Object Object2, int textureX, int textureY, int textureU, int textureV, String boxName) {
        this(Object2, boxName);
        this.textureOffsetX = textureX;
        this.textureOffsetY = textureY;
        this.textureWidth = textureU;
        this.textureHeight = textureV;
    }

    public void addPolygon(TexturedVertex[] verts) {
        this.copyTo(verts, new TexturedPolygon[]{new TexturedPolygon(verts)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(TexturedVertex[] verts, int[][] uv) {
        try {
            for (int i = 0; i < verts.length; ++i) {
                verts[i] = verts[i].setTexturePosition(uv[i][0] / this.textureWidth, uv[i][1] / this.textureHeight);
            }
        }
        finally {
            this.addPolygon(verts);
        }
    }

    public void addPolygon(TexturedVertex[] verts, int u1, int v1, int u2, int v2) {
        this.copyTo(verts, new TexturedPolygon[]{this.addPolygonReturn(verts, u1, v1, u2, v2)});
    }

    private TexturedPolygon addPolygonReturn(TexturedVertex[] verts, float f, float g, float h, float j) {
        if (verts.length < 3) {
            return null;
        }
        float uOffs = 1.0f / ((float)this.textureWidth * 10.0f);
        float vOffs = 1.0f / ((float)this.textureHeight * 10.0f);
        if (verts.length < 4) {
            float xMin = -1.0f;
            float yMin = -1.0f;
            float xMax = 0.0f;
            float yMax = 0.0f;
            for (int i = 0; i < verts.length; ++i) {
                float xPos = verts[i].textureX;
                float yPos = verts[i].textureY;
                xMax = Math.max(xMax, xPos);
                xMin = xMin < -1.0f ? xPos : Math.min(xMin, xPos);
                yMax = Math.max(yMax, yPos);
                yMin = yMin < -1.0f ? yPos : Math.min(yMin, yPos);
            }
            float uMin = f / (float)this.textureWidth + uOffs;
            float vMin = g / (float)this.textureHeight + vOffs;
            float uSize = (h - f) / (float)this.textureWidth - uOffs * 2.0f;
            float vSize = (j - g) / (float)this.textureHeight - vOffs * 2.0f;
            float xSize = xMax - xMin;
            float ySize = yMax - yMin;
            for (int i = 0; i < verts.length; ++i) {
                float xPos = verts[i].textureX;
                float yPos = verts[i].textureY;
                xPos = (xPos - xMin) / xSize;
                yPos = (yPos - yMin) / ySize;
                verts[i] = verts[i].setTexturePosition(uMin + xPos * uSize, vMin + yPos * vSize);
            }
        } else {
            verts[0] = verts[0].setTexturePosition(h / (float)this.textureWidth - uOffs, g / (float)this.textureHeight + vOffs);
            verts[1] = verts[1].setTexturePosition(f / (float)this.textureWidth + uOffs, g / (float)this.textureHeight + vOffs);
            verts[2] = verts[2].setTexturePosition(f / (float)this.textureWidth + uOffs, j / (float)this.textureHeight - vOffs);
            verts[3] = verts[3].setTexturePosition(h / (float)this.textureWidth - uOffs, j / (float)this.textureHeight - vOffs);
        }
        return new TexturedPolygon(verts);
    }

    public ModelRendererTurbo addRectShape(float[] v, float[] v1, float[] v2, float[] v3, float[] v4, float[] v5, float[] v6, float[] v7, float w, float h, float d) {
        return this.addRectShape(v, v1, v2, v3, v4, v5, v6, v7, w, h, d, null);
    }

    public ModelRendererTurbo addRectShape(float[] v0, float[] v1, float[] v2, float[] v3, float[] v4, float[] v5, float[] v6, float[] v7, float w, float h, float d, boolean[] sides) {
        TexturedPolygon[] poly = new TexturedPolygon[6];
        TexturedVertex tv0 = new TexturedVertex(v0[0], v0[1], v0[2], 0.0f, 0.0f);
        TexturedVertex tv1 = new TexturedVertex(v1[0], v1[1], v1[2], 0.0f, 8.0f);
        TexturedVertex tv2 = new TexturedVertex(v2[0], v2[1], v2[2], 8.0f, 8.0f);
        TexturedVertex tv3 = new TexturedVertex(v3[0], v3[1], v3[2], 8.0f, 0.0f);
        TexturedVertex tv4 = new TexturedVertex(v4[0], v4[1], v4[2], 0.0f, 0.0f);
        TexturedVertex tv5 = new TexturedVertex(v5[0], v5[1], v5[2], 0.0f, 8.0f);
        TexturedVertex tv6 = new TexturedVertex(v6[0], v6[1], v6[2], 8.0f, 8.0f);
        TexturedVertex tv7 = new TexturedVertex(v7[0], v7[1], v7[2], 8.0f, 0.0f);
        if (sides == null) {
            poly[0] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv1, tv2, tv6}, (float)this.textureOffsetX + d + w, (float)this.textureOffsetY + d, (float)this.textureOffsetX + d + w + d, (float)this.textureOffsetY + d + h);
            poly[1] = this.addPolygonReturn(new TexturedVertex[]{tv0, tv4, tv7, tv3}, this.textureOffsetX + 0, (float)this.textureOffsetY + d, (float)this.textureOffsetX + d, (float)this.textureOffsetY + d + h);
            poly[2] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv4, tv0, tv1}, (float)this.textureOffsetX + d, this.textureOffsetY + 0, (float)this.textureOffsetX + d + w, (float)this.textureOffsetY + d);
            poly[3] = this.addPolygonReturn(new TexturedVertex[]{tv2, tv3, tv7, tv6}, (float)this.textureOffsetX + d + w, this.textureOffsetY + 0, (float)this.textureOffsetX + d + w + w, (float)this.textureOffsetY + d);
            poly[4] = this.addPolygonReturn(new TexturedVertex[]{tv1, tv0, tv3, tv2}, (float)this.textureOffsetX + d, (float)this.textureOffsetY + d, (float)this.textureOffsetX + d + w, (float)this.textureOffsetY + d + h);
            poly[5] = this.addPolygonReturn(new TexturedVertex[]{tv4, tv5, tv6, tv7}, (float)this.textureOffsetX + d + w + d, (float)this.textureOffsetY + d, (float)this.textureOffsetX + d + w + d + w, (float)this.textureOffsetY + d + h);
        } else {
            float x3;
            float yp = sides[2] && sides[3] ? 0.0f : d;
            float x0 = sides[1] ? 0.0f : d;
            float x1 = sides[2] ? 0.0f : w;
            float x2 = sides[4] ? 0.0f : w;
            float f = x3 = sides[0] ? 0.0f : d;
            if (sides.length > 0 && !sides[0]) {
                poly[0] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv1, tv2, tv6}, (float)this.textureOffsetX + x0 + x2, (float)this.textureOffsetY + yp, (float)this.textureOffsetX + x0 + x2 + d, (float)this.textureOffsetY + yp + h);
            }
            if (sides.length > 1 && !sides[1]) {
                poly[1] = this.addPolygonReturn(new TexturedVertex[]{tv0, tv4, tv7, tv3}, this.textureOffsetX + 0, (float)this.textureOffsetY + yp, (float)this.textureOffsetX + d, (float)this.textureOffsetY + yp + h);
            }
            if (sides.length > 2 && !sides[2]) {
                poly[2] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv4, tv0, tv1}, (float)this.textureOffsetX + x0, this.textureOffsetY + 0, (float)this.textureOffsetX + x0 + w, (float)this.textureOffsetY + d);
            }
            if (sides.length > 3 && !sides[3]) {
                poly[3] = this.addPolygonReturn(new TexturedVertex[]{tv2, tv3, tv7, tv6}, (float)this.textureOffsetX + x0 + x1, this.textureOffsetY + 0, (float)this.textureOffsetX + x0 + x1 + w, (float)this.textureOffsetY + d);
            }
            if (sides.length > 4 && !sides[4]) {
                poly[4] = this.addPolygonReturn(new TexturedVertex[]{tv1, tv0, tv3, tv2}, (float)this.textureOffsetX + x0, (float)this.textureOffsetY + yp, (float)this.textureOffsetX + x0 + w, (float)this.textureOffsetY + yp + h);
            }
            if (sides.length > 5 && !sides[5]) {
                poly[5] = this.addPolygonReturn(new TexturedVertex[]{tv4, tv5, tv6, tv7}, (float)this.textureOffsetX + x0 + x2 + x3, (float)this.textureOffsetY + yp, (float)this.textureOffsetX + x0 + x2 + x3 + w, (float)this.textureOffsetY + yp + h);
            }
        }
        if (this.mirror ^ this.flip) {
            for (int l = 0; l < poly.length; ++l) {
                poly[l].flipFace();
            }
        }
        if (sides != null) {
            int polis = 0;
            int processed = 0;
            for (int i = 0; i < poly.length; ++i) {
                if (poly[i] == null) continue;
                ++polis;
            }
            TexturedPolygon[] polygons = new TexturedPolygon[polis];
            for (int i = 0; i < poly.length; ++i) {
                if (poly[i] == null) continue;
                polygons[processed] = poly[i];
                ++processed;
            }
            poly = polygons;
        }
        return this.copyTo(null, poly);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, int w, int h, int d) {
        return this.addBox(x, y, z, w, h, d, 0.0f);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, int w, int h, int d, float expansion) {
        return this.addBox(x, y, z, w, h, d, expansion, 1.0f);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, float w, float h, float d, float expansion, float scale) {
        return this.addBox(x, y, z, w, h, d, expansion, scale, null);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, float w, float h, float d, float expansion, float scale, boolean[] sides) {
        if (w < 1.0f) {
            w = 0.01f;
            x -= 0.005f;
        }
        if (h < 1.0f) {
            h = 0.01f;
            y -= 0.005f;
        }
        if (d < 1.0f) {
            d = 0.01f;
            z -= 0.005f;
        }
        this.xScale = w * scale;
        this.yScale = h * scale;
        this.zScale = d * scale;
        float x1 = x + this.xScale;
        float y1 = y + this.yScale;
        float z1 = z + this.zScale;
        float expX = expansion + this.xScale - w;
        float expY = expansion + this.yScale - h;
        float expZ = expansion + this.zScale - d;
        x -= expX;
        y -= expY;
        z -= expZ;
        x1 += expansion;
        y1 += expansion;
        z1 += expansion;
        if (this.mirror) {
            float xTemp = x1;
            x1 = x;
            x = xTemp;
        }
        float[] v = new float[]{x, y, z};
        float[] v1 = new float[]{x1, y, z};
        float[] v2 = new float[]{x1, y1, z};
        float[] v3 = new float[]{x, y1, z};
        float[] v4 = new float[]{x, y, z1};
        float[] v5 = new float[]{x1, y, z1};
        float[] v6 = new float[]{x1, y1, z1};
        float[] v7 = new float[]{x, y1, z1};
        return this.addRectShape(v, v1, v2, v3, v4, v5, v6, v7, w, h, d, sides);
    }

    public void addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        int m;
        float f4 = x + (float)w;
        float f5 = y + (float)h;
        float f6 = z + (float)d;
        x -= scale;
        y -= scale;
        z -= scale;
        f4 += scale;
        f5 += scale;
        f6 += scale;
        int n = m = this.mirror ? -1 : 1;
        if (this.mirror) {
            float f7 = f4;
            f4 = x;
            x = f7;
        }
        float[] v = new float[]{x, y, z};
        float[] v1 = new float[]{f4, y, z};
        float[] v2 = new float[]{f4, f5, z};
        float[] v3 = new float[]{x, f5, z};
        float[] v4 = new float[]{x, y, f6};
        float[] v5 = new float[]{f4, y, f6};
        float[] v6 = new float[]{f4, f5, f6};
        float[] v7 = new float[]{x, f5, f6};
        switch (dir) {
            case 3: {
                v[1] = v[1] - bottomScale;
                v[2] = v[2] - bottomScale;
                v3[1] = v3[1] + bottomScale;
                v3[2] = v3[2] - bottomScale;
                v4[1] = v4[1] - bottomScale;
                v4[2] = v4[2] + bottomScale;
                v7[1] = v7[1] + bottomScale;
                v7[2] = v7[2] + bottomScale;
                break;
            }
            case 2: {
                v1[1] = v1[1] - bottomScale;
                v1[2] = v1[2] - bottomScale;
                v2[1] = v2[1] + bottomScale;
                v2[2] = v2[2] - bottomScale;
                v5[1] = v5[1] - bottomScale;
                v5[2] = v5[2] + bottomScale;
                v6[1] = v6[1] + bottomScale;
                v6[2] = v6[2] + bottomScale;
                break;
            }
            case 0: {
                v[0] = v[0] - (float)m * bottomScale;
                v[1] = v[1] - bottomScale;
                v1[0] = v1[0] + (float)m * bottomScale;
                v1[1] = v1[1] - bottomScale;
                v2[0] = v2[0] + (float)m * bottomScale;
                v2[1] = v2[1] + bottomScale;
                v3[0] = v3[0] - (float)m * bottomScale;
                v3[1] = v3[1] + bottomScale;
                break;
            }
            case 1: {
                v4[0] = v4[0] - (float)m * bottomScale;
                v4[1] = v4[1] - bottomScale;
                v5[0] = v5[0] + (float)m * bottomScale;
                v5[1] = v5[1] - bottomScale;
                v6[0] = v6[0] + (float)m * bottomScale;
                v6[1] = v6[1] + bottomScale;
                v7[0] = v7[0] - (float)m * bottomScale;
                v7[1] = v7[1] + bottomScale;
                break;
            }
            case 4: {
                v[0] = v[0] - (float)m * bottomScale;
                v[2] = v[2] - bottomScale;
                v1[0] = v1[0] + (float)m * bottomScale;
                v1[2] = v1[2] - bottomScale;
                v4[0] = v4[0] - (float)m * bottomScale;
                v4[2] = v4[2] + bottomScale;
                v5[0] = v5[0] + (float)m * bottomScale;
                v5[2] = v5[2] + bottomScale;
                break;
            }
            case 5: {
                v2[0] = v2[0] + (float)m * bottomScale;
                v2[2] = v2[2] - bottomScale;
                v3[0] = v3[0] - (float)m * bottomScale;
                v3[2] = v3[2] - bottomScale;
                v6[0] = v6[0] + (float)m * bottomScale;
                v6[2] = v6[2] + bottomScale;
                v7[0] = v7[0] - (float)m * bottomScale;
                v7[2] = v7[2] + bottomScale;
            }
        }
        this.addRectShape(v, v1, v2, v3, v4, v5, v6, v7, w, h, d);
    }

    public void addFlexTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bScale1, float bScale2, float bScale3, float bScale4, float fScale1, float fScale2, int dir) {
        int m;
        float f4 = x + (float)w;
        float f5 = y + (float)h;
        float f6 = z + (float)d;
        x -= scale;
        y -= scale;
        z -= scale;
        f4 += scale;
        f5 += scale;
        f6 += scale;
        int n = m = this.mirror ? -1 : 1;
        if (this.mirror) {
            float f7 = f4;
            f4 = x;
            x = f7;
        }
        float[] v = new float[]{x, y, z};
        float[] v1 = new float[]{f4, y, z};
        float[] v2 = new float[]{f4, f5, z};
        float[] v3 = new float[]{x, f5, z};
        float[] v4 = new float[]{x, y, f6};
        float[] v5 = new float[]{f4, y, f6};
        float[] v6 = new float[]{f4, f5, f6};
        float[] v7 = new float[]{x, f5, f6};
        switch (dir) {
            case 3: {
                v[2] = v[2] - fScale1;
                v1[2] = v1[2] - fScale1;
                v4[2] = v4[2] + fScale2;
                v5[2] = v5[2] + fScale2;
                v[1] = v[1] - bScale1;
                v[2] = v[2] - bScale3;
                v3[1] = v3[1] + bScale2;
                v3[2] = v3[2] - bScale3;
                v4[1] = v4[1] - bScale1;
                v4[2] = v4[2] + bScale4;
                v7[1] = v7[1] + bScale2;
                v7[2] = v7[2] + bScale4;
                break;
            }
            case 2: {
                v[2] = v[2] - fScale1;
                v1[2] = v1[2] - fScale1;
                v4[2] = v4[2] + fScale2;
                v5[2] = v5[2] + fScale2;
                v1[1] = v1[1] - bScale1;
                v1[2] = v1[2] - bScale3;
                v2[1] = v2[1] + bScale2;
                v2[2] = v2[2] - bScale3;
                v5[1] = v5[1] - bScale1;
                v5[2] = v5[2] + bScale4;
                v6[1] = v6[1] + bScale2;
                v6[2] = v6[2] + bScale4;
                break;
            }
            case 0: {
                v1[1] = v1[1] - fScale1;
                v5[1] = v5[1] - fScale1;
                v2[1] = v2[1] + fScale2;
                v6[1] = v6[1] + fScale2;
                v[0] = v[0] - (float)m * bScale4;
                v[1] = v[1] - bScale1;
                v1[0] = v1[0] + (float)m * bScale3;
                v1[1] = v1[1] - bScale1;
                v2[0] = v2[0] + (float)m * bScale3;
                v2[1] = v2[1] + bScale2;
                v3[0] = v3[0] - (float)m * bScale4;
                v3[1] = v3[1] + bScale2;
                break;
            }
            case 1: {
                v1[1] = v1[1] - fScale1;
                v5[1] = v5[1] - fScale1;
                v2[1] = v2[1] + fScale2;
                v6[1] = v6[1] + fScale2;
                v4[0] = v4[0] - (float)m * bScale4;
                v4[1] = v4[1] - bScale1;
                v5[0] = v5[0] + (float)m * bScale3;
                v5[1] = v5[1] - bScale1;
                v6[0] = v6[0] + (float)m * bScale3;
                v6[1] = v6[1] + bScale2;
                v7[0] = v7[0] - (float)m * bScale4;
                v7[1] = v7[1] + bScale2;
                break;
            }
            case 4: {
                v1[2] = v1[2] - fScale1;
                v2[2] = v2[2] - fScale1;
                v5[2] = v5[2] + fScale2;
                v6[2] = v6[2] + fScale2;
                v[0] = v[0] - (float)m * bScale1;
                v[2] = v[2] - bScale3;
                v1[0] = v1[0] + (float)m * bScale2;
                v1[2] = v1[2] - bScale3;
                v4[0] = v4[0] - (float)m * bScale1;
                v4[2] = v4[2] + bScale4;
                v5[0] = v5[0] + (float)m * bScale2;
                v5[2] = v5[2] + bScale4;
                break;
            }
            case 5: {
                v1[2] = v1[2] - fScale1;
                v2[2] = v2[2] - fScale1;
                v5[2] = v5[2] + fScale2;
                v6[2] = v6[2] + fScale2;
                v2[0] = v2[0] + (float)m * bScale2;
                v2[2] = v2[2] - bScale3;
                v3[0] = v3[0] - (float)m * bScale1;
                v3[2] = v3[2] - bScale3;
                v6[0] = v6[0] + (float)m * bScale2;
                v6[2] = v6[2] + bScale4;
                v7[0] = v7[0] - (float)m * bScale1;
                v7[2] = v7[2] + bScale4;
            }
        }
        this.addRectShape(v, v1, v2, v3, v4, v5, v6, v7, w, h, d);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Coord2D[] coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        return this.addShape3D(x, y, z, coordinates, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Coord2D[] coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        return this.addShape3D(x, y, z, new Shape2D(coordinates), depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, faceLengths);
    }

    public void addShape3D(float x, float y, float z, ArrayList<Coord2D> coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        this.addShape3D(x, y, z, coordinates, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public void addShape3D(float x, float y, float z, ArrayList<Coord2D> coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        this.addShape3D(x, y, z, new Shape2D(coordinates), depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, faceLengths);
    }

    public void addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        switch (direction) {
            case 2: {
                rotY = 1.5707964f;
                break;
            }
            case 3: {
                rotY = -1.5707964f;
                break;
            }
            case 4: {
                rotX = 1.5707964f;
                break;
            }
            case 5: {
                rotX = -1.5707964f;
                break;
            }
            case 0: {
                rotY = (float)Math.PI;
                break;
            }
        }
        return this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, rotX, rotY, rotZ, faceLengths);
    }

    public void addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float rotX, float rotY, float rotZ) {
        this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, rotX, rotY, rotZ, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float rotX, float rotY, float rotZ, float[] faceLengths) {
        Shape3D shape3D = shape.extrude(-x, y, -z, rotX, rotY, rotZ, depth, this.textureOffsetX, this.textureOffsetY, this.textureWidth, this.textureHeight, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, faceLengths);
        for (int idx = 0; idx < shape3D.faces.length; ++idx) {
            shape3D.faces[idx].flipFace();
        }
        this.isShape = true;
        return this.copyTo(shape3D.vertices, shape3D.faces);
    }

    public void addPixel(float x, float y, float z, float width, float height, float length) {
        this.addPixel(x, y, z, new float[]{width, height, length}, this.textureOffsetX, this.textureOffsetY);
    }

    public void addPixel(float x, float y, float z, float[] scale, int w, int h) {
        TexturedVertex[] verts = new TexturedVertex[8];
        TexturedPolygon[] poly = new TexturedPolygon[6];
        float x1 = x + scale[0];
        float y1 = y + scale[1];
        float z1 = z + scale[2];
        float[] f = new float[]{x, y, z};
        float[] f1 = new float[]{x1, y, z};
        float[] f2 = new float[]{x1, y1, z};
        float[] f3 = new float[]{x, y1, z};
        float[] f4 = new float[]{x, y, z1};
        float[] f5 = new float[]{x1, y, z1};
        float[] f6 = new float[]{x1, y1, z1};
        float[] f7 = new float[]{x, y1, z1};
        TexturedVertex positionTexturevertex = new TexturedVertex(f[0], f[1], f[2], 0.0f, 0.0f);
        TexturedVertex positionTexturevertex1 = new TexturedVertex(f1[0], f1[1], f1[2], 0.0f, 8.0f);
        TexturedVertex positionTexturevertex2 = new TexturedVertex(f2[0], f2[1], f2[2], 8.0f, 8.0f);
        TexturedVertex positionTexturevertex3 = new TexturedVertex(f3[0], f3[1], f3[2], 8.0f, 0.0f);
        TexturedVertex positionTexturevertex4 = new TexturedVertex(f4[0], f4[1], f4[2], 0.0f, 0.0f);
        TexturedVertex positionTexturevertex5 = new TexturedVertex(f5[0], f5[1], f5[2], 0.0f, 8.0f);
        TexturedVertex positionTexturevertex6 = new TexturedVertex(f6[0], f6[1], f6[2], 8.0f, 8.0f);
        TexturedVertex positionTexturevertex7 = new TexturedVertex(f7[0], f7[1], f7[2], 8.0f, 0.0f);
        verts[0] = positionTexturevertex;
        verts[1] = positionTexturevertex1;
        verts[2] = positionTexturevertex2;
        verts[3] = positionTexturevertex3;
        verts[4] = positionTexturevertex4;
        verts[5] = positionTexturevertex5;
        verts[6] = positionTexturevertex6;
        verts[7] = positionTexturevertex7;
        poly[0] = this.addPolygonReturn(new TexturedVertex[]{positionTexturevertex5, positionTexturevertex1, positionTexturevertex2, positionTexturevertex6}, w, h, w + 1, h + 1);
        poly[1] = this.addPolygonReturn(new TexturedVertex[]{positionTexturevertex, positionTexturevertex4, positionTexturevertex7, positionTexturevertex3}, w, h, w + 1, h + 1);
        poly[2] = this.addPolygonReturn(new TexturedVertex[]{positionTexturevertex5, positionTexturevertex4, positionTexturevertex, positionTexturevertex1}, w, h, w + 1, h + 1);
        poly[3] = this.addPolygonReturn(new TexturedVertex[]{positionTexturevertex2, positionTexturevertex3, positionTexturevertex7, positionTexturevertex6}, w, h, w + 1, h + 1);
        poly[4] = this.addPolygonReturn(new TexturedVertex[]{positionTexturevertex1, positionTexturevertex, positionTexturevertex3, positionTexturevertex2}, w, h, w + 1, h + 1);
        poly[5] = this.addPolygonReturn(new TexturedVertex[]{positionTexturevertex4, positionTexturevertex5, positionTexturevertex6, positionTexturevertex7}, w, h, w + 1, h + 1);
        this.copyTo(verts, poly);
    }

    public void addSprite(float x, float y, float z, int w, int h, float expansion) {
        this.addSprite(x, y, z, w, h, 1, false, false, false, false, false, expansion);
    }

    public void addSprite(float x, float y, float z, int w, int h, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        this.addSprite(x, y, z, w, h, 1, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public void addSprite(float x, float y, float z, int w, int h, int d, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        this.addSprite(x, y, z, w, h, d, 1.0f, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public void addSprite(float x, float y, float z, int w, int h, int d, float pixelScale, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        Object[] mask = new String[h];
        char[] str = new char[w];
        Arrays.fill(str, '1');
        Arrays.fill(mask, new String(str));
        this.addSprite(x, y, z, (String[])mask, d, pixelScale, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public void addSprite(float x, float y, float z, String[] mask, int d, float pixelScale, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        int w = mask[0].length();
        int h = mask.length;
        float x1 = x - expansion;
        float y1 = y - expansion;
        float z1 = z - expansion;
        int wDir = 0;
        int hDir = 0;
        int dDir = 0;
        float wScale = 1.0f + expansion / ((float)w * pixelScale);
        float hScale = 1.0f + expansion / ((float)h * pixelScale);
        if (!rotX) {
            if (!rotY) {
                if (!rotZ) {
                    wDir = 0;
                    hDir = 1;
                    dDir = 2;
                } else {
                    wDir = 1;
                    hDir = 0;
                    dDir = 2;
                }
            } else if (!rotZ) {
                wDir = 2;
                hDir = 1;
                dDir = 0;
            } else {
                wDir = 2;
                hDir = 0;
                dDir = 1;
            }
        } else if (!rotY) {
            if (!rotZ) {
                wDir = 0;
                hDir = 2;
                dDir = 1;
            } else {
                wDir = 1;
                hDir = 2;
                dDir = 0;
            }
        } else if (!rotZ) {
            wDir = 2;
            hDir = 0;
            dDir = 1;
        } else {
            wDir = 2;
            hDir = 1;
            dDir = 0;
        }
        int texStartX = this.textureOffsetX + (mirrorX ? w * 1 - 1 : 0);
        int texStartY = this.textureOffsetY + (mirrorY ? h * 1 - 1 : 0);
        int texDirX = mirrorX ? -1 : 1;
        int texDirY = mirrorY ? -1 : 1;
        float wVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, wDir, 1, 1);
        float hVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, hDir, 1, 1);
        float dVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, dDir, 1, 1);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                if (mask[j].charAt(i) != '1') continue;
                this.addPixel(x1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 0, i, j), y1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 1, i, j), z1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 2, i, j), new float[]{wVoxSize, hVoxSize, dVoxSize}, texStartX + texDirX * i, texStartY + texDirY * j);
            }
        }
    }

    private float getPixelSize(float wScale, float hScale, float dScale, int wDir, int hDir, int checkDir, int texPosX, int texPosY) {
        return wDir == checkDir ? wScale * (float)texPosX : (hDir == checkDir ? hScale * (float)texPosY : dScale);
    }

    public ModelRendererTurbo addSphere(float x, float y, float z, float r, int segs, int rings, int textureW, int textureH) {
        TexturedVertex[] verts;
        if (segs < 3) {
            segs = 3;
        }
        TexturedVertex[] tempVerts = new TexturedVertex[segs * (++rings - 1) + 2];
        TexturedPolygon[] poly = new TexturedPolygon[segs * rings];
        tempVerts[0] = new TexturedVertex(x, y - r, z, 0.0f, 0.0f);
        tempVerts[tempVerts.length - 1] = new TexturedVertex(x, y + r, z, 0.0f, 0.0f);
        float uOffs = 1.0f / ((float)this.textureWidth * 10.0f);
        float vOffs = 1.0f / ((float)this.textureHeight * 10.0f);
        float texW = (float)(textureW / this.textureWidth) - 2.0f * uOffs;
        float texH = (float)(textureH / this.textureHeight) - 2.0f * vOffs;
        float segW = texW / (float)segs;
        float segH = texH / (float)rings;
        float startU = this.textureOffsetX / this.textureWidth;
        float startV = this.textureOffsetY / this.textureHeight;
        int currentFace = 0;
        for (int j = 1; j < rings; ++j) {
            for (int i = 0; i < segs; ++i) {
                float yWidth = MathHelper.func_76134_b((float)(-1.5707964f + (float)Math.PI / (float)rings * (float)j));
                float yHeight = MathHelper.func_76126_a((float)(-1.5707964f + (float)Math.PI / (float)rings * (float)j));
                float xSize = MathHelper.func_76126_a((float)((float)Math.PI / (float)segs * (float)i * 2.0f + (float)Math.PI)) * yWidth;
                float zSize = -MathHelper.func_76134_b((float)((float)Math.PI / (float)segs * (float)i * 2.0f + (float)Math.PI)) * yWidth;
                int curVert = 1 + i + segs * (j - 1);
                tempVerts[curVert] = new TexturedVertex(x + xSize * r, y + yHeight * r, z + zSize * r, 0.0f, 0.0f);
                if (i <= 0) continue;
                TexturedVertex[] verts2 = j == 1 ? new TexturedVertex[]{tempVerts[curVert].setTexturePosition(startU + segW * (float)i, startV + segH * (float)j), tempVerts[curVert - 1].setTexturePosition(startU + segW * (float)(i - 1), startV + segH * (float)j), tempVerts[0].setTexturePosition(startU + segW * (float)(i - 1), startV), tempVerts[0].setTexturePosition(startU + segW + segW * (float)i, startV)} : new TexturedVertex[]{tempVerts[curVert].setTexturePosition(startU + segW * (float)i, startV + segH * (float)j), tempVerts[curVert - 1].setTexturePosition(startU + segW * (float)(i - 1), startV + segH * (float)j), tempVerts[curVert - 1 - segs].setTexturePosition(startU + segW * (float)(i - 1), startV + segH * (float)(j - 1)), tempVerts[curVert - segs].setTexturePosition(startU + segW * (float)i, startV + segH * (float)(j - 1))};
                poly[currentFace] = new TexturedPolygon(verts2);
                ++currentFace;
            }
            verts = j == 1 ? new TexturedVertex[]{tempVerts[1].setTexturePosition(startU + segW * (float)segs, startV + segH * (float)j), tempVerts[segs].setTexturePosition(startU + segW * (float)(segs - 1), startV + segH * (float)j), tempVerts[0].setTexturePosition(startU + segW * (float)(segs - 1), startV), tempVerts[0].setTexturePosition(startU + segW * (float)segs, startV)} : new TexturedVertex[]{tempVerts[1 + segs * (j - 1)].setTexturePosition(startU + texW, startV + segH * (float)j), tempVerts[segs * (j - 1) + segs].setTexturePosition(startU + texW - segW, startV + segH * (float)j), tempVerts[segs * (j - 1)].setTexturePosition(startU + texW - segW, startV + segH * (float)(j - 1)), tempVerts[1 + segs * (j - 1) - segs].setTexturePosition(startU + texW, startV + segH * (float)(j - 1))};
            poly[currentFace] = new TexturedPolygon(verts);
            ++currentFace;
        }
        for (int i = 0; i < segs; ++i) {
            verts = new TexturedVertex[3];
            int curVert = tempVerts.length - (segs + 1);
            verts[0] = tempVerts[tempVerts.length - 1].setTexturePosition(startU + segW * ((float)i + 0.5f), startV + texH);
            verts[1] = tempVerts[curVert + i].setTexturePosition(startU + segW * (float)i, startV + texH - segH);
            verts[2] = tempVerts[curVert + (i + 1) % segs].setTexturePosition(startU + segW * (float)(i + 1), startV + texH - segH);
            poly[currentFace] = new TexturedPolygon(verts);
            ++currentFace;
        }
        return this.copyTo(tempVerts, poly);
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments) {
        return this.addCone(x, y, z, radius, length, segments, 1.0f);
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments, float baseScale) {
        return this.addCone(x, y, z, radius, length, segments, baseScale, 4);
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments, float baseScale, int baseDirection) {
        return this.addCone(x, y, z, radius, length, segments, baseScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f));
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments, float baseScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, 0.0f, baseDirection, textureCircleDiameterW, textureCircleDiameterH, 1);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments) {
        return this.addCylinder(x, y, z, radius, length, segments, 1.0f, 1.0f);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, 4);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length), null);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection, Vec3f topoff) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length), topoff);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH, int textureH) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, baseDirection, textureCircleDiameterW, textureCircleDiameterH, textureH, null);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH, int textureH, Vec3f topoff) {
        boolean coneTop;
        if (radius < 1.0f) {
            int rad;
            int n = rad = (double)radius < 0.5 ? 1 : 2;
            if (textureCircleDiameterW < rad) {
                textureCircleDiameterW = rad;
            }
            if (textureCircleDiameterH < rad) {
                textureCircleDiameterH = rad;
            }
        }
        if (length < 1.0f) {
            textureH = 1;
        } else if (length % 1.0f != 0.0f) {
            textureH = (int)length + (length % 1.0f > 0.5f ? 1 : 0);
        }
        boolean dirTop = baseDirection == 4 || baseDirection == 5;
        boolean dirSide = baseDirection == 3 || baseDirection == 2;
        boolean dirFront = baseDirection == 0 || baseDirection == 1;
        boolean dirMirror = baseDirection == 2 || baseDirection == 5 || baseDirection == 1;
        boolean coneBase = baseScale == 0.0f;
        boolean bl = coneTop = topScale == 0.0f;
        if (coneBase && coneTop) {
            baseScale = 1.0f;
            coneBase = false;
        }
        TexturedVertex[] tempVerts = new TexturedVertex[segments * (coneBase || coneTop ? 1 : 2) + 2];
        TexturedPolygon[] poly = new TexturedPolygon[segments * (coneBase || coneTop ? 2 : 3)];
        float xLength = dirSide ? length : 0.0f;
        float yLength = dirTop ? length : 0.0f;
        float zLength = dirFront ? length : 0.0f;
        float xStart = dirMirror ? x + xLength : x;
        float yStart = dirMirror ? y + yLength : y;
        float zStart = dirMirror ? z + zLength : z;
        float xEnd = (!dirMirror ? x + xLength : x) + (topoff == null ? 0.0f : topoff.xCoord);
        float yEnd = (!dirMirror ? y + yLength : y) + (topoff == null ? 0.0f : topoff.yCoord);
        float zEnd = (!dirMirror ? z + zLength : z) + (topoff == null ? 0.0f : topoff.zCoord);
        tempVerts[0] = new TexturedVertex(xStart, yStart, zStart, 0.0f, 0.0f);
        tempVerts[tempVerts.length - 1] = new TexturedVertex(xEnd, yEnd, zEnd, 0.0f, 0.0f);
        float xCur = xStart;
        float yCur = yStart;
        float zCur = zStart;
        float sCur = coneBase ? topScale : baseScale;
        for (int repeat = 0; repeat < (coneBase || coneTop ? 1 : 2); ++repeat) {
            for (int index = 0; index < segments; ++index) {
                float xSize = (float)((double)(this.mirror ^ dirMirror ? -1 : 1) * Math.sin((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius * (double)sCur);
                float zSize = (float)(-Math.cos((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius * (double)sCur);
                float xPlace = xCur + (!dirSide ? xSize : 0.0f);
                float yPlace = yCur + (!dirTop ? zSize : 0.0f);
                float zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                tempVerts[1 + index + repeat * segments] = new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f);
            }
            xCur = xEnd;
            yCur = yEnd;
            zCur = zEnd;
            sCur = topScale;
        }
        float uScale = 1.0f / (float)this.textureWidth;
        float vScale = 1.0f / (float)this.textureHeight;
        float uOffset = 0.0f;
        float vOffset = 0.0f;
        float uCircle = (float)textureCircleDiameterW * uScale;
        float vCircle = (float)textureCircleDiameterH * vScale;
        float uWidth = (uCircle * 2.0f - uOffset * 2.0f) / (float)segments;
        float vHeight = (float)textureH * vScale - uOffset * 2.0f;
        float uStart = (float)this.textureOffsetX * uScale;
        float vStart = (float)this.textureOffsetY * vScale;
        for (int index = 0; index < segments; ++index) {
            int index2 = (index + 1) % segments;
            float uSize = (float)(Math.sin((float)Math.PI / (float)segments * (float)index * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
            float vSize = (float)(Math.cos((float)Math.PI / (float)segments * (float)index * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
            float uSize1 = (float)(Math.sin((float)Math.PI / (float)segments * (float)index2 * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
            float vSize1 = (float)(Math.cos((float)Math.PI / (float)segments * (float)index2 * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
            TexturedVertex[] vert = new TexturedVertex[]{tempVerts[0].setTexturePosition(uStart + 0.5f * uCircle, vStart + 0.5f * vCircle), tempVerts[1 + index2].setTexturePosition(uStart + 0.5f * uCircle + uSize1, vStart + 0.5f * vCircle + vSize1), tempVerts[1 + index].setTexturePosition(uStart + 0.5f * uCircle + uSize, vStart + 0.5f * vCircle + vSize)};
            poly[index] = new TexturedPolygon(vert);
            if (!dirFront || this.mirror) {
                poly[index].flipFace();
            }
            if (!coneBase && !coneTop) {
                vert = new TexturedVertex[]{tempVerts[1 + index].setTexturePosition(uStart + uOffset + uWidth * (float)index, vStart + vOffset + vCircle), tempVerts[1 + index2].setTexturePosition(uStart + uOffset + uWidth * (float)(index + 1), vStart + vOffset + vCircle), tempVerts[1 + segments + index2].setTexturePosition(uStart + uOffset + uWidth * (float)(index + 1), vStart + vOffset + vCircle + vHeight), tempVerts[1 + segments + index].setTexturePosition(uStart + uOffset + uWidth * (float)index, vStart + vOffset + vCircle + vHeight)};
                poly[index + segments] = new TexturedPolygon(vert);
                if (!dirFront || this.mirror) {
                    poly[index + segments].flipFace();
                }
            }
            vert = new TexturedVertex[]{tempVerts[tempVerts.length - 1].setTexturePosition(uStart + 1.5f * uCircle, vStart + 0.5f * vCircle), tempVerts[tempVerts.length - 2 - index].setTexturePosition(uStart + 1.5f * uCircle + uSize1, vStart + 0.5f * vCircle + vSize1), tempVerts[tempVerts.length - (1 + segments) + (segments - index) % segments].setTexturePosition(uStart + 1.5f * uCircle + uSize, vStart + 0.5f * vCircle + vSize)};
            poly[poly.length - segments + index] = new TexturedPolygon(vert);
            if (dirFront && !this.mirror) continue;
            poly[poly.length - segments + index].flipFace();
        }
        return this.copyTo(null, poly);
    }

    public ModelRendererTurbo addObj(String file) {
        this.useLegacyCompiler = false;
        this.addModel(file, ModelPool.OBJ);
        return this;
    }

    public void addObjF(String file) {
        try {
            this.useLegacyCompiler = false;
            this.addModelF(file, ModelPool.OBJ);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addModel(String file, Class<?> modelFormat) {
        ModelPoolEntry entry = ModelPool.addFile(file, modelFormat, this.textureGroup);
        if (entry == null) {
            return;
        }
        TexturedVertex[] verts = Arrays.copyOf(entry.vertices, entry.vertices.length);
        TexturedPolygon[] poly = Arrays.copyOf(entry.faces, entry.faces.length);
        if (this.flip) {
            for (TexturedPolygon face : this.faces) {
                face.flipFace();
            }
        }
        this.copyTo(verts, poly, false);
    }

    public void addModelF(String file, Class<?> modelFormat) throws IOException {
        ModelPoolEntry entry = ModelPool.addFileF(file, modelFormat, this.textureGroup);
        if (entry == null) {
            return;
        }
        TexturedVertex[] verts = Arrays.copyOf(entry.vertices, entry.vertices.length);
        TexturedPolygon[] poly = Arrays.copyOf(entry.faces, entry.faces.length);
        if (this.flip) {
            for (TexturedPolygon face : this.faces) {
                face.flipFace();
            }
        }
        this.copyTo(verts, poly, false);
    }

    public ModelRendererTurbo setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public ModelRendererTurbo setPosition(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
        return this;
    }

    public void doMirror(boolean x, boolean y, boolean z) {
        for (TexturedPolygon face : this.faces) {
            TexturedVertex[] verts;
            for (TexturedVertex vert : verts = face.vertices) {
                vert.vector3F.addVector(vert.vector3F.xCoord * (float)(x ? -1 : 1), vert.vector3F.xCoord * (float)(y ? -1 : 1), vert.vector3F.xCoord * (float)(z ? -1 : 1));
            }
            if (!(x ^ y ^ z)) continue;
            face.flipFace();
        }
    }

    public void setMirrored(boolean isMirrored) {
        this.mirror = isMirrored;
    }

    public void setFlipped(boolean isFlipped) {
        this.flip = isFlipped;
    }

    public void clear() {
        this.faces = new ArrayList<TexturedPolygon>();
    }

    public ModelRendererTurbo copyTo(TexturedVertex[] verts, TexturedPolygon[] poly) {
        return this.copyTo(verts, poly, true);
    }

    public ModelRendererTurbo copyTo(TexturedVertex[] verts, TexturedPolygon[] poly, boolean copyGroup) {
        this.faces = new ArrayList<TexturedPolygon>();
        this.faces.addAll(Arrays.asList(poly));
        return this;
    }

    public void setTextureGroup(String groupName) {
        if (!this.textureGroup.containsKey(groupName)) {
            this.textureGroup.put(groupName, new TextureGroup());
        }
        this.currentTextureGroup = this.textureGroup.get(groupName);
    }

    public TextureGroup getTextureGroup() {
        return this.currentTextureGroup;
    }

    public TextureGroup getTextureGroup(String groupName) {
        if (!this.textureGroup.containsKey(groupName)) {
            return null;
        }
        return this.textureGroup.get(groupName);
    }

    public void setGroupTexture(String s) {
        this.currentTextureGroup.texture = s;
    }

    public void setDefaultTexture(String s) {
        this.defaultTexture = s;
    }

    public CylinderBuilder newCylinderBuilder() {
        return new CylinderBuilder(this);
    }

    public void render() {
        this.render(0.0625f, this.rotorder);
    }

    public void render(float scale) {
        this.render(scale, this.rotorder);
    }

    public void render(float scale, boolean bool) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled || this.forcedRecompile) {
            this.compileDisplayList(scale);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            if (bool) {
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            } else {
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            this.callDisplayList();
            if (this.childModels != null) {
                for (Object child : this.childModels) {
                    ((ModelRenderer)child).func_78785_a(scale);
                }
            }
            GL11.glPopMatrix();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            this.callDisplayList();
            if (this.childModels != null) {
                for (Object child : this.childModels) {
                    ((ModelRenderer)child).func_78785_a(scale);
                }
            }
            GL11.glTranslatef((float)(-this.rotationPointX * scale), (float)(-this.rotationPointY * scale), (float)(-this.rotationPointZ * scale));
        } else {
            this.callDisplayList();
            if (this.childModels != null) {
                for (Object child : this.childModels) {
                    ((ModelRenderer)child).func_78785_a(scale);
                }
            }
        }
    }

    public void callDisplayList() {
        if (this.useLegacyCompiler) {
            if (GL11.glIsList((int)this.displayList)) {
                GL11.glCallList((int)this.displayList);
            } else {
                this.compiled = false;
            }
        } else {
            Iterator<TextureGroup> itr = this.textureGroup.values().iterator();
            int i = 0;
            while (itr.hasNext()) {
                if (GL11.glIsList((int)this.displayListArray[i])) {
                    TextureGroup curTexGroup = itr.next();
                    curTexGroup.loadTexture();
                    GL11.glCallList((int)this.displayListArray[i]);
                    if (!this.defaultTexture.equals("")) {
                        Tessellator.bindTexture(new ResourceLocation("", this.defaultTexture));
                    }
                } else {
                    this.compiled = false;
                }
                ++i;
            }
        }
    }

    public void compileDisplayList(float scale) {
        if (this.useLegacyCompiler) {
            this.compileLegacyDisplayList(scale);
        } else {
            Iterator<TextureGroup> itr = this.textureGroup.values().iterator();
            this.displayListArray = new int[this.textureGroup.size()];
            int i = 0;
            while (itr.hasNext()) {
                this.displayListArray[i] = GLAllocation.func_74526_a((int)1);
                GL11.glNewList((int)this.displayListArray[i], (int)4864);
                Tessellator tessellator = Tessellator.getInstance();
                TextureGroup usedGroup = itr.next();
                for (int j = 0; j < usedGroup.poly.size(); ++j) {
                    usedGroup.poly.get(j).draw(tessellator, scale);
                }
                GL11.glEndList();
                ++i;
            }
        }
        this.compiled = true;
    }

    private void compileLegacyDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.getInstance();
        for (TexturedPolygon poly : this.faces) {
            poly.draw(tessellator, scale);
        }
        GL11.glEndList();
    }

    public ModelRendererTurbo addShapeBox(float x, float y, float z, float w, float h, float d, float scale, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float x5, float y5, float z5, float x6, float y6, float z6, float x7, float y7, float z7) {
        float f = (w += w < 1.0f ? 0.0015f : 0.001f) < 1.0f ? 0.001f : 5.0E-4f;
        float f2 = (h += h < 1.0f ? 0.0015f : 0.001f) < 1.0f ? 0.001f : 5.0E-4f;
        float f3 = (d += d < 1.0f ? 0.0015f : 0.001f) < 1.0f ? 0.001f : 5.0E-4f;
        float f4 = (x -= f) + w;
        float f5 = (y -= f2) + h;
        float f6 = (z -= f3) + d;
        x -= scale;
        y -= scale;
        z -= scale;
        f4 += scale;
        f5 += scale;
        f6 += scale;
        if (this.mirror) {
            float f7 = f4;
            f4 = x;
            x = f7;
        }
        float[][] v = new float[][]{{x - x0, y - y0, z - z0}, {f4 + x1, y - y1, z - z1}, {f4 + x5, f5 + y5, z - z5}, {x - x4, f5 + y4, z - z4}, {x - x3, y - y3, f6 + z3}, {f4 + x2, y - y2, f6 + z2}, {f4 + x6, f5 + y6, f6 + z6}, {x - x7, f5 + y7, f6 + z7}};
        return this.addRectShape(v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], w, h, d);
    }

    public final ModelRendererTurbo setOldRotationOrder(boolean bool) {
        this.rotorder = bool;
        return this;
    }

    public String toString(String alt) {
        String str = this.toString();
        return str == null || str.equals("") ? alt : str;
    }

    public static void filterGeometry(float size, float ... params) {
        int param = 0;
        boolean wasChanged = false;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == -size) {
                System.out.println(params[i]);
                int n = i;
                params[n] = params[n] + 0.001f;
                System.out.println("resized");
                wasChanged = true;
                break;
            }
            ++param;
        }
        if (wasChanged) {
            System.out.println(params[param]);
        }
    }

    public String toString() {
        return this.boxName;
    }

    public ModelRendererTurbo setRotationPoint(float x, float y, float z) {
        return this.setPosition(x, y, z);
    }

    public ModelRendererTurbo setRotationAngle(float x, float y, float z) {
        this.rotateAngleX = x / 180.0f * (float)Math.PI;
        this.rotateAngleY = -y / 180.0f * (float)Math.PI;
        this.rotateAngleZ = -z / 180.0f * (float)Math.PI;
        return this;
    }

    public ModelRendererTurbo setName(String string) {
        this.boxName = string;
        return this;
    }
}

