/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import train.common.core.handlers.ConfigHandler;

@SideOnly(value=Side.CLIENT)
public class Tessellator {
    private static ByteBuffer bbuf = GLAllocation.func_74524_c((int)0x800000);
    private int rbs = 0;
    private int verts = 0;
    private int rbi = 0;
    private int dm;
    private int n;
    private int vtc;
    private int o;
    private boolean ht = false;
    private boolean in = false;
    private boolean drawing = false;
    public static Tessellator INSTANCE = new Tessellator();
    private static FloatBuffer fbuf = bbuf.asFloatBuffer();
    private static IntBuffer ibuf = bbuf.asIntBuffer();
    private float u;
    private float v;
    private float w;
    private float x;
    private float y;
    private float z;
    private int[] rb;

    public static Tessellator getInstance() {
        return INSTANCE;
    }

    public void startDrawing(int i) {
        if (!this.drawing) {
            this.drawing = true;
            this.dm = i;
            this.ht = false;
            this.in = false;
            this.reset();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public int draw() {
        if (this.drawing) {
            this.drawing = false;
            this.o = 0;
            while (this.o < this.verts) {
                this.vtc = Math.min(this.verts - this.o, 65536);
                ibuf.clear();
                ibuf.put(this.rb, this.o * 10, this.vtc * 10);
                bbuf.position(0);
                bbuf.limit(this.vtc * 40);
                this.o += this.vtc;
                if (this.ht) {
                    fbuf.position(3);
                    GL11.glTexCoordPointer((int)4, (int)40, (FloatBuffer)fbuf);
                    GL11.glEnableClientState((int)32888);
                }
                if (this.in) {
                    bbuf.position(32);
                    GL11.glNormalPointer((int)40, (ByteBuffer)bbuf);
                    GL11.glEnableClientState((int)32885);
                }
                fbuf.position(0);
                GL11.glVertexPointer((int)3, (int)40, (FloatBuffer)fbuf);
                GL11.glEnableClientState((int)32884);
                GL11.glDrawArrays((int)this.dm, (int)0, (int)this.vtc);
                GL11.glDisableClientState((int)32884);
                if (this.ht) {
                    GL11.glDisableClientState((int)32888);
                }
                if (!this.in) continue;
                GL11.glDisableClientState((int)32885);
            }
            if (this.rbs > 131072 && this.rbi < this.rbs << 3) {
                this.rbs = 0;
                this.rb = null;
            }
            this.reset();
        }
        return 0;
    }

    private void reset() {
        this.rbi = 0;
        this.verts = 0;
        bbuf.clear();
    }

    public void addVertex(float par1, float par3, float par5) {
        if (this.rbi >= this.rbs - 40) {
            if (this.rbs == 0) {
                this.rbs = 65536;
                this.rb = new int[this.rbs];
            } else {
                this.rbs *= 2;
                this.rb = Arrays.copyOf(this.rb, this.rbs);
            }
        }
        if (this.ht) {
            this.rb[this.rbi + 3] = Float.floatToRawIntBits(this.u);
            this.rb[this.rbi + 4] = Float.floatToRawIntBits(this.v);
            this.rb[this.rbi + 5] = Float.floatToRawIntBits(0.0f);
            this.rb[this.rbi + 6] = Float.floatToRawIntBits(this.w);
        }
        if (this.in) {
            this.rb[this.rbi + 8] = this.n;
        }
        this.rb[this.rbi] = Float.floatToRawIntBits(par1 + this.x);
        this.rb[this.rbi + 1] = Float.floatToRawIntBits(par3 + this.y);
        this.rb[this.rbi + 2] = Float.floatToRawIntBits(par5 + this.z);
        this.rbi += 10;
        ++this.verts;
    }

    public void addVertexWithUV(float i, float j, float k, float l, float m) {
        this.setTextureUV(l, m);
        this.addVertex(i, j, k);
    }

    public void addVertexWithUVW(float i, float j, float k, float l, float m, float n) {
        this.setTextureUVW(l, m, n);
        this.addVertex(i, j, k);
    }

    public void setNormal(float x, float y, float z) {
        this.in = true;
        byte b0 = (byte)(x * 127.0f);
        byte b1 = (byte)(y * 127.0f);
        byte b2 = (byte)(z * 127.0f);
        this.n = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }

    public void setTextureUV(float i, float j) {
        this.ht = true;
        this.u = i;
        this.v = j;
        this.w = 1.0f;
    }

    public void setTextureUVW(float i, float j, float k) {
        this.ht = true;
        this.u = i;
        this.v = j;
        this.w = k;
    }

    public void setTranslation(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void addTranslation(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public static void bindTexture(ResourceLocation textureURI) {
        if (ConfigHandler.FORCE_TEXTURE_BINDING) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(textureURI);
        } else {
            ITextureObject object = Minecraft.func_71410_x().func_110434_K().func_110581_b(textureURI);
            if (object == null) {
                object = new SimpleTexture(textureURI);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(textureURI, object);
            }
            if (GL11.glGetInteger((int)3553) != object.func_110552_b()) {
                GL11.glBindTexture((int)3553, (int)object.func_110552_b());
            }
        }
    }
}

