/*
 * Decompiled with CFR 0.152.
 */
package train.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemArmor;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import train.common.api.LiquidManager;
import train.common.blocks.TCBlocks;
import train.common.core.CommonProxy;
import train.common.core.CreativeTabTraincraft;
import train.common.core.TrainModCore;
import train.common.core.handlers.AchievementHandler;
import train.common.core.handlers.ConfigHandler;
import train.common.core.handlers.CraftingHandler;
import train.common.core.handlers.EntityHandler;
import train.common.core.handlers.FuelHandler;
import train.common.core.handlers.OreHandler;
import train.common.core.handlers.PacketHandler;
import train.common.core.handlers.RecipeHandler;
import train.common.core.handlers.RetrogenHandler;
import train.common.core.handlers.VillagerTraincraftHandler;
import train.common.generation.ComponentVillageTrainstation;
import train.common.generation.WorldGenWorld;
import train.common.items.TCItems;
import train.common.recipes.AssemblyTableRecipes;

@Mod(modid="tc", name="Traincraft", version="4.4.1_020-CE_4")
public class Traincraft {
    @Mod.Instance(value="tc")
    public static Traincraft instance;
    @SidedProxy(clientSide="train.client.core.ClientProxy", serverSide="train.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger tcLog;
    public static SimpleNetworkWrapper modChannel;
    public static SimpleNetworkWrapper keyChannel;
    public static SimpleNetworkWrapper rotationChannel;
    public static SimpleNetworkWrapper slotschannel;
    public static SimpleNetworkWrapper ignitionChannel;
    public static SimpleNetworkWrapper brakeChannel;
    public static SimpleNetworkWrapper lockChannel;
    public static SimpleNetworkWrapper builderChannel;
    public static SimpleNetworkWrapper updateTrainIDChannel;
    public static SimpleNetworkWrapper updateDestinationChannel;
    public static final SimpleNetworkWrapper itaChannel;
    public static SimpleNetworkWrapper itsChannel;
    public static SimpleNetworkWrapper itnsChannel;
    public static final SimpleNetworkWrapper mtlChannel;
    public static final SimpleNetworkWrapper msChannel;
    public static final SimpleNetworkWrapper mscChannel;
    public static final SimpleNetworkWrapper atoChannel;
    public static final SimpleNetworkWrapper atoDoSlowDownChannel;
    public static final SimpleNetworkWrapper atoDoAccelChannel;
    public static final SimpleNetworkWrapper atoSetStopPoint;
    public static final SimpleNetworkWrapper NCSlowDownChannel;
    public static final SimpleNetworkWrapper gsfsChannel;
    public static final SimpleNetworkWrapper gsfsrChannel;
    public static File configDirectory;
    public static CreativeTabs tcTab;
    public ItemArmor.ArmorMaterial armor = EnumHelper.addArmorMaterial((String)"Armor", (int)5, (int[])new int[]{1, 2, 2, 1}, (int)25);
    public ItemArmor.ArmorMaterial armorCloth = EnumHelper.addArmorMaterial((String)"TCcloth", (int)5, (int[])new int[]{1, 2, 2, 1}, (int)25);
    public ItemArmor.ArmorMaterial armorCompositeSuit = EnumHelper.addArmorMaterial((String)"TCsuit", (int)70, (int[])new int[]{2, 6, 5, 2}, (int)50);
    public static int trainArmor;
    public static int trainCloth;
    public static int trainCompositeSuit;
    public static WorldGenWorld worldGen;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        tcLog.info("Starting Traincraft 4.4.1_020-CE_4!");
        configDirectory = event.getModConfigurationDirectory();
        ConfigHandler.init(new File(event.getModConfigurationDirectory(), "Traincraft.cfg"));
        proxy.registerKeyBindingHandler();
        tcLog.info("Initialize Blocks, Items, ...");
        tcTab = new CreativeTabTraincraft(CreativeTabs.getNextID(), "Traincraft");
        trainArmor = proxy.addArmor("armor");
        trainCloth = proxy.addArmor("Paintable");
        trainCompositeSuit = proxy.addArmor("CompositeSuit");
        TCBlocks.init();
        TCItems.init();
        EntityHandler.init();
        proxy.registerTileEntities();
        proxy.registerSounds();
        proxy.setHook();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        AchievementHandler.load();
        AchievementPage.registerAchievementPage((AchievementPage)AchievementHandler.tmPage);
        worldGen = new WorldGenWorld();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)5);
        RetrogenHandler retroGen = new RetrogenHandler();
        MinecraftForge.EVENT_BUS.register((Object)retroGen);
        FMLCommonHandler.instance().bus().register((Object)retroGen);
        MapGenStructureIO.func_143031_a(ComponentVillageTrainstation.class, (String)"Trainstation");
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            try {
                proxy.registerComputerCraftPeripherals();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        tcLog.info("Initialize Renderer and Events");
        proxy.registerRenderInformation();
        proxy.registerEvents(event);
        PacketHandler.init();
        tcLog.info("Finished PreInitialization");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        tcLog.info("Start Initialization");
        tcLog.info("Initialize Gui");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        OreHandler.registerOres();
        tcLog.info("Initialize Recipes");
        RecipeHandler.initBlockRecipes();
        RecipeHandler.initItemRecipes();
        RecipeHandler.initSmeltingRecipes();
        AssemblyTableRecipes.recipes();
        tcLog.info("Initialize Fluids");
        LiquidManager.getInstance().registerLiquids();
        proxy.registerTextureFX();
        tcLog.info("Initialize Station Chief Villager");
        VillagerRegistry.instance().registerVillagerId(ConfigHandler.TRAINCRAFT_VILLAGER_ID);
        VillagerTraincraftHandler villageHandler = new VillagerTraincraftHandler();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
        proxy.registerVillagerSkin(ConfigHandler.TRAINCRAFT_VILLAGER_ID, "station_chief.png");
        VillagerRegistry.instance().registerVillageTradeHandler(ConfigHandler.TRAINCRAFT_VILLAGER_ID, (VillagerRegistry.IVillageTradeHandler)villageHandler);
        proxy.registerBookHandler();
        tcLog.info("Finished Initialization");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        tcLog.info("Start to PostInitialize");
        tcLog.info("Register ChunkHandler");
        tcLog.info("Activation Mod Compatibility");
        TrainModCore.ModsLoaded();
        LiquidManager.getLiquidsFromDictionnary();
        tcLog.info("Finished PostInitialization");
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        proxy.killAllStreams();
    }

    static {
        tcLog = LogManager.getLogger((String)"Traincraft");
        updateTrainIDChannel = NetworkRegistry.INSTANCE.newSimpleChannel("TrainIDChannel");
        updateDestinationChannel = NetworkRegistry.INSTANCE.newSimpleChannel("updateDestnChannel");
        itaChannel = NetworkRegistry.INSTANCE.newSimpleChannel("TransmitterAspect");
        itsChannel = NetworkRegistry.INSTANCE.newSimpleChannel("TransmitterSpeed");
        itnsChannel = NetworkRegistry.INSTANCE.newSimpleChannel("TransmitterNextSpeed");
        mtlChannel = NetworkRegistry.INSTANCE.newSimpleChannel("MTCLevelUpdater");
        msChannel = NetworkRegistry.INSTANCE.newSimpleChannel("MTCStatus");
        mscChannel = NetworkRegistry.INSTANCE.newSimpleChannel("MTCStatusToClient");
        atoChannel = NetworkRegistry.INSTANCE.newSimpleChannel("ATOPacket");
        atoDoSlowDownChannel = NetworkRegistry.INSTANCE.newSimpleChannel("ATODoSlowDown");
        atoDoAccelChannel = NetworkRegistry.INSTANCE.newSimpleChannel("ATODoAccel");
        atoSetStopPoint = NetworkRegistry.INSTANCE.newSimpleChannel("ATOSetStopPoint");
        NCSlowDownChannel = NetworkRegistry.INSTANCE.newSimpleChannel("NCDoSlowDown");
        gsfsChannel = NetworkRegistry.INSTANCE.newSimpleChannel("gsfsChannel");
        gsfsrChannel = NetworkRegistry.INSTANCE.newSimpleChannel("gsfsReturnChannel");
    }
}

