/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks.tracks;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackTile;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.api.ElectricTrain;
import train.common.api.EntityRollingStock;
import train.common.blocks.tracks.SpeedControllerSteel;
import train.common.blocks.tracks.TrackBaseTraincraft;
import train.common.core.handlers.ConfigHandler;
import train.common.library.Tracks;

public class BlockEnergyTrack
extends TrackBaseTraincraft
implements ITrackPowered,
IEnergyHandler,
IElectricGrid {
    public int maxEnergy = 2000;
    public int output = 500;
    public boolean isProvider = false;
    private Block thisBlock;
    private int updateTicks = 0;
    protected boolean powered = false;
    private static ForgeDirection[] dirMap = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};
    private IElectricGrid.ChargeHandler RFChandler;

    public BlockEnergyTrack() {
        this.speedController = SpeedControllerSteel.getInstance();
        this.RFChandler = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.TRACK);
    }

    @Override
    public Tracks getTrackType() {
        return Tracks.ENERGY_TRACK;
    }

    private Block getThisBlock() {
        if (this.thisBlock == null) {
            this.thisBlock = this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ());
        }
        return this.thisBlock;
    }

    public boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void updateEntity() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        ++this.updateTicks;
        if (!ConfigHandler.ENERGYTRACK_USES_RF) {
            if (this.isPowered() && this.updateTicks % 2 == 0 && this.RFChandler.getCharge() < this.getMaxEnergy()) {
                this.RFChandler.addCharge(1.0);
            }
            if (this.updateTicks % 50 == 0) {
                this.markBlockNeedsUpdate();
            }
            return;
        }
        if (this.updateTicks % 10 == 0 && (double)this.maxEnergy > this.RFChandler.getCharge()) {
            if (this.getWorld().func_147438_o(this.getX(), this.getY() - 1, this.getZ()) instanceof IEnergyProvider) {
                System.out.println("found input and it gives " + ((IEnergyProvider)this.getWorld().func_147438_o(this.getX(), this.getY() - 1, this.getZ())).extractEnergy(ForgeDirection.UP, 100, true));
                this.receiveEnergy(ForgeDirection.DOWN, ((IEnergyProvider)this.getWorld().func_147438_o(this.getX(), this.getY() - 1, this.getZ())).extractEnergy(ForgeDirection.UP, 100, false), false);
            }
            int x = this.getX();
            int y = this.getY();
            int z = this.getZ();
            int ener1 = 0;
            int ener2 = 0;
            for (int[] pos : new int[][]{{x - 1, z, 1}, {x + 1, z, 0}, {x, z - 1, 3}, {x, z + 1, 2}}) {
                if (!((double)this.maxEnergy > this.RFChandler.getCharge())) break;
                if (this.getWorld().func_147438_o(pos[0], y, pos[1]) instanceof IEnergyProvider) {
                    ener1 = ((IEnergyProvider)this.getWorld().func_147438_o(pos[0], y, pos[1])).extractEnergy(dirMap[pos[2]], 100, false);
                }
                if (this.getWorld().func_147438_o(pos[0], y - 1, pos[1]) instanceof IEnergyProvider) {
                    ener2 = ((IEnergyProvider)this.getWorld().func_147438_o(pos[0], y - 1, pos[1])).extractEnergy(dirMap[pos[2]], 100, false);
                }
                this.receiveEnergy(ForgeDirection.UP, ener1 + ener2, false);
            }
            for (int[] pos : new int[][]{{x - 1, z}, {x + 1, z}, {x, z - 1}, {x, z + 1}}) {
                double diff;
                TileEntity te = this.getWorld().func_147438_o(pos[0], y, pos[1]);
                if (te instanceof ITrackTile && ((ITrackTile)te).getTrackInstance() instanceof BlockEnergyTrack && (int)((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().getCharge() - (int)this.RFChandler.getCharge() > 1) {
                    diff = (((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().getCharge() - this.RFChandler.getCharge()) / 2.0;
                    this.RFChandler.addCharge(diff);
                    ((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().removeCharge(diff);
                }
                if ((te = this.getWorld().func_147438_o(pos[0], y - 1, pos[1])) instanceof ITrackTile && ((ITrackTile)te).getTrackInstance() instanceof BlockEnergyTrack && (int)((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().getCharge() - (int)this.RFChandler.getCharge() > 1) {
                    diff = (((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().getCharge() - this.RFChandler.getCharge()) / 2.0;
                    this.RFChandler.addCharge(diff);
                    ((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().removeCharge(diff);
                }
                if (!((te = this.getWorld().func_147438_o(pos[0], y + 1, pos[1])) instanceof ITrackTile) || !(((ITrackTile)te).getTrackInstance() instanceof BlockEnergyTrack) || (int)((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().getCharge() - (int)this.RFChandler.getCharge() <= 1) continue;
                diff = (((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().getCharge() - this.RFChandler.getCharge()) / 2.0;
                this.RFChandler.addCharge(diff);
                ((BlockEnergyTrack)((ITrackTile)te).getTrackInstance()).getChargeHandler().removeCharge(diff);
            }
        }
        if (this.updateTicks % 50 == 0) {
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public IIcon getIcon() {
        int meta = this.tileEntity.func_145832_p();
        if (meta >= 6) {
            if (this.RFChandler.getCharge() > 0.0) {
                return this.getIcon(3);
            }
            return this.getIcon(2);
        }
        if (this.RFChandler.getCharge() > 0.0) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean isFlexibleRail() {
        return true;
    }

    private void notifyNeighbors() {
        Block block = this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), block);
        this.getWorld().func_147459_d(this.getX(), this.getY() - 1, this.getZ(), block);
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)current.func_77973_b();
            player.func_145747_a((IChatComponent)new ChatComponentText("stored: " + this.RFChandler.getCharge() + "/" + (int)this.getMaxEnergy() + " RF"));
            this.markBlockNeedsUpdate();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (!(cart instanceof ElectricTrain)) {
            return;
        }
        if (this.RFChandler.getCharge() > 20.0 && ((ElectricTrain)cart).fuelTrain < ((ElectricTrain)cart).maxEnergy) {
            double transfered = this.RFChandler.getCharge() * 0.05;
            ((EntityRollingStock)cart).fuelTrain = (int)((double)((EntityRollingStock)cart).fuelTrain + transfered);
            this.RFChandler.removeCharge(transfered);
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.RFChandler.getCharge());
        nbttagcompound.func_74757_a("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.RFChandler.setCharge(nbttagcompound.func_74769_h("energy"));
        this.powered = nbttagcompound.func_74767_n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeDouble(this.RFChandler.getCharge());
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.RFChandler.setCharge(data.readDouble());
        this.powered = data.readBoolean();
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return 5;
    }

    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection dir, int ammount, boolean simulate) {
        if ((double)this.maxEnergy > this.RFChandler.getCharge()) {
            if ((double)this.maxEnergy - this.RFChandler.getCharge() >= (double)ammount) {
                if (!simulate) {
                    this.RFChandler.addCharge(ammount);
                }
                return ammount;
            }
            int div = (int)((double)this.maxEnergy - this.RFChandler.getCharge());
            if (!simulate) {
                this.RFChandler.setCharge(this.maxEnergy);
            }
            return div;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection dir, int ammount, boolean simulate) {
        if (this.RFChandler.getCharge() >= (double)ammount) {
            if (!simulate) {
                this.RFChandler.removeCharge(ammount);
            }
            return ammount;
        }
        int div = (int)this.RFChandler.getCharge();
        if (!simulate) {
            this.RFChandler.setCharge(0.0);
        }
        return div;
    }

    @Override
    public int getEnergyStored(ForgeDirection dir) {
        return (int)this.RFChandler.getCharge();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection dir) {
        return this.maxEnergy;
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.RFChandler;
    }
}

