/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import train.common.api.DieselTrain;
import train.common.api.ElectricTrain;
import train.common.api.Freight;
import train.common.api.SteamTrain;
import train.common.api.Tender;
import train.common.entity.rollingStock.EntityBulkheadFlatCart;
import train.common.entity.rollingStock.EntityFlatCarLogs_DB;
import train.common.entity.rollingStock.EntityFlatCarRails_DB;
import train.common.entity.rollingStock.EntityFlatCartWoodUS;
import train.common.entity.rollingStock.EntityFreightBap60centerbeam;
import train.common.entity.rollingStock.EntityFreightBap66centerbeam;
import train.common.entity.rollingStock.EntityFreightBap73centerbeam;
import train.common.entity.rollingStock.EntityFreightBapOreJenny;
import train.common.entity.rollingStock.EntityFreightBapSkeletonLogCar;
import train.common.entity.rollingStock.EntityFreightBapVersaLongi;
import train.common.entity.rollingStock.EntityFreightBapVersaTrans;
import train.common.entity.rollingStock.EntityFreightBapWoodchipHopper;
import train.common.entity.rollingStock.EntityFreightCenterbeam_Wood_1;
import train.common.entity.rollingStock.EntityFreightCenterbeam_Wood_2;
import train.common.entity.rollingStock.EntityFreightGrain;
import train.common.entity.rollingStock.EntityFreightIceWagon;
import train.common.entity.rollingStock.EntityFreightMinetrain;
import train.common.entity.rollingStock.EntityFreightSlateWagon;
import train.common.entity.rollingStock.EntityFreightWood;
import train.common.entity.rollingStock.EntityFreightWood2;
import train.common.items.ItemBlockOreTC;
import train.common.items.ItemTCRail;

public class ItemHandler {
    private static LinkedList<String> OREDICT_ORES = null;

    public static boolean handleItems(Entity entity, ItemStack itemstack) {
        if (itemstack != null) {
            if (entity instanceof Freight) {
                return ItemHandler.handleFreight(entity, itemstack);
            }
            if (entity instanceof DieselTrain) {
                return false;
            }
            if (entity instanceof ElectricTrain) {
                return false;
            }
            if (entity instanceof SteamTrain) {
                return false;
            }
            if (entity instanceof Tender) {
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean handleFreight(Entity entity, ItemStack itemstack) {
        int logWood = OreDictionary.getOreID((String)"logWood");
        int plankWood = OreDictionary.getOreID((String)"plankWood");
        int slabWood = OreDictionary.getOreID((String)"slabWood");
        int stairWood = OreDictionary.getOreID((String)"stairWood");
        int rubberWood = OreDictionary.getOreID((String)"woodRubber");
        int pulpWood = OreDictionary.getOreID((String)"pulpWood");
        int dustWood = OreDictionary.getOreID((String)"dustWood");
        if (itemstack == null) {
            return false;
        }
        Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
        if (block == null) {
            return false;
        }
        if (entity instanceof EntityFreightCenterbeam_Wood_1 || entity instanceof EntityFreightCenterbeam_Wood_2 || entity instanceof EntityFlatCartWoodUS || entity instanceof EntityBulkheadFlatCart || entity instanceof EntityFlatCarLogs_DB || entity instanceof EntityFreightWood || entity instanceof EntityFreightWood2 || entity instanceof EntityFreightBap73centerbeam || entity instanceof EntityFreightBap66centerbeam || entity instanceof EntityFreightBap60centerbeam) {
            int isid = OreDictionary.getOreID((ItemStack)itemstack);
            return isid == plankWood || isid == logWood || isid == slabWood || isid == stairWood || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150468_ap) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150422_aJ) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150396_be) || isid == rubberWood;
        }
        if (entity instanceof EntityFreightBapSkeletonLogCar) {
            int isid = OreDictionary.getOreID((ItemStack)itemstack);
            return isid == logWood;
        }
        if (entity instanceof EntityFlatCarRails_DB) {
            return block instanceof BlockRailBase || itemstack.func_77973_b() instanceof ItemTCRail;
        }
        if (entity instanceof EntityFreightGrain) {
            Item item = itemstack.func_77973_b();
            if (item == Items.field_151015_O || item == Items.field_151014_N || item == Items.field_151081_bc || item == Items.field_151080_bb || item instanceof ItemSeeds) {
                return true;
            }
            return ItemHandler.cropStuff(itemstack);
        }
        if (entity instanceof EntityFreightMinetrain) {
            return block.func_149662_c();
        }
        if (entity instanceof EntityFreightBapWoodchipHopper) {
            return ItemHandler.powderWood(itemstack);
        }
        if (entity instanceof EntityFreightBapOreJenny) {
            return ItemHandler.oreBlocks(itemstack);
        }
        if (entity instanceof EntityFreightSlateWagon) {
            return block.func_149688_o() == Material.field_151576_e;
        }
        if (entity instanceof EntityFreightIceWagon) {
            return block.func_149688_o() == Material.field_151588_w || block.func_149688_o() == Material.field_151598_x;
        }
        if (entity instanceof EntityFreightBapVersaLongi || entity instanceof EntityFreightBapVersaTrans) {
            return block.func_149688_o() == Material.field_151595_p || block.func_149688_o() == Material.field_151571_B || block.func_149688_o() == Material.field_151578_c || itemstack.func_77973_b() instanceof ItemBlockOreTC;
        }
        return true;
    }

    private static boolean cropStuff(ItemStack itemstack) {
        String[] names;
        for (String name : names = new String[]{"cropCorn", "cropRice", "seedRice", "seedCorn", "listAllseed"}) {
            if (OreDictionary.getOreID((String)name) != OreDictionary.getOreID((ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    private static boolean powderWood(ItemStack itemstack) {
        String[] names;
        for (String name : names = new String[]{"dustWood", "pulpWood"}) {
            if (OreDictionary.getOreID((String)name) != OreDictionary.getOreID((ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean oreBlocks(ItemStack i) {
        if (OREDICT_ORES == null) {
            OREDICT_ORES = new LinkedList();
        }
        if (!OREDICT_ORES.contains(i.func_77977_a())) {
            int[] nArray = OreDictionary.getOreIDs((ItemStack)i);
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                Integer ore = nArray[j];
                if (!OreDictionary.getOreName((int)ore).toLowerCase().startsWith("ore")) continue;
                OREDICT_ORES.add(i.func_77977_a());
                return true;
            }
        }
        return OREDICT_ORES.contains(i.func_77977_a());
    }
}

