/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import train.common.core.handlers.ConfigHandler;
import train.common.inventory.TrainCraftingManager;
import train.common.library.BlockIDs;
import train.common.library.ItemIDs;
import train.common.recipes.AssemblyTableRecipes;
import train.common.recipes.RecipesArmorDyes;

public class RecipeHandler {
    private static ArrayList<ItemStack> multiNameOreDict(String ... names) {
        ArrayList<ItemStack> entries = new ArrayList<ItemStack>();
        for (String name : names) {
            entries.addAll(OreDictionary.getOres((String)name));
        }
        return entries;
    }

    public static void initBlockRecipes() {
        ArrayList iron = OreDictionary.getOres((String)"ingotIron");
        TrainCraftingManager.instance.getRecipeList().add(new RecipesArmorDyes());
        for (ItemStack ironingot : iron) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.assemblyTableI.block, 1), (Object[])new Object[]{"IPI", "S S", "SPS", Character.valueOf('I'), ironingot, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('S'), Blocks.field_150348_b});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.assemblyTableII.block, 1), (Object[])new Object[]{"GPG", "O O", "OPO", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('O'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.assemblyTableIII.block, 1), (Object[])new Object[]{"GPG", "DLD", "OPO", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('L'), Blocks.field_150426_aN, Character.valueOf('O'), Blocks.field_150343_Z});
        if (!ConfigHandler.DISABLE_TRAIN_WORKBENCH) {
            for (ItemStack ironingot : iron) {
                RecipeHandler.addDictRecipe(new ItemStack(BlockIDs.trainWorkbench.block, 1), "###", "IFI", "###", Character.valueOf('#'), "plankWood", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('I'), ironingot);
            }
        }
        RecipeHandler.addDictRecipe(new ItemStack(BlockIDs.distilIdle.block, 1), "###", "#F#", "###", Character.valueOf('#'), "ingotSteel", Character.valueOf('F'), ItemIDs.firebox.item);
        if (!ConfigHandler.MAKE_MODPACKS_GREAT_AGAIN) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.openFurnaceIdle.block, 1), (Object[])new Object[]{"#L#", "#B#", "#I#", Character.valueOf('#'), Blocks.field_150385_bj, Character.valueOf('L'), Items.field_151129_at, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('I'), Blocks.field_150339_S});
        }
        for (ItemStack ironingot : iron) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.lantern.block, 4), (Object[])new Object[]{"III", "PTP", "III", Character.valueOf('I'), ironingot, Character.valueOf('P'), Blocks.field_150410_aZ, Character.valueOf('T'), Blocks.field_150478_aa});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.overalls.item, 1), (Object[])new Object[]{" # ", "X$X", "X$X", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('$'), Items.field_151026_S, Character.valueOf('#'), new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.jacket.item, 1), (Object[])new Object[]{"X X", "X$X", "X#X", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 14), Character.valueOf('$'), Items.field_151027_R, Character.valueOf('#'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.hat.item, 1), (Object[])new Object[]{" X ", "X$X", "#X#", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('$'), Items.field_151024_Q, Character.valueOf('#'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.pants_driver_paintable.item, 1), (Object[])new Object[]{"XXX", "XLX", "X$X", Character.valueOf('L'), Items.field_151026_S, Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('X'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.jacket_driver_paintable.item, 1), (Object[])new Object[]{"X X", "XRX", "XPX", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('P'), Items.field_151027_R, Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.hat_driver_paintable.item, 1), (Object[])new Object[]{"#$#", "# #", Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('#'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.pants_ticketMan_paintable.item, 1), (Object[])new Object[]{"XXX", "XLX", "X$X", Character.valueOf('L'), Items.field_151026_S, Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 8), Character.valueOf('X'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.jacket_ticketMan_paintable.item, 1), (Object[])new Object[]{"X X", "XPX", "X#X", Character.valueOf('P'), Items.field_151027_R, Character.valueOf('#'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('X'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.hat_ticketMan_paintable.item, 1), (Object[])new Object[]{"#$#", "# #", Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('#'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.recipeBook.item, 1), (Object[])new Object[]{"TTT", "TBT", "TTT", Character.valueOf('T'), Blocks.field_150448_aq, Character.valueOf('B'), Items.field_151122_aG});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailSmallStraight.item, 16), (Object[])new Object[]{"G G", "GPG", "G G", Character.valueOf('G'), Items.field_151042_j, Character.valueOf('P'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailMediumStraight.item, 1), (Object[])new Object[]{"G  ", "G  ", "G  ", Character.valueOf('G'), ItemIDs.tcRailSmallStraight.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailLongStraight.item, 1), (Object[])new Object[]{"G  ", "G  ", "   ", Character.valueOf('G'), ItemIDs.tcRailMediumStraight.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailMediumTurn.item, 1), (Object[])new Object[]{"GG ", "G  ", "   ", Character.valueOf('G'), ItemIDs.tcRailSmallStraight.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailMediumSwitch.item, 1), (Object[])new Object[]{"G  ", "GHG", "G  ", Character.valueOf('G'), ItemIDs.tcRailSmallStraight.item, Character.valueOf('H'), ItemIDs.tcRailMediumTurn.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailMediumParallelSwitch.item, 1), (Object[])new Object[]{"I G", "IHH", "IH ", Character.valueOf('G'), ItemIDs.tcRailSmallStraight.item, Character.valueOf('H'), ItemIDs.tcRailMediumTurn.item, Character.valueOf('I'), ItemIDs.tcRailMediumStraight.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailLargeTurn.item, 1), (Object[])new Object[]{" GG", "GG ", "G  ", Character.valueOf('G'), ItemIDs.tcRailSmallStraight.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailLargeSwitch.item, 1), (Object[])new Object[]{"G  ", "HIG", "G  ", Character.valueOf('G'), ItemIDs.tcRailSmallStraight.item, Character.valueOf('H'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('I'), ItemIDs.tcRailLargeTurn.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailVeryLargeTurn.item, 1), (Object[])new Object[]{"SS ", "S  ", "   ", Character.valueOf('S'), ItemIDs.tcRailMediumTurn.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailSlopeGravel.item, 1), (Object[])new Object[]{" TG", "TGG", "GGG", Character.valueOf('T'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('G'), Blocks.field_150351_n});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailLargeSlopeGravel.item, 1), (Object[])new Object[]{"   ", "  S", " S ", Character.valueOf('S'), ItemIDs.tcRailSlopeGravel.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailSlopeSnowGravel.item, 1), (Object[])new Object[]{" TS", "TSS", "SSS", Character.valueOf('T'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('S'), new ItemStack(BlockIDs.oreTC.block, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailLargeSlopeSnowGravel.item, 1), (Object[])new Object[]{"   ", "  T", " T ", Character.valueOf('T'), ItemIDs.tcRailSlopeSnowGravel.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailVeryLargeSlopeSnowGravel.item, 1), (Object[])new Object[]{"   ", "  T", " T ", Character.valueOf('T'), ItemIDs.tcRailLargeSlopeSnowGravel.item});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ItemIDs.tcRailSuperLargeTurn.item, 1), (Object[])new Object[]{ItemIDs.tcRailVeryLargeTurn.item, ItemIDs.tcRailVeryLargeTurn.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.bolt.item, 16), (Object[])new Object[]{" II", " I ", " I ", Character.valueOf('I'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailConcreteSmallStraight.item, 16), (Object[])new Object[]{"I I", "IBI", "I I", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), ItemIDs.bolt.item});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.tcRailSmallStraight.item, 32), (Object[])new Object[]{"I I", "BLB", "I I", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), ItemIDs.bolt.item, Character.valueOf('L'), Blocks.field_150364_r});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.paintbrushThing.item, 1), (Object[])new Object[]{"GB ", "RIS", " ST", Character.valueOf('G'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('T'), new ItemStack(Items.field_151055_y)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.poweredGravel.block, 1), (Object[])new Object[]{new ItemStack(Items.field_151137_ax), new ItemStack(Blocks.field_150351_n)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.snowGravel.block, 1), (Object[])new Object[]{new ItemStack(Items.field_151126_ay), new ItemStack(Blocks.field_150351_n)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.snowGravel.block, 4), (Object[])new Object[]{new ItemStack(Blocks.field_150433_aE), new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150351_n)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.signalSpanish.block, 1), (Object[])new Object[]{" L ", " I ", "RIR", Character.valueOf('L'), new ItemStack(Blocks.field_150379_bu), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('R'), new ItemStack(Items.field_151137_ax)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.kSignal.block, 1), (Object[])new Object[]{"RIR", " I ", " L ", Character.valueOf('L'), new ItemStack(Blocks.field_150379_bu), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('R'), new ItemStack(Items.field_151137_ax)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.bridgePillar.block, 8), (Object[])new Object[]{"SSS", "SLS", "SSS", Character.valueOf('S'), new ItemStack(Items.field_151055_y), Character.valueOf('L'), new ItemStack(Blocks.field_150364_r)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.speedSign.block, 8), (Object[])new Object[]{" R ", " I ", " I ", Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('I'), new ItemStack(Items.field_151042_j)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.oreTC.block, 4, 3), (Object[])new Object[]{Blocks.field_150351_n, Blocks.field_150351_n, Items.field_151119_aD});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.oreTC.block, 16, 3), (Object[])new Object[]{Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150435_aG});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.dirtyBallast.block, 16), (Object[])new Object[]{Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150346_d});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BlockIDs.dirtierBallast.block, 16), (Object[])new Object[]{new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), new ItemStack(BlockIDs.dirtyBallast.block, 1), Blocks.field_150346_d});
        for (ItemStack ironingot : iron) {
            RecipeHandler.addDictRecipe(new ItemStack(BlockIDs.switchStand.block, 1), " W ", " I ", " R ", Character.valueOf('W'), Blocks.field_150442_at, Character.valueOf('R'), Items.field_151055_y, Character.valueOf('I'), ironingot);
            RecipeHandler.addDictRecipe(new ItemStack(BlockIDs.MILWSwitchStand.block, 1), " RW", "BWR", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151055_y), Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('W'), new ItemStack(Items.field_151100_aR, 1, 15));
            RecipeHandler.addDictRecipe(new ItemStack(BlockIDs.MFPBWigWag.block, 1), "IWI", " I ", " I ", Character.valueOf('W'), Blocks.field_150442_at, Character.valueOf('I'), ironingot);
            RecipeHandler.addDictRecipe(new ItemStack(BlockIDs.stopper.block, 1), "WWW", "I I", "RRR", Character.valueOf('W'), "plankWood", Character.valueOf('R'), Blocks.field_150448_aq, Character.valueOf('I'), ironingot);
        }
    }

    public static void initItemRecipes() {
        ArrayList steel = OreDictionary.getOres((String)"ingotSteel");
        ArrayList iron = OreDictionary.getOres((String)"ingotIron");
        ArrayList planks = OreDictionary.getOres((String)"plankWood");
        ArrayList logs = OreDictionary.getOres((String)"logWood");
        ArrayList<ItemStack> plastics = RecipeHandler.multiNameOreDict("itemPlastic", "dustPlastic");
        ArrayList copper = OreDictionary.getOres((String)"ingotCopper");
        ArrayList dustCoal = OreDictionary.getOres((String)"dustCoal");
        ArrayList<ItemStack> coal = new ArrayList<ItemStack>();
        coal.add(new ItemStack(Items.field_151044_h));
        coal.addAll(OreDictionary.getOres((String)"coal"));
        ArrayList redstone = OreDictionary.getOres((String)"dustRedstone");
        ArrayList<ItemStack> waterbucket = AssemblyTableRecipes.waterContainers();
        for (ItemStack plank : planks) {
            for (ItemStack ironingot : iron) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.trainWorkbench.block, 1), "###", "IFI", "###", Character.valueOf('#'), plank, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('I'), ironingot);
            }
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.recipeBook.item, 1), "TTT", "TBT", "TTT", Character.valueOf('T'), Blocks.field_150448_aq, Character.valueOf('B'), Items.field_151122_aG);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.chunkLoaderActivator.item, 1), "  P", " S ", "S  ", Character.valueOf('S'), Items.field_151072_bj, Character.valueOf('P'), Items.field_151079_bi);
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.owoYardSwitchStand.block, 1), (Object[])new Object[]{"   ", "OS ", "IW ", Character.valueOf('O'), new ItemStack(Items.field_151100_aR, 1, 14), Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.owoSwitchStand.block, 1), (Object[])new Object[]{" O ", " S ", " IW", Character.valueOf('O'), new ItemStack(Items.field_151100_aR, 1, 14), Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.circleSwitchStand.block, 1), (Object[])new Object[]{" R ", " S ", " IW", Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.autoSwtichStand.block, 1), (Object[])new Object[]{"   ", "C  ", "BIW", Character.valueOf('C'), new ItemStack(ItemIDs.electronicCircuit.item, 1), Character.valueOf('B'), Blocks.field_150339_S, Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ItemIDs.paintbrushThing.item, 1), (Object[])new Object[]{"GB ", "RIS", " ST", Character.valueOf('G'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('T'), new ItemStack(Items.field_151055_y)});
        for (ItemStack ironingot : iron) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.assemblyTableI.block, 1), "IPI", "S S", "SPS", Character.valueOf('I'), ironingot, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('S'), Blocks.field_150348_b);
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.assemblyTableII.block, 1), "GPG", "O O", "OPO", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('O'), Blocks.field_150343_Z);
        TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.assemblyTableIII.block, 1), "GPG", "DLD", "OPO", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('L'), Blocks.field_150426_aN, Character.valueOf('O'), Blocks.field_150343_Z);
        TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.openFurnaceIdle.block, 1), "#L#", "#B#", "#I#", Character.valueOf('#'), Blocks.field_150385_bj, Character.valueOf('L'), Items.field_151129_at, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('I'), Blocks.field_150339_S);
        for (ItemStack ironingot : iron) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.lantern.block, 4), "III", "PTP", "III", Character.valueOf('I'), ironingot, Character.valueOf('P'), Blocks.field_150410_aZ, Character.valueOf('T'), Blocks.field_150478_aa);
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.overalls.item, 1), " # ", "X$X", "X X", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('$'), Items.field_151026_S, Character.valueOf('#'), new ItemStack(Items.field_151100_aR, 1, 1));
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.jacket.item, 1), "X X", "X$X", "X#X", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 14), Character.valueOf('$'), Items.field_151027_R, Character.valueOf('#'), Items.field_151007_F);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.hat.item, 1), " X ", "X$X", "#X#", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('$'), Items.field_151024_Q, Character.valueOf('#'), Items.field_151007_F);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.pants_driver_paintable.item, 1), "XXX", "XLX", "X$X", Character.valueOf('L'), Items.field_151026_S, Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('X'), Items.field_151007_F);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.jacket_driver_paintable.item, 1), "X X", "XRX", "XPX", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('P'), Items.field_151027_R, Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1));
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.hat_driver_paintable.item, 1), "#$#", "# #", Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('#'), Items.field_151007_F);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.pants_ticketMan_paintable.item, 1), "XXX", "XLX", "X$X", Character.valueOf('L'), Items.field_151026_S, Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 8), Character.valueOf('X'), Items.field_151007_F);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.jacket_ticketMan_paintable.item, 1), "X X", "XPX", "X#X", Character.valueOf('P'), Items.field_151027_R, Character.valueOf('#'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('X'), Items.field_151007_F);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.hat_ticketMan_paintable.item, 1), "#$#", "# #", Character.valueOf('$'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('#'), Items.field_151007_F);
        if (plastics != null && plastics.size() >= 0) {
            for (ItemStack plastic : plastics) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.emptyCanister.item, 4), "PPP", "P P", "PPP", Character.valueOf('P'), plastic);
                for (ItemStack rs : redstone) {
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.electronicCircuit.item, 1), "XXX", "RPR", "XXX", Character.valueOf('X'), ItemIDs.copperWireFine.item, Character.valueOf('P'), plastic, Character.valueOf('R'), rs.func_77973_b());
                }
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.reinforcedPlastic.item, 16), "LPL", "PLP", "GPG", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('P'), ItemIDs.graphite.item, Character.valueOf('L'), plastic);
                if (copper == null || copper.size() < 0) continue;
                for (ItemStack copp : copper) {
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.copperWireFine.item, 6), "XXX", "XPX", "XXX", Character.valueOf('X'), copp, Character.valueOf('P'), plastic);
                    GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.overheadWire.block, 16), (Object[])new Object[]{"IC ", "I  ", "I  ", Character.valueOf('I'), new ItemStack(Items.field_151042_j, 1), Character.valueOf('C'), copp});
                    GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.overheadWireDouble.block, 16), (Object[])new Object[]{"ICI", "ICI", "I I", Character.valueOf('I'), new ItemStack(Items.field_151042_j, 1), Character.valueOf('C'), copp});
                }
            }
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.boots_suit_paintable.item, 1), " D ", "X X", "XFX", Character.valueOf('F'), Items.field_151008_G, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('X'), ItemIDs.reinforcedPlates.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.pants_suit_paintable.item, 1), "XDX", "X$X", "X X", Character.valueOf('$'), Items.field_151059_bz, Character.valueOf('X'), ItemIDs.reinforcedPlates.item, Character.valueOf('D'), Items.field_151045_i);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.jacket_suit_paintable.item, 1), "X X", "XDX", "XAX", Character.valueOf('A'), Items.field_151153_ao, Character.valueOf('X'), ItemIDs.reinforcedPlates.item, Character.valueOf('D'), Blocks.field_150484_ah);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.helmet_suit_paintable.item, 1), "#D#", "# #", Character.valueOf('D'), Blocks.field_150484_ah, Character.valueOf('#'), ItemIDs.reinforcedPlates.item);
        for (ItemStack ironingot : iron) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.generator.item, 1), " ##", "E$$", " ##", Character.valueOf('#'), ItemIDs.copperWireFine.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item, Character.valueOf('$'), ironingot);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.controls.item, 1), "#X#", "#E#", "$$$", Character.valueOf('#'), Blocks.field_150442_at, Character.valueOf('X'), Blocks.field_150430_aB, Character.valueOf('$'), ironingot, Character.valueOf('E'), ItemIDs.electronicCircuit.item);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.electmotor.item, 1), "I#I", "#E#", "I#I", Character.valueOf('#'), ItemIDs.copperWireFine.item, Character.valueOf('I'), ironingot, Character.valueOf('E'), ItemIDs.electronicCircuit.item);
            for (ItemStack bucketWater : waterbucket) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironBoiler.item, 2), "###", "XXX", "###", Character.valueOf('#'), ironingot, Character.valueOf('X'), bucketWater.func_77973_b());
            }
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironFirebox.item, 2), "###", "#X#", "###", Character.valueOf('#'), ironingot, Character.valueOf('X'), Items.field_151033_d);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironChimney.item, 2), "# #", "# #", "# #", Character.valueOf('#'), ironingot);
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.dieselengine.item, 2), "###", "XXX", "CCC", Character.valueOf('#'), ItemIDs.piston.item, Character.valueOf('X'), ItemIDs.cylinder.item, Character.valueOf('C'), ItemIDs.camshaft.item);
        for (ItemStack dustStack : dustCoal) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.graphite.item, 2), "###", "#X#", "###", Character.valueOf('#'), dustStack, Character.valueOf('X'), Items.field_151119_aD);
        }
        if (!ConfigHandler.MAKE_MODPACKS_GREAT_AGAIN) {
            for (ItemStack c : coal) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.coaldust.item, 4), "###", "   ", "   ", Character.valueOf('#'), c.func_77973_b());
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.coaldust.item, 4), "   ", "###", "   ", Character.valueOf('#'), c.func_77973_b());
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.coaldust.item, 4), "   ", "   ", "###", Character.valueOf('#'), c.func_77973_b());
            }
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.generatorDiesel.block, 1), "C  ", "DE ", Character.valueOf('C'), ItemIDs.steelchimney.item, Character.valueOf('D'), ItemIDs.dieselengine.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item);
        if (ConfigHandler.ENABLE_ZEPPELIN) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.balloon.item, 1), "###", "# #", "###", Character.valueOf('#'), Blocks.field_150325_L);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steamengine.item, 1), "C  ", "BF ", Character.valueOf('C'), ItemIDs.steelchimney.item, Character.valueOf('B'), ItemIDs.boiler.item, Character.valueOf('F'), ItemIDs.firebox.item);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.airship.item, 1), "B B", "SES", "POP", Character.valueOf('B'), ItemIDs.balloon.item, Character.valueOf('S'), Items.field_151055_y, Character.valueOf('E'), ItemIDs.steamengine.item, Character.valueOf('P'), ItemIDs.propeller.item, Character.valueOf('O'), Items.field_151124_az);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.zeppelin.item, 1), "BBB", "SES", "POP", Character.valueOf('B'), ItemIDs.balloon.item, Character.valueOf('S'), ItemIDs.propeller.item, Character.valueOf('E'), ItemIDs.controls.item, Character.valueOf('P'), ItemIDs.electmotor.item, Character.valueOf('O'), ItemIDs.seats.item);
        }
        for (ItemStack plankItem : planks) {
            for (ItemStack steelItem : steel) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.reinforcedPlates.item, 1), "RRR", "SSS", "CCC", Character.valueOf('R'), ItemIDs.reinforcedPlastic.item, Character.valueOf('S'), steelItem, Character.valueOf('C'), Items.field_151119_aD);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.composite_wrench.item, 1), "S S", " R ", " R ", Character.valueOf('R'), ItemIDs.reinforcedPlastic.item, Character.valueOf('S'), steelItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelcab.item, 2), "###", "X X", "XXX", Character.valueOf('X'), steelItem, Character.valueOf('#'), plankItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.distilIdle.block, 1), "###", "#F#", "###", Character.valueOf('#'), steelItem, Character.valueOf('F'), ItemIDs.firebox.item);
                for (ItemStack rs : redstone) {
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.transformer.item, 1), "# #", "XEX", "###", Character.valueOf('#'), steelItem, Character.valueOf('E'), ItemIDs.electronicCircuit.item, Character.valueOf('X'), rs.func_77973_b());
                }
                for (ItemStack bucketWater : waterbucket) {
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.boiler.item, 2), "###", "XXX", "###", Character.valueOf('#'), steelItem, Character.valueOf('X'), bucketWater.func_77973_b());
                }
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.firebox.item, 2), "###", "#X#", "###", Character.valueOf('#'), steelItem, Character.valueOf('X'), Items.field_151033_d);
                for (ItemStack ironingot : iron) {
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.bogie.item, 4), " # ", "#X#", " # ", Character.valueOf('#'), steelItem, Character.valueOf('X'), ironingot);
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelframe.item, 2), "# #", "AAA", Character.valueOf('A'), steelItem, Character.valueOf('#'), ironingot);
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelframe.item, 2), "   ", "# #", "AAA", Character.valueOf('A'), steelItem, Character.valueOf('#'), ironingot);
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.stake.item, 1), "   ", "IFI", "   ", Character.valueOf('I'), steelItem, Character.valueOf('F'), ironingot);
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.stake.item, 1), "IFI", "   ", "   ", Character.valueOf('I'), steelItem, Character.valueOf('F'), ironingot);
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.stake.item, 1), "   ", "   ", "IFI", Character.valueOf('I'), steelItem, Character.valueOf('F'), ironingot);
                    TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.propeller.item, 2), " # ", "#X#", " # ", Character.valueOf('#'), plankItem, Character.valueOf('X'), ironingot);
                }
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelchimney.item, 2), "# #", "# #", "# #", Character.valueOf('#'), steelItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(Items.field_151033_d, 2), "* ", " #", Character.valueOf('*'), steelItem, Character.valueOf('#'), Items.field_151145_ak);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.transmition.item, 1), " # ", "#X#", " # ", Character.valueOf('#'), steelItem, Character.valueOf('X'), ItemIDs.diesel.item);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.piston.item, 3), " # ", " X ", Character.valueOf('#'), steelItem, Character.valueOf('X'), Items.field_151055_y);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.camshaft.item, 3), "###", "   ", "   ", Character.valueOf('#'), steelItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.camshaft.item, 3), "   ", "###", "   ", Character.valueOf('#'), steelItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.camshaft.item, 3), "   ", "   ", "###", Character.valueOf('#'), steelItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.cylinder.item, 3), "# #", "# #", "###", Character.valueOf('#'), steelItem);
            }
            for (ItemStack ironItem : iron) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSmallStraight.item, 16), "I I", "IPI", "I I", Character.valueOf('P'), plankItem, Character.valueOf('I'), ironItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSmallRoadCrossing.item, 16), "I I", "IPI", "I I", Character.valueOf('P'), new ItemStack(Blocks.field_150406_ce, 1, 15), Character.valueOf('I'), ironItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSmallRoadCrossing1.item, 16), "I I", "IPI", "I I", Character.valueOf('P'), new ItemStack(Blocks.field_150406_ce, 1, 7), Character.valueOf('I'), ironItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSmallRoadCrossing2.item, 16), "I I", "IPI", "I I", Character.valueOf('P'), new ItemStack(Blocks.field_150406_ce, 1, 8), Character.valueOf('I'), ironItem);
            }
            for (ItemStack logStack : logs) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.waterWheel.block, 1), " P ", "PGP", " P ", Character.valueOf('P'), logStack, Character.valueOf('G'), ItemIDs.generator.item);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.woodenBogie.item, 4), " # ", "#X#", " # ", Character.valueOf('#'), plankItem, Character.valueOf('X'), logStack);
            }
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.woodenFrame.item, 2), "# #", "AAA", Character.valueOf('A'), plankItem, Character.valueOf('#'), plankItem);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.woodenFrame.item, 2), "   ", "# #", "AAA", Character.valueOf('A'), plankItem, Character.valueOf('#'), plankItem);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.woodenCab.item, 2), "###", "X X", "XXX", Character.valueOf('X'), plankItem, Character.valueOf('#'), plankItem);
            for (ItemStack ironingot : iron) {
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.seats.item, 1), "#  ", "## ", "XXX", Character.valueOf('#'), plankItem, Character.valueOf('X'), ironingot);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironBogie.item, 4), " # ", "#X#", " # ", Character.valueOf('#'), ironingot, Character.valueOf('X'), plankItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironFrame.item, 2), "# #", "AAA", Character.valueOf('A'), ironingot, Character.valueOf('#'), plankItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironFrame.item, 2), "   ", "# #", "AAA", Character.valueOf('A'), ironingot, Character.valueOf('#'), plankItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.ironCab.item, 2), "###", "X X", "XXX", Character.valueOf('X'), ironingot, Character.valueOf('#'), plankItem);
                TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.stopper.block, 1), "WWW", "I I", "RRR", Character.valueOf('W'), plankItem, Character.valueOf('R'), Blocks.field_150448_aq, Character.valueOf('I'), ironingot);
                TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.switchStand.block, 1), " W ", " I ", " R ", Character.valueOf('W'), Blocks.field_150442_at, Character.valueOf('R'), Items.field_151055_y, Character.valueOf('I'), ironingot);
                TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.MFPBWigWag.block, 1), "IWI", " I ", " I ", Character.valueOf('W'), Blocks.field_150442_at, Character.valueOf('I'), ironingot);
            }
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSlopeWood.item, 1), " MW", "MWW", "WWW", Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('W'), plankItem);
        }
        for (ItemStack ironingot : iron) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.windMill.block, 1), " R ", " G ", "B B", Character.valueOf('G'), ItemIDs.generator.item, Character.valueOf('B'), ironingot, Character.valueOf('R'), ItemIDs.propeller.item);
            if (!Loader.isModLoaded((String)"ComputerCraft")) continue;
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.mtcTransmitterSpeed.block, 1), "SRS", "RTR", "SRS", Character.valueOf('S'), ironingot, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), Blocks.field_150456_au);
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.mtcReceiverMTC.block, 1), "STS", " R ", "SPS", Character.valueOf('S'), ironingot, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('P'), Items.field_151107_aW, Character.valueOf('T'), new ItemStack(Blocks.field_150478_aa, 1));
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.mtcTransmitterMTC.block, 1), "SPS", " R ", "STS", Character.valueOf('S'), ironingot, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('P'), Items.field_151107_aW, Character.valueOf('T'), new ItemStack(Blocks.field_150478_aa, 1));
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.mtcReceiverDestination.block, 1), "SRS", "RTR", "SRS", Character.valueOf('S'), ironingot, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), Items.field_151155_ap);
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.mtcATOStopTransmitter.block, 1), " S ", "RTS", " R ", Character.valueOf('S'), ironingot, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), ItemIDs.electronicCircuit.item);
        }
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSmallStraight.item, 1), "   ", " R ", "   ", Character.valueOf('R'), Item.func_150898_a((Block)Blocks.field_150448_aq));
        TrainCraftingManager.instance.addRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150448_aq), 1), "   ", " R ", "   ", Character.valueOf('R'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150448_aq), 1), "   ", " R ", "   ", Character.valueOf('R'), ItemIDs.tcRailSmallRoadCrossing.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150448_aq), 1), "   ", " R ", "   ", Character.valueOf('R'), ItemIDs.tcRailSmallRoadCrossing1.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150448_aq), 1), "   ", " R ", "   ", Character.valueOf('R'), ItemIDs.tcRailSmallRoadCrossing2.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSlopeGravel.item, 1), " MG", "MGG", "GGG", Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('G'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSlopeBallast.item, 1), " MB", "MBB", "BBB", Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('B'), new ItemStack(BlockIDs.oreTC.block, 1, 3));
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSlopeGravel.item, 1), "   ", " S ", " B ", Character.valueOf('S'), ItemIDs.tcRailSlopeWood.item, Character.valueOf('B'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeSlopeGravel.item, 1), "   ", " S ", " B ", Character.valueOf('S'), ItemIDs.tcRailLargeSlopeWood.item, Character.valueOf('B'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailVeryLargeSlopeGravel.item, 1), "   ", " S ", " B ", Character.valueOf('S'), ItemIDs.tcRailVeryLargeSlopeWood.item, Character.valueOf('B'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailSlopeBallast.item, 1), "   ", " S ", " B ", Character.valueOf('S'), ItemIDs.tcRailSlopeWood.item, Character.valueOf('B'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeSlopeBallast.item, 1), "   ", " S ", " B ", Character.valueOf('S'), ItemIDs.tcRailLargeSlopeWood.item, Character.valueOf('B'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailVeryLargeSlopeBallast.item, 1), "   ", " S ", " B ", Character.valueOf('S'), ItemIDs.tcRailVeryLargeSlopeWood.item, Character.valueOf('B'), Blocks.field_150351_n);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeSlopeWood.item, 1), "   ", "  S", " S ", Character.valueOf('S'), ItemIDs.tcRailSlopeWood.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeSlopeGravel.item, 1), "   ", "  S", " S ", Character.valueOf('S'), ItemIDs.tcRailSlopeGravel.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeSlopeBallast.item, 1), "   ", "  S", " S ", Character.valueOf('S'), ItemIDs.tcRailSlopeBallast.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailVeryLargeSlopeWood.item, 1), "  S", " S ", "S  ", Character.valueOf('S'), ItemIDs.tcRailSlopeWood.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailVeryLargeSlopeGravel.item, 1), "  S", " S ", "S  ", Character.valueOf('S'), ItemIDs.tcRailSlopeGravel.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailVeryLargeSlopeBallast.item, 1), "  S", " S ", "S  ", Character.valueOf('S'), ItemIDs.tcRailSlopeBallast.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailMediumStraight.item, 1), "S  ", "S  ", "S  ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailMediumStraight.item, 1), " S ", " S ", " S ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailMediumStraight.item, 1), "  S", "  S", "  S", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLongStraight.item, 1), "   ", " M ", " M ", Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLongStraight.item, 1), "   ", "M  ", "M  ", Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLongStraight.item, 1), "   ", "  M", "  M", Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailMediumTurn.item, 1), "SS ", "S  ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeTurn.item, 1), " SS", "SS ", "S  ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailVeryLargeTurn.item, 1), "MM ", "M  ", "   ", Character.valueOf('M'), ItemIDs.tcRailMediumTurn.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailMediumSwitch.item, 1), "S  ", "SRS", "S  ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item, Character.valueOf('R'), ItemIDs.tcRailMediumTurn.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailLargeSwitch.item, 1), "S  ", "MRS", "S  ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item, Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('R'), ItemIDs.tcRailLargeTurn.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailMediumParallelSwitch.item, 1), "M S", "MRR", "MR ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item, Character.valueOf('M'), ItemIDs.tcRailMediumStraight.item, Character.valueOf('R'), ItemIDs.tcRailMediumTurn.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.tcRailTwoWaysCrossing.item, 1), " S ", "SSS", " S ", Character.valueOf('S'), ItemIDs.tcRailSmallStraight.item);
        TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.bridgePillar.block, 8), "SSS", "SLS", "SSS", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('L'), Blocks.field_150364_r);
    }

    public static void initSmeltingRecipes() {
        if (!ConfigHandler.MAKE_MODPACKS_GREAT_AGAIN) {
            ArrayList steel = OreDictionary.getOres((String)"ingotSteel");
            ArrayList iron = OreDictionary.getOres((String)"ingotIron");
            for (ItemStack s : steel) {
                for (ItemStack ironitm : iron) {
                    TrainCraftingManager.instance.addHearthFurnaceRecipe(ironitm, new ItemStack(ItemIDs.graphite.item), s, 2.0f, 1000);
                }
            }
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(Item.func_150898_a((Block)BlockIDs.oreTC.block), 0), (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.7f);
    }

    public static void addDictRecipe(ItemStack stack, Object ... obj) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(stack, obj);
        GameRegistry.addRecipe((IRecipe)recipe);
    }
}

