/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import train.common.Traincraft;
import train.common.core.handlers.ConfigHandler;

public class RetrogenHandler {
    public static final byte VERSION = 1;
    private static ArrayList<Chunk> chunksToRetroGen = new ArrayList();
    public static ArrayList<ChunkData> gennedChunks = new ArrayList();
    private static Random rand = new Random();

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        ChunkData data = new ChunkData(event.getChunk());
        if (ConfigHandler.RETROGEN_CHUNKS && event.getData().func_74771_c("TraincraftRetrogen") < 1 && !gennedChunks.contains(data)) {
            chunksToRetroGen.add(event.getChunk());
        }
        gennedChunks.remove(data);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        if (event.getData() != null && !event.getData().func_74764_b("TraincraftRetrogen")) {
            event.getData().func_74774_a("TraincraftRetrogen", (byte)1);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (ConfigHandler.RETROGEN_CHUNKS && chunksToRetroGen.size() > 0 && event.phase == TickEvent.Phase.END) {
            for (Chunk chunk : chunksToRetroGen) {
                if (!(chunk.field_76637_e instanceof WorldServer)) continue;
                WorldServer world = (WorldServer)chunk.field_76637_e;
                rand.setSeed((long)chunk.field_76635_g * 341873128712L + (long)chunk.field_76647_h * 132897987541L);
                Traincraft.tcLog.info("Retrogen chunk at " + chunk.field_76635_g + ", " + chunk.field_76647_h + " for dimension " + world.field_73011_w.field_76574_g + ", Version " + 1);
                Traincraft.worldGen.generate(rand, chunk.field_76635_g, chunk.field_76647_h, (World)world, world.field_73059_b.field_73246_d, world.field_73059_b.field_73246_d);
            }
            chunksToRetroGen = new ArrayList();
            gennedChunks = new ArrayList();
        }
    }

    public static class ChunkData {
        private final int chunkX;
        private final int chunkZ;
        private final int dimension;

        private ChunkData(Chunk chunk) {
            this.chunkX = chunk.field_76635_g;
            this.chunkZ = chunk.field_76647_h;
            this.dimension = chunk.field_76637_e.field_73011_w.field_76574_g;
        }

        public ChunkData(int chunkX, int chunkZ, int dimension) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.dimension = dimension;
        }

        public boolean equals(Object o) {
            if (o instanceof ChunkData) {
                ChunkData data = (ChunkData)o;
                return data == this || data.chunkX == this.chunkX && data.chunkZ == this.chunkZ && data.dimension == this.dimension;
            }
            return false;
        }
    }
}

