/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.world.ChunkEvent;
import train.common.api.AbstractTrains;
import train.common.api.Locomotive;
import train.common.entity.ai.EntityAIFearHorn;
import train.common.entity.rollingStock.EntityJukeBoxCart;

public class WorldEvents {
    private int windTicker = 0;
    private static Random rand = new Random();
    public static int windStrength = 10 + rand.nextInt(10);

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent handler) {
        if (handler.world.field_72995_K) {
            if (this.windTicker % 128 == 0) {
                WorldEvents.updateWind();
                this.windTicker = 0;
            }
            ++this.windTicker;
        }
    }

    private static void updateWind() {
        int upChance = 10;
        int downChance = 10;
        if (windStrength > 20) {
            upChance -= windStrength - 20;
        } else if (windStrength < 10) {
            downChance -= 10 - windStrength;
        }
        if (rand.nextInt(100) <= upChance) {
            ++windStrength;
        }
        if (rand.nextInt(100) <= downChance) {
            --windStrength;
        }
    }

    @SubscribeEvent
    public void entitySpawn(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityAnimal) {
            ((EntityAnimal)event.entity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFearHorn((EntityAnimal)event.entity));
        }
    }

    @SubscribeEvent
    public void playerQuitEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70154_o instanceof AbstractTrains) {
            if (event.player.field_70154_o instanceof Locomotive) {
                ((Locomotive)event.player.field_70154_o).isBraking = true;
                ((Locomotive)event.player.field_70154_o).parkingBrake = true;
            }
            event.player.func_110145_l(event.player.field_70154_o);
            event.player.field_70154_o = null;
        }
    }

    @SubscribeEvent
    public void chunkUnloadEvent(ChunkEvent.Unload event) {
        for (List o : event.getChunk().field_76645_j) {
            if (!(o instanceof EntityJukeBoxCart) || !((EntityJukeBoxCart)((Object)o)).isPlaying) continue;
            ((EntityJukeBoxCart)((Object)o)).player.stop();
            ((EntityJukeBoxCart)((Object)o)).player.setVolume(0.0f);
        }
    }

    @SubscribeEvent
    public void EntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.entity instanceof AbstractTrains) {
            event.setCanceled(true);
        }
    }
}

