/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.managers;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import train.common.api.crafting.ITierRecipe;

public class TierRecipe
implements ITierRecipe {
    private final int tier;
    private final ItemStack output;
    private final int outputSize;
    private final ItemStack[] stacks;

    public TierRecipe(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        this.tier = tier;
        this.output = output;
        this.outputSize = outputSize;
        this.stacks = new ItemStack[]{planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye};
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public List<ItemStack> getInput() {
        return Arrays.asList(this.stacks);
    }

    public ItemStack hasComponents(ItemStack ... items) {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (!TierRecipe.areItemsIdentical(items[i], this.stacks[i])) {
                return null;
            }
            if (TierRecipe.areSizesIdentical(items[i], this.stacks[i])) continue;
            return null;
        }
        return this.output;
    }

    public static boolean areItemsIdentical(ItemStack inSlot, ItemStack inRecipe) {
        if (inRecipe == null || inSlot == null) {
            return inRecipe == inSlot;
        }
        if (Item.func_150891_b((Item)inSlot.func_77973_b()) != Item.func_150891_b((Item)inRecipe.func_77973_b())) {
            return false;
        }
        if (inRecipe.func_77960_j() == Short.MAX_VALUE) {
            return true;
        }
        return inSlot.func_77960_j() == inRecipe.func_77960_j();
    }

    public static boolean areSizesIdentical(ItemStack inSlot, ItemStack inRecipe) {
        if (inRecipe == null || inSlot == null) {
            return inRecipe == inSlot;
        }
        return inSlot.field_77994_a >= inRecipe.field_77994_a;
    }

    @Override
    public int toDecrease(int slot) {
        if (slot < this.stacks.length) {
            return this.stacks[slot].field_77994_a;
        }
        return 0;
    }
}

