/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.managers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import train.common.api.crafting.ITierCraftingManager;
import train.common.api.crafting.ITierRecipe;
import train.common.core.managers.TierRecipe;

public class TierRecipeManager
implements ITierCraftingManager {
    private final List<ITierRecipe> recipeList = new ArrayList<ITierRecipe>();
    private static TierRecipeManager instance = new TierRecipeManager();

    public static ITierCraftingManager getInstance() {
        return instance;
    }

    @Override
    public void addRecipe(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        if (tier > 0 && tier < 4 && outputSize > 0 && outputSize < 65) {
            this.addRecipeFinal(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize);
        } else {
            this.addRecipeFinal(1, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, 1);
        }
    }

    public void addRecipeFinal(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        this.recipeList.add(new TierRecipe(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize));
    }

    @Override
    public ITierRecipe getTierRecipe(int tier, ItemStack output) {
        if (output == null) {
            return null;
        }
        for (ITierRecipe recipe : this.recipeList) {
            if (Item.func_150891_b((Item)recipe.getOutput().func_77973_b()) != Item.func_150891_b((Item)output.func_77973_b()) || recipe.getTier() != tier) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<ITierRecipe> getRecipeList() {
        return new ArrayList<ITierRecipe>(this.recipeList);
    }

    @Override
    public List<ITierRecipe> getTierRecipeList(int tier) {
        ArrayList<ITierRecipe> list = new ArrayList<ITierRecipe>();
        for (ITierRecipe recipe : this.recipeList) {
            if (recipe.getTier() != tier) continue;
            list.add(recipe);
        }
        return list;
    }
}

