/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.plugins;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import train.client.gui.GuiCrafterTier;
import train.common.core.managers.TierRecipe;
import train.common.core.managers.TierRecipeManager;

public class NEIAssemblyTableRecipePlugin
extends ShapedRecipeHandler {
    private List<TierRecipe> recipeList = NEIAssemblyTableRecipePlugin.assemblyListCleaner(TierRecipeManager.getInstance().getRecipeList());

    private CachedShapedRecipe getShape(TierRecipe recipe) {
        CachedShapedRecipe shape = new CachedShapedRecipe(0, 0, null, recipe.getOutput());
        PositionedStack stack = null;
        if (recipe.getInput().get(0) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(0), 20, 16);
            stack.setMaxSize(recipe.getInput().get((int)0).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(1) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(1), 38, 82);
            stack.setMaxSize(recipe.getInput().get((int)1).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(2) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(2), 74, 82);
            stack.setMaxSize(recipe.getInput().get((int)2).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(3) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(3), 140, 82);
            stack.setMaxSize(recipe.getInput().get((int)3).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(4) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(4), 74, 16);
            stack.setMaxSize(recipe.getInput().get((int)4).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(5) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(5), 110, 16);
            stack.setMaxSize(recipe.getInput().get((int)5).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(6) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(6), 74, 50);
            stack.setMaxSize(recipe.getInput().get((int)6).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(7) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(7), 110, 50);
            stack.setMaxSize(recipe.getInput().get((int)7).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(8) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(8), 20, 50);
            stack.setMaxSize(recipe.getInput().get((int)8).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (recipe.getInput().get(9) != null) {
            stack = new PositionedStack((Object)recipe.getInput().get(9), 140, 16);
            stack.setMaxSize(recipe.getInput().get((int)9).field_77994_a);
            shape.ingredients.add(stack);
            stack = null;
        }
        shape.result.relx = 87;
        shape.result.rely = 118;
        return shape;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (TierRecipe recipe : this.recipeList) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(this.getShape(recipe));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafterTier.class;
    }

    public String getRecipeName() {
        return "Assembly Table";
    }

    public String getGuiTexture() {
        return "tc:textures/gui/gui_tierI_ironAge.png";
    }

    public String getGuiTexture(int tier) {
        if (tier == 1) {
            return "tc:textures/gui/gui_tierI_ironAge.png";
        }
        if (tier == 2) {
            return "tc:textures/gui/gui_tierII_steelAge.png";
        }
        if (tier == 3) {
            return "tc:textures/gui/gui_tierIII_advancedAge.png";
        }
        return "tc:textures/gui/gui_tierI_ironAge.png";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TierRecipe tierRecipe = null;
        if (recipe < this.recipeList.size() && (tierRecipe = this.recipeList.get(recipe)) != null) {
            GuiDraw.changeTexture((String)this.getGuiTexture(tierRecipe.getTier()));
        }
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)172, (int)133);
        if (tierRecipe != null) {
            GuiDraw.drawString((String)("Tier: " + tierRecipe.getTier()), (int)0, (int)-11, (int)0x404040, (boolean)false);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(91, 100, 72, 10), "assembly tables", new Object[0]));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (TierRecipe recipe : this.recipeList) {
            for (int i = 0; i < 10; ++i) {
                ItemStack source = recipe.getInput().get(i);
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)source, (ItemStack)ingredient)) continue;
                this.arecipes.add(this.getShape(recipe));
                continue block0;
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("assembly tables") && ((Object)((Object)this)).getClass() == NEIAssemblyTableRecipePlugin.class) {
            for (TierRecipe recipe : this.recipeList) {
                this.arecipes.add(this.getShape(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public static List assemblyListCleaner(List recipeList) {
        HashSet<Integer> outputList = new HashSet<Integer>();
        ArrayList cleanedList = new ArrayList();
        for (int i = 0; i < recipeList.size(); ++i) {
            int id = Item.func_150891_b((Item)((TierRecipe)recipeList.get(i)).getOutput().func_77973_b());
            if (outputList != null) {
                if (!outputList.contains(id)) {
                    cleanedList.add(recipeList.get(i));
                }
            } else {
                cleanedList.add(recipeList.get(i));
            }
            outputList.add(id);
        }
        return cleanedList;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;
        private int cycleTicks;

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)NEIAssemblyTableRecipePlugin.this);
            this.cycleTicks = 0;
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIAssemblyTableRecipePlugin.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            ++this.cycleTicks;
            for (int itemIndex = 0; itemIndex < ingredients.size(); ++itemIndex) {
                String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)ingredients.get((int)itemIndex).item));
                if (oreName.equals("ingotSteel") || oreName.equals("ingotIron") || oreName.equals("ingotCopper") || oreName.equals("dustPlastic") || oreName.equals("dustCoal")) {
                    ArrayList list = OreDictionary.getOres((String)OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)ingredients.get((int)itemIndex).item)));
                    Random rand = new Random((long)cycle + System.currentTimeMillis());
                    if (this.cycleTicks % 15 != 0) continue;
                    int stackSize = ingredients.get((int)itemIndex).item.field_77994_a;
                    ingredients.get((int)itemIndex).item = (ItemStack)list.get(Math.abs(rand.nextInt()) % list.size());
                    ingredients.get((int)itemIndex).item.field_77994_a = stackSize;
                    continue;
                }
                this.randomRenderPermutation(ingredients.get(itemIndex), cycle + itemIndex);
            }
            return ingredients;
        }
    }
}

