/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.plugins;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import train.client.gui.GuiOpenHearthFurnace;
import train.common.inventory.TrainCraftingManager;
import train.common.recipes.OpenHearthFurnaceRecipe;

public class NEIOpenHearthFurnaceRecipePlugin
extends ShapedRecipeHandler {
    public static ArrayList<FuelPair> afuels;

    CachedShapedRecipe getShape(ItemStack ingredient1, ItemStack ingredient2, ItemStack result) {
        PositionedStack stack;
        CachedShapedRecipe shape = new CachedShapedRecipe(0, 0, null, result);
        if (ingredient1 != null) {
            stack = new PositionedStack((Object)ingredient1, 30, 6);
            stack.setMaxSize(1);
            shape.ingredients.add(stack);
            stack = null;
        }
        if (ingredient2 != null) {
            stack = new PositionedStack((Object)ingredient2, 51, 6);
            stack.setMaxSize(1);
            shape.ingredients.add(stack);
        }
        shape.result.relx = 111;
        shape.result.rely = 24;
        return shape;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiOpenHearthFurnace.class;
    }

    public String getRecipeName() {
        return "Open Hearth Furnace";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "open hearth furnace", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("open hearth furnace") && ((Object)((Object)this)).getClass() == NEIOpenHearthFurnaceRecipePlugin.class) {
            for (OpenHearthFurnaceRecipe recipe : TrainCraftingManager.instance.getHearthFurnaceRecipeList()) {
                ItemStack[] items = recipe.getRecipe();
                ItemStack output = recipe.getCraftingResult();
                this.arecipes.add(this.getShape(items[0], items[1], output));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (OpenHearthFurnaceRecipe recipe : TrainCraftingManager.instance.getHearthFurnaceRecipeList()) {
            ItemStack item = recipe.getCraftingResult();
            if (!NEIServerUtils.areStacksSameType((ItemStack)item, (ItemStack)result)) continue;
            ItemStack[] items = recipe.getRecipe();
            this.arecipes.add(this.getShape(items[0], items[1], result));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == NEIOpenHearthFurnaceRecipePlugin.class) {
            this.loadCraftingRecipes("open hearth furnace", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (OpenHearthFurnaceRecipe recipe : TrainCraftingManager.instance.getHearthFurnaceRecipeList()) {
            ItemStack item = recipe.getCraftingResult();
            ItemStack[] items = recipe.getRecipe();
            if (ingredient.func_77973_b() != items[0].func_77973_b() && ingredient.func_77973_b() != items[1].func_77973_b()) continue;
            this.arecipes.add(this.getShape(items[0], items[1], item));
        }
    }

    public String getGuiTexture() {
        return "tc:textures/gui/gui_open_hearth_furnace.png";
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            NEIOpenHearthFurnaceRecipePlugin.findFuels();
        }
        return super.newInstance();
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(31, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (ItemStack item : ItemList.items) {
            int burnTime = TileEntityFurnace.func_145952_a((ItemStack)item);
            if (burnTime <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 42, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)NEIOpenHearthFurnaceRecipePlugin.this);
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIOpenHearthFurnaceRecipePlugin.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }

        public PositionedStack getOtherStack() {
            return NEIOpenHearthFurnaceRecipePlugin.afuels.get((int)(NEIOpenHearthFurnaceRecipePlugin.this.cycleticks / 48 % NEIOpenHearthFurnaceRecipePlugin.afuels.size())).stack;
        }
    }
}

