/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.util;

import net.minecraft.block.BlockRailBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import train.common.api.EntityRollingStock;
import train.common.api.Locomotive;

public class TraincraftUtil {
    public static final double degrees = 57.29577951308232;
    public static final double radian = Math.PI / 180;
    private static final int ATAN2_SQRT = (int)Math.sqrt(1024.0);
    private static final float[] atan2 = new float[1024];
    public static final float degreesF = 57.29578f;

    public static Item getItemFromName(String name) {
        if (Item.field_150901_e.func_148741_d(name)) {
            return (Item)Item.field_150901_e.func_82594_a(name);
        }
        return null;
    }

    public static ItemStack getItemFromUnlocalizedName(String itemName, int meta) {
        Item item = TraincraftUtil.getItemFromName(itemName);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        return null;
    }

    public static int getByteFromColor(String c) {
        if (c.equals("Black")) {
            return 0;
        }
        if (c.equals("Red")) {
            return 1;
        }
        if (c.equals("Green")) {
            return 2;
        }
        if (c.equals("Brown")) {
            return 3;
        }
        if (c.equals("Blue")) {
            return 4;
        }
        if (c.equals("Purple")) {
            return 5;
        }
        if (c.equals("Cyan")) {
            return 6;
        }
        if (c.equals("LightGrey")) {
            return 7;
        }
        if (c.equals("Grey")) {
            return 8;
        }
        if (c.equals("Magenta")) {
            return 13;
        }
        if (c.equals("Lime")) {
            return 10;
        }
        if (c.equals("Yellow")) {
            return 11;
        }
        if (c.equals("LightBlue")) {
            return 12;
        }
        if (c.equals("Pink")) {
            return 9;
        }
        if (c.equals("Orange")) {
            return 14;
        }
        if (c.equals("White")) {
            return 15;
        }
        if (c.equals("Skin16")) {
            return 16;
        }
        if (c.equals("Skin17")) {
            return 17;
        }
        if (c.equals("Skin18")) {
            return 18;
        }
        if (c.equals("Skin19")) {
            return 19;
        }
        if (c.equals("Skin20")) {
            return 20;
        }
        if (c.equals("Skin21")) {
            return 21;
        }
        if (c.equals("Skin22")) {
            return 22;
        }
        if (c.equals("Full")) {
            return 101;
        }
        if (c.equals("Empty")) {
            return 100;
        }
        return 0;
    }

    public static int[] getBytesFromColors(String[] c) {
        int[] ret = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            ret[i] = TraincraftUtil.getByteFromColor(c[i]);
        }
        return ret;
    }

    public static boolean itemStackMatches(ItemStack item1, ItemStack item2) {
        return item1.func_77973_b() == item2.func_77973_b() && (item1.func_77960_j() == item2.func_77960_j() || item1.func_77960_j() == Short.MAX_VALUE || item2.func_77960_j() == Short.MAX_VALUE);
    }

    public static boolean isRailBlockAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockRailBase;
    }

    public static void updateRider(EntityRollingStock transport, double distance, double yOffset) {
        if (transport.field_70153_n == null) {
            return;
        }
        double pitchRads = (double)transport.anglePitchClient * (Math.PI / 180);
        double rotationCos1 = Math.cos(Math.toRadians(transport.renderYaw + (float)(transport instanceof Locomotive ? 90 : 180)));
        double rotationSin1 = Math.sin(Math.toRadians(transport.renderYaw + (float)(transport instanceof Locomotive ? 90 : 180)));
        if (transport.side.isServer()) {
            rotationCos1 = Math.cos(Math.toRadians(transport.serverRealRotation + 90.0f));
            rotationSin1 = Math.sin(Math.toRadians(transport.serverRealRotation + 90.0f));
            transport.anglePitchClient = transport.serverRealPitch * 60.0f;
        }
        float pitch = (float)(transport.field_70163_u + (Math.tan(pitchRads) * distance + transport.func_70042_X()) + transport.field_70153_n.func_70033_W() + yOffset);
        double bogieX1 = transport.field_70165_t + rotationCos1 * distance;
        double bogieZ1 = transport.field_70161_v + rotationSin1 * distance;
        if (transport.anglePitchClient > 20.0f && rotationCos1 == 1.0) {
            bogieX1 -= pitchRads * 2.0;
            pitch = (float)((double)pitch - pitchRads * 1.2);
        }
        if (transport.anglePitchClient > 20.0f && rotationSin1 == 1.0) {
            bogieZ1 -= pitchRads * 2.0;
            pitch = (float)((double)pitch - pitchRads * 1.2);
        }
        if (pitchRads == 0.0) {
            transport.field_70153_n.func_70107_b(bogieX1, transport.field_70163_u + transport.func_70042_X() + transport.field_70153_n.func_70033_W() + yOffset, bogieZ1);
        }
        if (pitchRads > -1.01 && pitchRads < 1.01) {
            transport.field_70153_n.func_70107_b(bogieX1, (double)pitch, bogieZ1);
        }
    }

    public static float atan2f(double x, double z) {
        float pi = (float)(-Math.PI);
        float multiplier = 1.0f;
        if (z < 0.0) {
            if (x < 0.0) {
                z = -z;
                x = -x;
            } else {
                z = -z;
                multiplier = -1.0f;
            }
        } else {
            if (x < 0.0) {
                x = -x;
                multiplier = -1.0f;
            }
            pi = 0.0f;
        }
        double invDiv = 1.0 / ((z < x ? x : z) * (1.0 / (double)(ATAN2_SQRT - 1)));
        return (atan2[(int)(x * invDiv) * ATAN2_SQRT + (int)(z * invDiv)] + pi) * multiplier;
    }

    public static float atan2degreesf(double x, double y) {
        return TraincraftUtil.atan2f(x, y) * 57.29578f;
    }

    static {
        for (int i = 0; i < ATAN2_SQRT; ++i) {
            for (int j = 0; j < ATAN2_SQRT; ++j) {
                TraincraftUtil.atan2[j * TraincraftUtil.ATAN2_SQRT + i] = (float)Math.atan2((float)j / (float)ATAN2_SQRT, (float)i / (float)ATAN2_SQRT);
            }
        }
    }
}

