/*
 * Decompiled with CFR 0.152.
 */
package train.common.entity.rollingStock;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.Traincraft;
import train.common.api.LiquidManager;
import train.common.api.SteamTrain;
import train.common.core.FakePlayer;
import train.common.core.util.TraincraftUtil;
import train.common.library.EnumTrains;

public class EntityLocoSteamSnowPlow
extends SteamTrain {
    private static final double[][] blockpos = new double[][]{{4.0, 0.0, 1.0}, {4.0, 0.0, -1.0}, {4.0, 0.0, 0.0}};
    private double[] point1;
    private FakePlayer fakePlayer = null;
    private int rotation = 0;
    private static final float radianF = (float)Math.PI / 180;

    public EntityLocoSteamSnowPlow(World world) {
        super(world, EnumTrains.locoSteamSnowPlow.getTankCapacity(), LiquidManager.WATER_FILTER);
        this.initLocoSteam();
    }

    public void initLocoSteam() {
        this.fuelTrain = 0;
        this.locoInvent = new ItemStack[this.inventorySize];
    }

    public EntityLocoSteamSnowPlow(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        double pitchRads = (double)this.anglePitchClient * Math.PI / 180.0;
        double distance = 0.7;
        double yOffset = 0.3;
        float rotationCos1 = (float)Math.cos(Math.toRadians(this.renderYaw + 90.0f));
        float rotationSin1 = (float)Math.sin(Math.toRadians(this.renderYaw + 90.0f));
        if (this.side.isServer()) {
            rotationCos1 = (float)Math.cos(Math.toRadians(this.serverRealRotation + 90.0f));
            rotationSin1 = (float)Math.sin(Math.toRadians(this.serverRealRotation + 90.0f));
            this.anglePitchClient = this.serverRealPitch * 60.0f;
        }
        float pitch = (float)(this.field_70163_u + (Math.tan(pitchRads) * distance + this.func_70042_X()) + this.field_70153_n.func_70033_W() + yOffset);
        float pitch1 = (float)(this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + yOffset);
        double bogieX1 = this.field_70165_t + (double)rotationCos1 * distance;
        double bogieZ1 = this.field_70161_v + (double)rotationSin1 * distance;
        if (this.anglePitchClient > 20.0f && rotationCos1 == 1.0f) {
            bogieX1 -= pitchRads * 2.0;
            pitch = (float)((double)pitch - pitchRads * 1.2);
        }
        if (this.anglePitchClient > 20.0f && rotationSin1 == 1.0f) {
            bogieZ1 -= pitchRads * 2.0;
            pitch = (float)((double)pitch - pitchRads * 1.2);
        }
        if (pitchRads == 0.0) {
            this.field_70153_n.func_70107_b(bogieX1, (double)pitch1, bogieZ1);
        }
        if (pitchRads > -1.01 && pitchRads < 1.01) {
            this.field_70153_n.func_70107_b(bogieX1, (double)pitch, bogieZ1);
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.field_70128_L = true;
    }

    @Override
    public void pressKey(int i) {
        if (i == 7 && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            ((EntityPlayer)this.field_70153_n).openGui((Object)Traincraft.instance, 79, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K || this.bogieLoco == null) {
            return;
        }
        this.checkInvent(this.locoInvent[0], this.locoInvent[1], this);
        if (this.fakePlayer == null) {
            this.fakePlayer = new FakePlayer(this.field_70170_p);
        }
        this.rotation = MathHelper.func_76141_d((float)TraincraftUtil.atan2degreesf(this.bogieLoco.field_70161_v - this.field_70161_v, this.bogieLoco.field_70165_t - this.field_70165_t));
        this.point1 = EntityLocoSteamSnowPlow.rotateVec3(blockpos[0], this.getPitch(), this.rotation);
        this.point1[0] = this.point1[0] + this.field_70165_t;
        this.point1[1] = this.point1[1] + this.field_70163_u;
        this.point1[2] = this.point1[2] + this.field_70161_v;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1[1] = this.point1[1] + 1.0;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1[1] = this.point1[1] + 1.0;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1 = EntityLocoSteamSnowPlow.rotateVec3(blockpos[1], this.getPitch(), this.rotation);
        this.point1[0] = this.point1[0] + this.field_70165_t;
        this.point1[1] = this.point1[1] + this.field_70163_u;
        this.point1[2] = this.point1[2] + this.field_70161_v;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1[1] = this.point1[1] + 1.0;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1[1] = this.point1[1] + 1.0;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1 = EntityLocoSteamSnowPlow.rotateVec3(blockpos[2], this.getPitch(), this.rotation);
        this.point1[0] = this.point1[0] + this.field_70165_t;
        this.point1[1] = this.point1[1] + (this.field_70163_u + 1.0);
        this.point1[2] = this.point1[2] + this.field_70161_v;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
        this.point1[1] = this.point1[1] + 1.0;
        EntityLocoSteamSnowPlow.mineSnow(this.field_70170_p, this.point1, this.locoInvent, this.fakePlayer);
    }

    private static void mineSnow(World worldObj, double[] point, ItemStack[] locoInvent, FakePlayer fakePlayer) {
        Block b = worldObj.func_147439_a(MathHelper.func_76128_c((double)point[0]), MathHelper.func_76128_c((double)point[1]), MathHelper.func_76128_c((double)point[2]));
        int blockMeta = worldObj.func_72805_g(MathHelper.func_76128_c((double)point[0]), MathHelper.func_76128_c((double)point[1]), MathHelper.func_76128_c((double)point[2]));
        if ((b == Blocks.field_150433_aE || b == Blocks.field_150431_aC) && b.canHarvestBlock((EntityPlayer)fakePlayer, blockMeta)) {
            worldObj.func_147468_f(MathHelper.func_76128_c((double)point[0]), MathHelper.func_76128_c((double)point[1]), MathHelper.func_76128_c((double)point[2]));
            int snowballs = new Random().nextInt(9);
            for (int i = 2; i < locoInvent.length && snowballs > 0; ++i) {
                if (locoInvent[i] == null) {
                    locoInvent[i] = new ItemStack(Items.field_151126_ay, snowballs);
                    --snowballs;
                } else if (locoInvent[i].func_77973_b() == Items.field_151126_ay && locoInvent[i].field_77994_a < Items.field_151126_ay.func_77639_j()) {
                    while (locoInvent[i].field_77994_a < locoInvent[i].func_77976_d() && snowballs > 0) {
                        ++locoInvent[i].field_77994_a;
                        --snowballs;
                    }
                }
                if (snowballs == 0) break;
            }
            if (snowballs > 0) {
                EntityItem entityitem = new EntityItem(worldObj, point[0], point[1] + 1.0, point[2], new ItemStack(Items.field_151126_ay, snowballs));
                entityitem.field_145804_b = 10;
                worldObj.func_72838_d((Entity)entityitem);
            }
        }
    }

    private static double[] rotateVec3(double[] offset, float pitch, float yaw) {
        double[] xyz = new double[]{offset[0], offset[1], offset[2]};
        if (pitch != 0.0f) {
            xyz[0] = offset[0] * Math.cos(pitch *= (float)Math.PI / 180);
            xyz[1] = offset[0] * Math.sin(pitch);
        }
        if (yaw != 0.0f) {
            double cos = MathHelper.func_76134_b((float)(yaw *= (float)Math.PI / 180));
            double sin = MathHelper.func_76126_a((float)yaw);
            xyz[0] = offset[0] * cos - offset[2] * sin;
            xyz[2] = offset[0] * sin + offset[2] * cos;
        }
        return xyz;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("fuelTrain", (short)this.fuelTrain);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.locoInvent.length; ++i) {
            if (this.locoInvent[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.locoInvent[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.fuelTrain = nbttagcompound.func_74765_d("fuelTrain");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.locoInvent = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.locoInvent.length) continue;
            this.locoInvent[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int func_70302_i_() {
        return this.inventorySize;
    }

    public String func_145825_b() {
        return "Steam Snow Plow";
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        this.playerEntity = entityplayer;
        if (super.func_130002_c(entityplayer)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != entityplayer) {
                return true;
            }
            entityplayer.func_70078_a((Entity)this);
        }
        return true;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 0.7f;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return this.canBeAdjusted;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

