/*
 * Decompiled with CFR 0.152.
 */
package train.common.entity.rollingStock;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import train.common.Traincraft;
import train.common.adminbook.ServerLogger;
import train.common.api.EntityRollingStock;
import train.common.api.Freight;
import train.common.blocks.BlockTCRail;
import train.common.blocks.BlockTCRailGag;
import train.common.core.handlers.FuelHandler;
import train.common.core.plugins.PluginRailcraft;
import train.common.core.util.TraincraftUtil;
import train.common.items.ItemTCRail;

public class EntityTracksBuilder
extends EntityRollingStock
implements IInventory {
    public ItemStack item;
    private ItemStack[] BuilderInvent;
    public int numBuilderSlots;
    public int numBuilderSlots1;
    public int numBuilderSlots2;
    public int numBuilderSlots3;
    public int inventoryBuilderSize;
    public double pushX;
    public double pushZ;
    public int MoreBuilderInvent;
    public int trackfuel;
    public double currentHeight;
    public int plannedHeight;
    EntityPlayer playerEntity;
    public boolean followTracks;
    private int maxFuel = 5000;
    private int miningTickCounter = 0;
    private int lastFace = -1;
    private boolean skipTick = true;
    private FakePlayer fakeplayer;
    private static final int slotId_Rail = 1;
    private static final int slotId_UnderBlock2 = 2;
    private static final int slotId_UnderBlock = 3;
    private static final int slotId_UpperBlockRight = 4;
    private static final int slotId_UpperBlockCenter = 5;
    private static final int slotId_UpperBlockLeft = 6;
    private static final int slotId_WallBlock = 7;

    public EntityTracksBuilder(World world) {
        super(world);
        this.initBuilder();
        if (world instanceof WorldServer) {
            this.fakeplayer = new FakePlayer((WorldServer)world, this.getOwner() != null ? this.getOwner() : new GameProfile(UUID.nameUUIDFromBytes(this.trainOwner == null || this.trainOwner.length() < 1 ? "[Traincraft]".getBytes() : this.trainOwner.getBytes()), this.trainOwner == null || this.trainOwner.length() < 1 ? "[Traincraft]" : this.trainOwner));
        }
    }

    public void initBuilder() {
        this.numBuilderSlots = 8;
        this.numBuilderSlots1 = 8;
        this.numBuilderSlots2 = 8;
        this.numBuilderSlots3 = 8;
        this.MoreBuilderInvent = 20;
        this.inventoryBuilderSize = this.numBuilderSlots + this.numBuilderSlots2 + this.numBuilderSlots1 + this.numBuilderSlots3 + this.MoreBuilderInvent;
        this.BuilderInvent = new ItemStack[this.inventoryBuilderSize];
        this.trackfuel = 0;
        this.followTracks = true;
        this.field_70180_af.func_75682_a(24, (Object)this.fuelTrain);
        this.field_70180_af.func_75682_a(26, (Object)this.plannedHeight);
        this.field_70180_af.func_75682_a(27, (Object)1);
        this.field_70180_af.func_75682_a(28, (Object)0);
    }

    public EntityTracksBuilder(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.currentHeight = this.field_70163_u;
        this.plannedHeight = (int)this.currentHeight - 1;
        this.setPlannedHeight(this.plannedHeight);
        if (world instanceof WorldServer) {
            this.fakeplayer = new FakePlayer((WorldServer)world, this.getOwner() != null ? this.getOwner() : new GameProfile(UUID.nameUUIDFromBytes(this.trainOwner == null || this.trainOwner.length() < 1 ? "[Traincraft]".getBytes() : this.trainOwner.getBytes()), this.trainOwner == null || this.trainOwner.length() < 1 ? "[Traincraft]" : this.trainOwner));
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.field_70128_L = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.Smoke();
        }
        this.currentHeight = this.field_70163_u;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.updateFuel();
        this.moveStacks();
        this.updatePushForces();
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.skipTick) {
            this.skipTick = false;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.canDigg()) {
            this.updateState(true);
            this.applyDragAndPushForces();
            this.digBuilder(i, j, k);
        } else {
            this.updateState(false);
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.field_70173_aa % 4 == 0) {
            this.fillLinkedInventory();
        }
    }

    private void fillLinkedInventory() {
        if (this.getInventory() != null) {
            Freight link;
            if (this.cartLinked1 instanceof Freight && this.cartLinked1.getInventory() != null) {
                link = (Freight)this.cartLinked1;
            } else if (this.cartLinked2 instanceof Freight && this.cartLinked2.getInventory() != null) {
                link = (Freight)this.cartLinked2;
            } else {
                return;
            }
            block0: for (int index = 1; index < 11; ++index) {
                if (this.getInventory()[index] == null || this.getInventory()[index].func_77973_b() == null || this.getInventory()[index].field_77994_a >= this.getInventory()[index].func_77976_d()) continue;
                for (int f = 0; f < link.getInventory().length; ++f) {
                    if (link.getInventory()[f] == null || link.getInventory()[f].func_77973_b() != this.getInventory()[index].func_77973_b()) continue;
                    link.func_70298_a(f, 1);
                    ++this.getInventory()[index].field_77994_a;
                    continue block0;
                }
            }
        }
    }

    private void updateFuel() {
        if (this.getFuel() < this.maxFuel && this.BuilderInvent[0] != null) {
            if (FuelHandler.steamFuelLast(this.BuilderInvent[0]) > 0 && this.getFuel() + 300 < this.maxFuel) {
                this.fuelTrain += 300;
                this.func_70298_a(0, 1);
            }
            if (this.BuilderInvent[0] != null && PluginRailcraft.RailcraftParts.INGOT_STEEL.stack != null && this.BuilderInvent[0].func_77969_a(PluginRailcraft.RailcraftParts.INGOT_STEEL.stack) && this.getFuel() + 800 < this.maxFuel) {
                this.fuelTrain += 800;
                this.func_70298_a(0, 1);
            }
            this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
        }
    }

    @Override
    public ItemStack[] getInventory() {
        return this.BuilderInvent;
    }

    private boolean canDigg() {
        return this.checkForBallast() && this.checkForTracks() && this.getFuel() > 0;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("plannedHeight", this.plannedHeight);
        nbttagcompound.func_74757_a("followTracks", this.followTracks);
        nbttagcompound.func_74780_a("PushX", this.pushX);
        nbttagcompound.func_74780_a("PushZ", this.pushZ);
        nbttagcompound.func_74777_a("Trackfuel", (short)this.trackfuel);
        nbttagcompound.func_74777_a("fuel", (short)this.getFuel());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.BuilderInvent.length; ++i) {
            if (this.BuilderInvent[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.BuilderInvent[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.pushX = nbttagcompound.func_74769_h("PushX");
        this.pushZ = nbttagcompound.func_74769_h("PushZ");
        if (nbttagcompound.func_74762_e("plannedHeight") < 4) {
            this.plannedHeight = (int)this.currentHeight;
            this.setPlannedHeight(this.plannedHeight);
        } else {
            this.setPlannedHeight(nbttagcompound.func_74762_e("plannedHeight"));
        }
        this.followTracks = nbttagcompound.func_74767_n("followTracks");
        this.trackfuel = nbttagcompound.func_74765_d("Trackfuel");
        this.fuelTrain = nbttagcompound.func_74765_d("fuel");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.BuilderInvent = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.BuilderInvent.length) continue;
            this.BuilderInvent[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int func_70302_i_() {
        return this.inventoryBuilderSize;
    }

    public ItemStack func_70301_a(int i) {
        return this.BuilderInvent[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.BuilderInvent[par1] != null) {
            ItemStack var2 = this.BuilderInvent[par1];
            this.BuilderInvent[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.BuilderInvent[i] != null) {
            if (this.BuilderInvent[i].field_77994_a <= j) {
                ItemStack itemstack = this.BuilderInvent[i];
                this.BuilderInvent[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.BuilderInvent[i].func_77979_a(j);
            if (this.BuilderInvent[i].field_77994_a == 0) {
                this.BuilderInvent[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.BuilderInvent[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Tracks Builder";
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        this.playerEntity = entityplayer;
        if (super.func_130002_c(entityplayer)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        entityplayer.openGui((Object)Traincraft.instance, 82, this.field_70170_p, this.func_145782_y(), -1, (int)this.field_70161_v);
        this.pushZ = this.field_70161_v - entityplayer.field_70161_v;
        this.pushX = this.field_70165_t - entityplayer.field_70165_t;
        this.applyDragAndPushForces();
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int scaleMaxFuel(int i) {
        return this.getFuel() * i / this.maxFuel;
    }

    @Override
    protected void applyDragAndPushForces() {
        double d26 = MathHelper.func_76133_a((double)(this.pushX * this.pushX + this.pushZ * this.pushZ));
        if (d26 > 0.01) {
            this.pushX /= d26;
            this.pushZ /= d26;
            double d28 = 0.029;
            this.field_70159_w *= 0.4;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.4;
            if (this.getFuel() > 0) {
                this.field_70159_w += this.pushX * d28;
                this.field_70179_y += this.pushZ * d28;
            }
        } else {
            this.field_70159_w *= 0.6999999761581421;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.6999999761581421;
        }
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    @Override
    protected void adjustSlopeVelocities(int metadata) {
        if (metadata == 2 || metadata == 3 || metadata == 4 || metadata == 5) {
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
        }
    }

    protected void updatePushForces() {
        double push = MathHelper.func_76133_a((double)(this.pushX * this.pushX + this.pushZ * this.pushZ));
        if (push > 0.01 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            this.pushX /= push;
            this.pushZ /= push;
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.field_70159_w;
                this.pushZ = this.field_70179_y;
            }
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        float dist = 1.6f;
        return dist + 0.5f;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return false;
    }

    public void Smoke() {
        if (this.getFuel() > 0) {
            --this.fuelTrain;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
            }
        }
    }

    public int getFuel() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24);
        }
        return this.fuelTrain;
    }

    private void updateState(boolean state) {
        if (state) {
            this.field_70180_af.func_75692_b(28, (Object)1);
        }
        if (!state) {
            this.field_70180_af.func_75692_b(28, (Object)0);
        }
    }

    public boolean getState() {
        return this.field_70180_af.func_75679_c(28) == 1;
    }

    public void setPlannedHeightFromPacket(int packet) {
        int currentPlanned = this.getPlannedHeight();
        int request = packet + currentPlanned;
        if (request > 256) {
            request = 256;
        }
        if (request < 4) {
            request = 4;
        }
        this.setPlannedHeight(request);
    }

    public void setPlannedHeight(int plannedHeight) {
        this.field_70180_af.func_75692_b(26, (Object)plannedHeight);
        this.plannedHeight = plannedHeight;
    }

    public int getPlannedHeight() {
        return this.field_70180_af.func_75679_c(26);
    }

    public void setFollowTracksFromPacket(int packet) {
        this.setFollowTracks(packet);
    }

    public void setFollowTracks(int follow) {
        this.field_70180_af.func_75692_b(27, (Object)follow);
        if (follow == 1) {
            this.followTracks = true;
        }
        if (follow == 0) {
            this.followTracks = false;
        }
    }

    public int getFollowTracks() {
        return this.field_70180_af.func_75679_c(27);
    }

    public void putInInvent(ItemStack itemdug) {
        boolean hasBeenPlaced = false;
        boolean noFreight = true;
        List lis = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.600000002980233, 4.600000002980233, 4.600000002980233));
        if (lis != null && lis.size() > 0) {
            for (int j1 = 0; j1 < lis.size(); ++j1) {
                Entity entity = (Entity)lis.get(j1);
                if (entity instanceof Freight && (this.isAttached || this.isLinked()) && ((Freight)entity).cargoItems != null && ((Freight)entity).cargoItems.length > 0) {
                    noFreight = false;
                    for (int u = 0; u < ((Freight)entity).cargoItems.length; ++u) {
                        ItemStack itemInside = ((IInventory)entity).func_70301_a(u);
                        if (itemInside != null && ((Freight)entity).cargoItems[u].field_77994_a != 0 && ((Freight)entity).cargoItems[u].func_77973_b() == itemdug.func_77973_b() && ((Freight)entity).cargoItems[u].func_77960_j() == itemdug.func_77960_j() && ((Freight)entity).cargoItems[u].field_77994_a != this.func_70297_j_()) {
                            ++((Freight)entity).cargoItems[u].field_77994_a;
                            hasBeenPlaced = true;
                            u = ((Freight)entity).cargoItems.length;
                            j1 = lis.size();
                            continue;
                        }
                        if (itemInside == null) {
                            if (((Freight)entity).cargoItems[u] != null) continue;
                            ((Freight)entity).cargoItems[u] = itemdug;
                            hasBeenPlaced = true;
                            u = ((Freight)entity).cargoItems.length;
                            j1 = lis.size();
                            continue;
                        }
                        if (hasBeenPlaced || u != ((Freight)entity).cargoItems.length) continue;
                        noFreight = true;
                    }
                    continue;
                }
                noFreight = true;
            }
        } else {
            noFreight = true;
        }
        if (noFreight) {
            for (int u = this.MoreBuilderInvent; u < this.BuilderInvent.length; ++u) {
                ItemStack itemInside = this.func_70301_a(u);
                if (itemInside != null && this.BuilderInvent[u].field_77994_a != 0 && this.BuilderInvent[u].func_77973_b() == itemdug.func_77973_b() && this.BuilderInvent[u].func_77960_j() == itemdug.func_77960_j() && this.BuilderInvent[u].field_77994_a != this.func_70297_j_()) {
                    ++this.BuilderInvent[u].field_77994_a;
                    hasBeenPlaced = true;
                    u = this.BuilderInvent.length;
                    continue;
                }
                if (itemInside == null) {
                    if (this.BuilderInvent[u] != null) continue;
                    this.BuilderInvent[u] = itemdug;
                    hasBeenPlaced = true;
                    u = this.BuilderInvent.length;
                    continue;
                }
                if (hasBeenPlaced || u != this.BuilderInvent.length - 1) continue;
                this.func_70099_a(itemdug, 1.0f);
                u = this.BuilderInvent.length;
            }
        }
    }

    public static boolean canBeBallast(ItemStack stack) {
        Block block;
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)stack.func_77973_b())) instanceof BlockFalling) {
            return true;
        }
        return EntityTracksBuilder.canBeTunnel(stack);
    }

    public static boolean canBeTunnel(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        if (stack.func_77973_b() != null) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block.hasTileEntity(stack.func_77973_b().func_77647_b(stack.func_77960_j()))) {
                return false;
            }
            if (block.func_149645_b() != 0) {
                return false;
            }
            return !(block instanceof BlockFalling);
        }
        return false;
    }

    private void moveStacks() {
        int i;
        if (this.BuilderInvent[1] == null) {
            for (i = 8; i <= 10; ++i) {
                if (this.BuilderInvent[i] == null || !RailTools.isTrackItem(this.BuilderInvent[i]) && Item.func_150891_b((Item)this.BuilderInvent[i].func_77973_b()) != Block.func_149682_b((Block)Blocks.field_150448_aq) && Item.func_150891_b((Item)this.BuilderInvent[i].func_77973_b()) != Block.func_149682_b((Block)Block.func_149684_b((String)"railPowered")) && Item.func_150891_b((Item)this.BuilderInvent[i].func_77973_b()) != Block.func_149682_b((Block)Block.func_149684_b((String)"railDetector.blockID"))) continue;
                this.BuilderInvent[1] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
        if (this.BuilderInvent[3] == null) {
            for (i = 11; i <= 13; ++i) {
                if (!EntityTracksBuilder.canBeBallast(this.BuilderInvent[i])) continue;
                this.BuilderInvent[3] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
        if (this.BuilderInvent[2] == null) {
            for (i = 14; i <= 16; ++i) {
                if (!EntityTracksBuilder.canBeBallast(this.BuilderInvent[i])) continue;
                this.BuilderInvent[2] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
        if (this.BuilderInvent[7] == null) {
            for (i = 17; i <= 19; ++i) {
                if (!EntityTracksBuilder.canBeTunnel(this.BuilderInvent[i])) continue;
                this.BuilderInvent[7] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
    }

    private void playMiningEffect(Vec3 pos, int block_index) {
        ++this.miningTickCounter;
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() && pos != null && this.field_70170_p != null) {
            Block block = this.field_70170_p.func_147439_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
            if (this.miningTickCounter % 8 == 0 && block != null && !this.field_70170_p.field_72995_K && Minecraft.func_71410_x() != null) {
                this.field_70170_p.func_72980_b((double)((float)((int)pos.field_72450_a) + 0.5f), (double)((float)((int)pos.field_72448_b) + 0.5f), (double)((float)((int)pos.field_72449_c) + 0.5f), block.field_149762_H.func_150495_a(), 1.0f, block.field_149762_H.func_150494_d() * 0.5f, true);
            }
            if (this.miningTickCounter % 8 == 0 && block_index != 0 && block != null && FMLClientHandler.instance().getClient() != null) {
                FMLClientHandler.instance().getClient().field_71452_i.func_78867_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, block_index < 4 ? this.getSideFromYaw() : (block_index < 6 ? 1 : 0));
            }
        }
    }

    private int getSideFromYaw() {
        if (this.field_70177_z == 0.0f) {
            return 5;
        }
        if (this.field_70177_z == 90.0f) {
            return 3;
        }
        if (this.field_70177_z == 180.0f) {
            return 4;
        }
        if (this.field_70177_z == 270.0f) {
            return 2;
        }
        return 1;
    }

    private boolean checkForBallast() {
        return this.BuilderInvent[3] != null && EntityTracksBuilder.canBeBallast(this.BuilderInvent[3]);
    }

    private boolean checkForTracks() {
        if (this.BuilderInvent[1] != null) {
            this.trackfuel = 1;
            return true;
        }
        this.trackfuel = 0;
        return false;
    }

    private int getFacing() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.d7 == 0.0 && this.d6 == 0.0) {
                if (this.lastFace == -1) {
                    // empty if block
                }
                return this.lastFace;
            }
            this.rotation = TraincraftUtil.atan2degreesf(this.d7, this.d6);
            this.lastFace = MathHelper.func_76128_c((double)((double)(this.rotation * 4.0f / 360.0f) + 0.5)) & 3;
        } else {
            this.rotation = TraincraftUtil.atan2degreesf(0.0 - this.field_70159_w, 0.0 - this.field_70179_y);
        }
        return MathHelper.func_76128_c((double)((double)(this.rotation * 4.0f / 360.0f) + 0.5)) & 3;
    }

    private int checkForHeight() {
        if (this.BuilderInvent[1] != null && this.BuilderInvent[1].func_77973_b() instanceof ItemTCRail) {
            return 0;
        }
        return this.getPlannedHeight() - (int)this.currentHeight;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            ServerLogger.deleteWagon(this);
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
                for (ItemStack stack : this.BuilderInvent) {
                    if (stack == null) continue;
                    this.func_70099_a(stack, 0.0f);
                }
            }
        }
        return true;
    }

    private void digBuilder(int i, int j, int k) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int iX = 0;
        int kZ = 0;
        this.checkForTracks();
        int hY = this.checkForHeight();
        if (this.trackfuel >= 1) {
            int face = this.getFacing();
            if (face == 1) {
                iX = 0;
                kZ = -1;
            } else if (face == 2) {
                iX = 1;
                kZ = 0;
            } else if (face == 3) {
                iX = 0;
                kZ = 1;
            } else if (face == 0) {
                iX = -1;
                kZ = 0;
            } else {
                return;
            }
            boolean ret = this.digAndPlace(i, j, k, iX, hY, kZ);
            if (!ret) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
        }
    }

    private void harvestBlock(int i, int j, int k) {
        int meta;
        Block block = this.field_70170_p.func_147439_a(i, j, k);
        if (block.getDrops(this.field_70170_p, i, j, k, meta = this.field_70170_p.func_72805_g(i, j, k), 0).size() > 0) {
            ArrayList stacks = new ArrayList(block.getDrops(this.field_70170_p, i, j, k, meta, 0));
            for (ItemStack s : stacks) {
                this.putInInvent(s);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            int id = Block.func_149682_b((Block)block);
            this.playMiningEffect(Vec3.func_72443_a((double)i, (double)j, (double)k), id);
            this.field_70170_p.func_72926_e(2001, i, j, k, id + (meta << 12));
        }
    }

    private boolean replaceBlockAt(int i, int j, int k, int inventoryId) {
        Block newblock;
        int newmeta = 0;
        boolean consumeBlock = false;
        if (inventoryId > 0 && inventoryId < this.BuilderInvent.length) {
            if (this.BuilderInvent[inventoryId] == null || this.BuilderInvent[inventoryId].func_77973_b() == null || this.BuilderInvent[inventoryId].field_77994_a <= 0) {
                return true;
            }
            newblock = Block.func_149634_a((Item)this.BuilderInvent[inventoryId].func_77973_b());
            newmeta = this.BuilderInvent[inventoryId].func_77960_j();
            consumeBlock = true;
            if (newblock == null) {
                return true;
            }
        } else {
            newblock = Blocks.field_150350_a;
        }
        Block block = this.field_70170_p.func_147439_a(i, j, k);
        int metadata = this.field_70170_p.func_72805_g(i, j, k);
        if (block == newblock && metadata == newmeta) {
            return true;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(i, j, k, this.field_70170_p, block, metadata, (EntityPlayer)this.fakeplayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.harvestBlock(i, j, k);
            this.field_70170_p.func_147449_b(i, j, k, newblock);
            this.field_70170_p.func_72921_c(i, j, k, newmeta, 3);
            if (consumeBlock) {
                --this.BuilderInvent[inventoryId].field_77994_a;
                if (this.BuilderInvent[inventoryId].field_77994_a == 0) {
                    this.BuilderInvent[inventoryId] = null;
                }
            }
            return true;
        }
        return false;
    }

    private boolean placeRailAt(int i, int j, int k) {
        int inventoryId = 1;
        if (this.BuilderInvent[inventoryId] == null) {
            return false;
        }
        Block block = this.field_70170_p.func_147439_a(i, j, k);
        int metadata = this.field_70170_p.func_72805_g(i, j, k);
        if (BlockRailBase.func_150051_a((Block)block) || block instanceof BlockTCRail || block instanceof BlockTCRailGag) {
            return true;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(i, j, k, this.field_70170_p, block, metadata, (EntityPlayer)this.fakeplayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.harvestBlock(i, j, k);
            this.field_70170_p.func_147468_f(i, j, k);
            boolean success = EntityTracksBuilder.placeRailAt(this, this.BuilderInvent[inventoryId], this.field_70170_p, i, j, k);
            if (success) {
                --this.BuilderInvent[inventoryId].field_77994_a;
                if (this.BuilderInvent[inventoryId].field_77994_a == 0) {
                    this.BuilderInvent[inventoryId] = null;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean digAndPlace(int i, int j, int k, int iX, int hY, int kZ) {
        Block block;
        int cX = kZ;
        int cZ = iX;
        int u = i + iX;
        int v = j;
        int w = k + kZ;
        if (hY < 0) {
            block = this.field_70170_p.func_147439_a(u - iX, v - 1, w - kZ);
            if (BlockRail.func_150051_a((Block)block) || block instanceof BlockTCRail || block instanceof BlockTCRailGag) {
                --v;
                ++hY;
            }
        } else if (hY > 0 && (BlockRail.func_150051_a((Block)(block = this.field_70170_p.func_147439_a(u - iX, v, w - kZ))) || block instanceof BlockTCRail || block instanceof BlockTCRailGag)) {
            ++v;
            --hY;
        }
        if (hY != 0) {
            hY /= Math.abs(hY);
        }
        v += hY;
        if (hY > 0) {
            u += iX;
            w += kZ;
        }
        boolean success = true;
        for (int d = -1; d < 2; ++d) {
            for (int dy = 1; dy < 4 + Math.abs(hY); ++dy) {
                success &= this.replaceBlockAt(u + d * cX, v + dy, w + d * cZ, -1);
            }
        }
        success &= this.replaceBlockAt(u - cX, v, w - cZ, -1);
        success &= this.replaceBlockAt(u + cX, v, w + cZ, -1);
        for (int h = 0; h < 4; ++h) {
            success &= this.replaceBlockAt(u - 2 * cX, v + h, w - 2 * cZ, 7);
            success &= this.replaceBlockAt(u + 2 * cX, v + h, w + 2 * cZ, 7);
        }
        success &= this.replaceBlockAt(u - cX, v + 4, w - cZ, 4);
        success &= this.replaceBlockAt(u, v + 4, w, 5);
        success &= this.replaceBlockAt(u + cX, v + 4, w + cZ, 6);
        success &= this.replaceBlockAt(u, v - 2, w, 2);
        success &= this.replaceBlockAt(u, v - 1, w, 3);
        Block underBlock = this.field_70170_p.func_147439_a(u, v - 1, w);
        if (underBlock instanceof BlockFalling && BlockFalling.func_149831_e((World)this.field_70170_p, (int)u, (int)(v - 2), (int)w)) {
            this.skipTick = true;
            return false;
        }
        return success &= this.placeRailAt(u, v, w);
    }

    public static boolean placeRailAt(EntityTracksBuilder builder, ItemStack stack, World world, int i, int j, int k) {
        Block block;
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ITrackItem) {
            return ((ITrackItem)stack.func_77973_b()).placeTrack(stack.func_77946_l(), world, i, j, k);
        }
        if (stack.func_77973_b() instanceof ItemBlock && BlockRailBase.func_150051_a((Block)(block = ((ItemBlock)stack.func_77973_b()).field_150939_a))) {
            boolean success = world.func_147449_b(i, j, k, block);
            if (success) {
                world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            }
            return success;
        }
        if (stack.func_77973_b() instanceof ItemTCRail) {
            ItemTCRail rail = (ItemTCRail)stack.func_77973_b();
            return rail.func_77648_a(stack, null, world, i, j, k, 0, 0.0f, 0.0f, builder.field_70177_z + 90.0f);
        }
        return RailTools.placeRailAt(builder, stack, world, i, j, k);
    }

    public void func_70296_d() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public GameProfile getOwner() {
        return null;
    }
}

