/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fossilsarcheology.server.block.entity.TileEntityAncientChest;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAncientChest
extends BlockContainer {
    private final Random rand = new Random();

    public BlockAncientChest() {
        super(Material.field_151575_d);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.func_149663_c("ancientChest");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 22;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        int facing = 0;
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (rotation == 0) {
            facing = 2;
        }
        if (rotation == 1) {
            facing = 5;
        }
        if (rotation == 2) {
            facing = 3;
        }
        if (rotation == 3) {
            facing = 4;
        }
        world.func_72921_c(x, y, z, facing, 2);
        world.func_147471_g(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntityAncientChest tile = (TileEntityAncientChest)world.func_147438_o(x, y, z);
        if (tile != null) {
            tile.func_145836_u();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int i) {
        TileEntityAncientChest tile = (TileEntityAncientChest)world.func_147438_o(x, y, z);
        if (tile != null) {
            for (int slot = 0; slot < tile.getSizeInventory(); ++slot) {
                ItemStack stack = tile.getStackInSlot(slot);
                if (stack == null) continue;
                float offsetX = this.rand.nextFloat() * 0.8f + 0.1f;
                float offsetY = this.rand.nextFloat() * 0.8f + 0.1f;
                float offsetZ = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int sizeRemoval = this.rand.nextInt(21) + 10;
                    if (sizeRemoval > stack.field_77994_a) {
                        sizeRemoval = stack.field_77994_a;
                    }
                    stack.field_77994_a -= sizeRemoval;
                    EntityItem itemEntity = new EntityItem(world, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), new ItemStack(stack.func_77973_b(), sizeRemoval, stack.func_77960_j()));
                    float motionMultiplier = 0.05f;
                    itemEntity.field_70159_w = (float)this.rand.nextGaussian() * motionMultiplier;
                    itemEntity.field_70181_x = (float)this.rand.nextGaussian() * motionMultiplier + 0.2f;
                    itemEntity.field_70179_y = (float)this.rand.nextGaussian() * motionMultiplier;
                    if (stack.func_77942_o()) {
                        itemEntity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)itemEntity);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, i);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float f, float f1, float f2) {
        TileEntityAncientChest tile = (TileEntityAncientChest)world.func_147438_o(x, y, z);
        if (tile.chestState == 0) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != null && player.func_70694_bm().func_77973_b() == FAItemRegistry.INSTANCE.ancientKey) {
                tile.setChestState(1);
                world.func_147471_g(x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_70694_bm().field_77994_a;
                }
                if (player.func_70694_bm().field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
        } else if (tile.chestState == 1) {
            tile.setChestState(2);
            world.func_147471_g(x, y, z);
            tile.chestLidCounter = 1;
            world.func_72908_a((double)x, (double)y + 0.5, (double)z, "random.chestopen", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return true;
    }

    public IInventory invActivated(World world, int x, int y, int z) {
        TileEntity object = world.func_147438_o(x, y, z);
        if (object == null) {
            return null;
        }
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            return null;
        }
        return (IInventory)object;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityAncientChest();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("fossil:AncientChestSquare");
    }
}

