/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fossilsarcheology.Revival;
import fossilsarcheology.client.render.tileentity.RenderFeeder;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.TileEntityFeeder;
import fossilsarcheology.server.creativetab.FATabRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockFeeder
extends BlockContainer {
    private static final int NO_BIT = 0;
    private static final int HERB_BIT = 4;
    private static final int CARN_BIT = 8;
    private static final int BOTH_BITS = 12;
    private static final int DIRECTION_BITS = 3;
    private Random furnaceRand = new Random();
    private IIcon Top1;
    private IIcon Top2;
    private IIcon Top3;
    private IIcon Top4;
    private IIcon Front1;
    private IIcon Front2;
    private IIcon Front3;
    private IIcon Front4;
    private IIcon Bottom;

    public BlockFeeder(boolean isActive) {
        super(Material.field_151573_f);
        if (isActive) {
            GameRegistry.registerTileEntity(TileEntityFeeder.class, (String)"NewFeeder");
        }
        this.func_149711_c(3.5f);
        this.func_149672_a(Block.field_149777_j);
        if (!isActive) {
            this.func_149647_a(FATabRegistry.INSTANCE.tabFBlocks);
            this.func_149663_c("feederActive");
        } else {
            this.func_149663_c("feederIdle");
        }
    }

    public static void updateFeederBlockState(boolean herb, boolean carn, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        meta = herb ? (meta |= 4) : (meta &= 0xFFFFFFFB);
        meta = carn ? (meta |= 8) : (meta &= 0xFFFFFFF7);
        world.func_72921_c(x, y, z, meta, 2);
        if (tileentity != null) {
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)FABlockRegistry.INSTANCE.feederActive);
    }

    public Item func_149650_a(int var1, Random var2, int var3) {
        return Item.func_150898_a((Block)FABlockRegistry.INSTANCE.feederActive);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    public int func_149645_b() {
        return RenderFeeder.feederRenderID;
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("fossil:Feeder_Sides");
        this.Bottom = par1IconRegister.func_94245_a("fossil:Feeder_Bottom");
        this.Top1 = par1IconRegister.func_94245_a("fossil:Feeder_Top1");
        this.Top2 = par1IconRegister.func_94245_a("fossil:Feeder_Top2");
        this.Top3 = par1IconRegister.func_94245_a("fossil:Feeder_Top3");
        this.Top4 = par1IconRegister.func_94245_a("fossil:Feeder_Top4");
        this.Front1 = par1IconRegister.func_94245_a("fossil:Feeder_Front1");
        this.Front2 = par1IconRegister.func_94245_a("fossil:Feeder_Front2");
        this.Front3 = par1IconRegister.func_94245_a("fossil:Feeder_Front3");
        this.Front4 = par1IconRegister.func_94245_a("fossil:Feeder_Front4");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.Front1;
        }
        if (side == 0) {
            return this.Bottom;
        }
        if (side != 1 && (meta & 3) + 2 != side) {
            return this.field_149761_L;
        }
        if (side == 1) {
            switch (meta & 0xC) {
                case 0: {
                    return this.Top1;
                }
                case 4: {
                    return this.Top2;
                }
                case 8: {
                    return this.Top3;
                }
                case 12: {
                    return this.Top4;
                }
            }
        } else {
            switch (meta & 0xC) {
                case 0: {
                    return this.Front1;
                }
                case 4: {
                    return this.Front2;
                }
                case 8: {
                    return this.Front3;
                }
                case 12: {
                    return this.Front4;
                }
            }
        }
        return this.field_149761_L;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int var6, float var7, float var8, float var9) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityFeeder tileentity = (TileEntityFeeder)world.func_147438_o(x, y, z);
        if (tileentity != null) {
            player.openGui((Object)Revival.INSTANCE, 2, world, x, y, z);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityFeeder();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemstack) {
        int entityDirection = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (entityDirection == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (entityDirection == 1) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (entityDirection == 2) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (entityDirection == 3) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (itemstack.func_82837_s()) {
            ((TileEntityFeeder)world.func_147438_o(x, y, z)).setGuiDisplayName(itemstack.func_82833_r());
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int var6) {
        TileEntityFeeder tileentity = (TileEntityFeeder)world.func_147438_o(x, y, z);
        if (tileentity != null) {
            for (int i = 0; i < tileentity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileentity.func_70301_a(i);
                if (itemstack == null) continue;
                float xOffset = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float yOffset = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float zOffset = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int rand = this.furnaceRand.nextInt(21) + 10;
                    if (rand > itemstack.field_77994_a) {
                        rand = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= rand;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.func_77973_b(), rand, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float offset = 0.05f;
                    entityItem.field_70159_w = (float)this.furnaceRand.nextGaussian() * offset;
                    entityItem.field_70181_x = (float)this.furnaceRand.nextGaussian() * offset + 0.2f;
                    entityItem.field_70179_y = (float)this.furnaceRand.nextGaussian() * offset;
                    world.func_72838_d((Entity)entityItem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, var6);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int par2, int par3, int par4, int par5) {
        return Container.func_94526_b((IInventory)((IInventory)par1World.func_147438_o(par2, par3, par4)));
    }
}

