/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.creativetab.FATabRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPalmLeaves
extends BlockLeaves {
    public static final String[][] TEXTURES = new String[][]{{"leaves_palaeoraphe"}, {"leaves_palaeoraphe_fast"}};
    private IIcon[][] icons = new IIcon[2][];
    private byte[] adjacentTreeBlocks;

    public BlockPalmLeaves() {
        this.func_149647_a(FATabRegistry.INSTANCE.tabFBlocks);
        this.func_149752_b(1.0f);
        this.func_149663_c("palaeorapheLeaves");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        int type = this.getType(meta);
        return type == 1 ? ColorizerFoliage.func_77466_a() : (type == 2 ? ColorizerFoliage.func_77469_b() : ColorizerFoliage.func_77468_c());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int type = this.getType(meta);
        if (type == 1) {
            return ColorizerFoliage.func_77466_a();
        }
        if (type == 2) {
            return ColorizerFoliage.func_77469_b();
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int zOffset = -1; zOffset <= 1; ++zOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                int biomeColor = world.func_72807_a(x + xOffset, z + zOffset).func_150571_c(x, y, z);
                red += (biomeColor & 0xFF0000) >> 16;
                green += (biomeColor & 0xFF00) >> 8;
                blue += biomeColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    private int getType(int meta) {
        return meta & 3;
    }

    public Item func_149650_a(int par1, Random rand, int par3) {
        return Item.func_150898_a((Block)FABlockRegistry.INSTANCE.palmSap);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        this.func_150122_b(Minecraft.func_71410_x().field_71474_y.field_74347_j);
        int type = this.getType(meta);
        return type == 1 ? this.icons[this.field_150127_b][1] : (type == 3 ? this.icons[this.field_150127_b][3] : (type == 2 ? this.icons[this.field_150127_b][2] : this.icons[this.field_150127_b][0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < TEXTURES.length; ++i) {
            this.icons[i] = new IIcon[TEXTURES[i].length];
            for (int j = 0; j < TEXTURES[i].length; ++j) {
                this.icons[i][j] = iconRegister.func_94245_a("fossil:" + TEXTURES[i][j]);
            }
        }
    }

    public String[] func_150125_e() {
        return TEXTURES[this.field_150127_b];
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta;
        if (!world.field_72995_K && ((meta = world.func_72805_g(x, y, z)) & 8) != 0 && (meta & 4) == 0) {
            int scanArea = 4;
            int i = scanArea + 1;
            int size = 32;
            int sizeSquared = size * size;
            int center = size / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new byte[size * size * size];
            }
            if (world.func_72904_c(x - i, y - i, z - i, x + i, y + i, z + i)) {
                for (int offsetX = -scanArea; offsetX <= scanArea; ++offsetX) {
                    for (int offsetY = -scanArea; offsetY <= scanArea; ++offsetY) {
                        for (int offsetZ = -scanArea; offsetZ <= scanArea; ++offsetZ) {
                            Block block = world.func_147439_a(x + offsetX, y + offsetY, z + offsetZ);
                            if (!block.canSustainLeaves((IBlockAccess)world, x + offsetX, y + offsetY, z + offsetZ)) {
                                if (block.isLeaves((IBlockAccess)world, x + offsetX, y + offsetY, z + offsetZ)) {
                                    this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] = -2;
                                    continue;
                                }
                                this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] = -1;
                                continue;
                            }
                            this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] = 0;
                        }
                    }
                }
                for (int blockType = 1; blockType <= 4; ++blockType) {
                    for (int offsetX = -scanArea; offsetX <= scanArea; ++offsetX) {
                        for (int offsetY = -scanArea; offsetY <= scanArea; ++offsetY) {
                            for (int offsetZ = -scanArea; offsetZ <= scanArea; ++offsetZ) {
                                if (this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] != blockType - 1) continue;
                                for (int adjacentX = -1; adjacentX <= 1; ++adjacentX) {
                                    for (int adjacentY = -1; adjacentY <= 1; ++adjacentY) {
                                        for (int adjacentZ = -1; adjacentZ <= 1; ++adjacentZ) {
                                            int index = (offsetX + center + adjacentX) * sizeSquared + (offsetY + center + adjacentY) * size + offsetZ + center + adjacentZ;
                                            if (this.adjacentTreeBlocks[index] != -2) continue;
                                            this.adjacentTreeBlocks[index] = (byte)blockType;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.adjacentTreeBlocks[center * sizeSquared + center * size + center] >= 0) {
                world.func_72921_c(x, y, z, meta & 0xFFFFFFF7, 4);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }
}

