/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.mob;

import fossilsarcheology.server.entity.EntityPrehistoric;
import fossilsarcheology.server.entity.ai.DinoAIAttackOnCollide;
import fossilsarcheology.server.entity.ai.DinoAIEatBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatFeeders;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.enums.EnumPrehistoric;
import fossilsarcheology.server.enums.EnumPrehistoricAI;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityMammoth
extends EntityPrehistoric
implements IShearable {
    private int eatGrassTimes = 0;
    private static PotionEffect BIOME_EFFECT = new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 1);
    protected boolean isSheared;

    public EntityMammoth(World world) {
        super(world, EnumPrehistoric.Mammoth, 2.0, 12.0, 10.0, 66.0, 0.2, 0.3);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIAttackOnCollide(this, 1.5, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIEatBlocks(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIEatFeeders(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIEatItems(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new DinoAIHunt((EntityCreature)this, 20, false));
        this.setActualSize(1.2f, 0.7f);
        this.pediaScale = 60.0f;
        this.minSize = 1.3f;
        this.maxSize = 5.0f;
        this.teenAge = 7;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.ridingY = 1.25f;
        this.eatGrassTimes = 0;
        this.setSheared(false);
    }

    @Override
    public int getAttackLength() {
        return 35;
    }

    @Override
    public int getSpeakLength() {
        return 35;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)3);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return !this.isSheared() && !this.func_70631_g_() && !this.isSkeleton();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> var7 = new ArrayList<ItemStack>();
        int var8 = 1 + this.field_70146_Z.nextInt(20);
        for (int var9 = 0; var9 < var8; ++var9) {
            var7.add(new ItemStack(Blocks.field_150325_L, 1, 12));
        }
        this.setSheared(true);
        this.func_85030_a("mob.sheep.shear", 1.0f, 1.0f);
        return var7;
    }

    @Override
    public String getTexture() {
        String sleeping;
        String gender;
        String toggle;
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        String string = this.hasFeatherToggle ? (!this.featherToggle ? "feathered/" : "scaled/") : (toggle = "");
        String string2 = this.func_70631_g_() ? "_baby" : (gender = this.getGender() == 0 ? "_female" : "_male");
        String string3 = !this.isSleeping() ? (this.isActuallyWeak() ? "_sleeping" : "") : (sleeping = "_sleeping");
        String toggleList = this.hasFeatherToggle ? (!this.featherToggle ? "_feathered" : "_scaled") : "";
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + toggle + this.type.toString().toLowerCase() + gender + toggleList + sleeping + (this.isSheared() ? "_sheared" : "") + ".png";
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public void func_70014_b(NBTTagCompound var1) {
        super.func_70014_b(var1);
        var1.func_74768_a("GrassTicks", this.eatGrassTimes);
        var1.func_74757_a("Sheared", this.isSheared());
    }

    @Override
    public void func_70037_a(NBTTagCompound var1) {
        super.func_70037_a(var1);
        this.setSheared(var1.func_74767_n("Sheared"));
        this.eatGrassTimes = var1.func_74762_e("GrassTicks");
    }

    @Override
    public void doFoodEffect(Item item) {
        super.doFoodEffect(item);
        if (this.isSheared()) {
            ++this.eatGrassTimes;
            if (this.eatGrassTimes >= 5) {
                this.setSheared(false);
                this.eatGrassTimes = 0;
            }
        }
    }

    @Override
    public void func_70636_d() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (!this.func_70644_a(Potion.field_76437_t) && (double)this.field_70170_p.func_72807_a(i, k).func_150564_a(i, j, k) > 1.0 && !this.isSheared()) {
            this.func_70690_d(BIOME_EFFECT);
        }
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 17 && this.func_70638_az() != null) {
            this.func_70652_k((Entity)this.func_70638_az());
        }
        super.func_70636_d();
    }

    @Override
    public EnumPrehistoricAI.Activity aiActivityType() {
        return EnumPrehistoricAI.Activity.DIURINAL;
    }

    @Override
    public EnumPrehistoricAI.Attacking aiAttackType() {
        return EnumPrehistoricAI.Attacking.KNOCKUP;
    }

    @Override
    public EnumPrehistoricAI.Climbing aiClimbType() {
        return EnumPrehistoricAI.Climbing.NONE;
    }

    @Override
    public EnumPrehistoricAI.Following aiFollowType() {
        return EnumPrehistoricAI.Following.NONE;
    }

    @Override
    public EnumPrehistoricAI.Jumping aiJumpType() {
        return EnumPrehistoricAI.Jumping.BASIC;
    }

    @Override
    public EnumPrehistoricAI.Response aiResponseType() {
        return EnumPrehistoricAI.Response.TERITORIAL;
    }

    @Override
    public EnumPrehistoricAI.Stalking aiStalkType() {
        return EnumPrehistoricAI.Stalking.NONE;
    }

    @Override
    public EnumPrehistoricAI.Taming aiTameType() {
        return EnumPrehistoricAI.Taming.IMPRINTING;
    }

    @Override
    public EnumPrehistoricAI.Untaming aiUntameType() {
        return EnumPrehistoricAI.Untaming.ATTACK;
    }

    @Override
    public EnumPrehistoricAI.Moving aiMovingType() {
        return EnumPrehistoricAI.Moving.WALK;
    }

    @Override
    public EnumPrehistoricAI.WaterAbility aiWaterAbilityType() {
        return EnumPrehistoricAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return true;
    }

    @Override
    public Item getOrderItem() {
        return Items.field_151055_y;
    }

    @Override
    public int getAdultAge() {
        return 14;
    }

    @Override
    public float getMaleSize() {
        return 1.2f;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAttackBounds().func_72314_b(3.0, 3.0, 3.0).func_72326_a(entity.field_70121_D)) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(this.ATTACK_ANIMATION);
                return false;
            }
            if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 17) {
                IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
                boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)iattributeinstance.func_111126_e());
                if (entity.field_70154_o != null && entity.field_70154_o == this) {
                    entity.func_70078_a(null);
                }
                entity.field_70181_x += (double)0.4f;
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)((this.field_70177_z - 180.0f) * (float)Math.PI / 180.0f)) * 2.0f * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)((this.field_70177_z - 180.0f) * (float)Math.PI / 180.0f)) * 2.0f * 0.5f));
                return flag;
            }
        }
        return false;
    }

    @Override
    public int getMaxHunger() {
        return 150;
    }

    public void setSheared(boolean sheared) {
        byte b0 = this.field_70180_af.func_75683_a(30);
        if (sheared) {
            this.field_70180_af.func_75692_b(30, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(30, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.isSheared = sheared;
        }
    }

    public boolean isSheared() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSheared;
            boolean bl = isSheared = (this.field_70180_af.func_75683_a(30) & 1) != 0;
            if (isSheared != this.isSheared) {
                this.ticksSlept = 0;
            }
            this.isSheared = isSheared;
            return isSheared;
        }
        return this.isSheared;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }
}

