/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.mob;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fossilsarcheology.Revival;
import fossilsarcheology.server.entity.EntityFishBase;
import fossilsarcheology.server.entity.EntityPrehistoric;
import fossilsarcheology.server.enums.EnumPrehistoric;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.message.MessageUpdateNautilus;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityNautilus
extends EntityFishBase {
    public float shellProgress;
    public static final int SHELL_INDEX = 24;
    public boolean isInShell;
    public int ticksToShell;

    public EntityNautilus(World world) {
        super(world, EnumPrehistoric.Nautilus);
        this.func_70105_a(0.8f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("InShell", this.isInShell);
        compound.func_74768_a("ShellTick", this.ticksToShell);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.setInShell(compound.func_74767_n("InShell"));
        this.ticksToShell = compound.func_74762_e("ShellTick");
    }

    public void setInShell(boolean inShell) {
        byte b0 = this.field_70180_af.func_75683_a(24);
        if (inShell) {
            this.field_70180_af.func_75692_b(24, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(24, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.isInShell = inShell;
        }
    }

    public boolean isInShell() {
        if (this.field_70170_p.field_72995_K) {
            boolean isInShell;
            this.isInShell = isInShell = (this.field_70180_af.func_75683_a(24) & 1) != 0;
            return isInShell;
        }
        return this.isInShell;
    }

    public void func_70636_d() {
        super.func_70636_d();
        boolean inshell = this.isInShell();
        if (inshell && this.shellProgress < 20.0f) {
            this.shellProgress += 0.5f;
        } else if (!inshell && this.shellProgress > 0.0f) {
            this.shellProgress -= 0.5f;
        }
        if (this.ticksToShell > 0) {
            --this.ticksToShell;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isThereNearbyMobs() && this.ticksToShell == 0 || !this.func_70090_H() && this.field_70122_E && this.ticksToShell == 0) {
                if (!this.isInShell()) {
                    this.setInShell(true);
                    Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateNautilus(this.func_145782_y(), true));
                }
            } else if (this.isInShell()) {
                this.setInShell(false);
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateNautilus(this.func_145782_y(), false));
            }
        }
    }

    protected void func_70628_a(boolean burning, int i) {
        this.func_145779_a(FAItemRegistry.INSTANCE.emptyShell, 1);
    }

    public boolean isThereNearbyMobs() {
        EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this);
        IEntitySelector targetEntitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return !(entity instanceof EntityFishBase);
            }
        };
        List list = this.field_70170_p.func_82733_a(Entity.class, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0), targetEntitySelector);
        Collections.sort(list, theNearestAttackableTargetSorter);
        if (list.isEmpty()) {
            return false;
        }
        for (Entity entity : list) {
            if (!this.isAScaryAnimal(entity)) continue;
            return true;
        }
        return false;
    }

    public boolean isAScaryAnimal(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        if (entity instanceof EntityPrehistoric) {
            return ((EntityPrehistoric)entity).type.diet.getFearIndex() >= 2;
        }
        return (double)entity.field_70130_N >= 1.2;
    }

    public boolean func_70097_a(DamageSource dmg, float f) {
        if (f > 0.0f && this.isInShell() && dmg.func_76346_g() != null) {
            this.func_85030_a("random.break", 1.0f, this.func_70681_au().nextFloat() + 0.8f);
            if (this.field_70154_o != null) {
                return super.func_70097_a(dmg, f);
            }
            return false;
        }
        if (!this.isInShell()) {
            this.setInShell(true);
            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateNautilus(this.func_145782_y(), true));
        }
        return super.func_70097_a(dmg, f);
    }

    @Override
    public String getTexture() {
        return "fossil:textures/model/fish/nautilus.png";
    }

    @Override
    protected double getSwimSpeed() {
        return 0.25;
    }
}

