/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.enums;

import cpw.mods.fml.common.registry.GameRegistry;
import fossilsarcheology.api.EnumDiet;
import fossilsarcheology.server.creativetab.FATabRegistry;
import fossilsarcheology.server.entity.EntityPrehistoric;
import fossilsarcheology.server.entity.mob.EntityAlligatorGar;
import fossilsarcheology.server.entity.mob.EntityAllosaurus;
import fossilsarcheology.server.entity.mob.EntityAnkylosaurus;
import fossilsarcheology.server.entity.mob.EntityBrachiosaurus;
import fossilsarcheology.server.entity.mob.EntityCeratosaurus;
import fossilsarcheology.server.entity.mob.EntityCoelacanth;
import fossilsarcheology.server.entity.mob.EntityCompsognathus;
import fossilsarcheology.server.entity.mob.EntityConfuciusornis;
import fossilsarcheology.server.entity.mob.EntityDeinonychus;
import fossilsarcheology.server.entity.mob.EntityDilophosaurus;
import fossilsarcheology.server.entity.mob.EntityDodo;
import fossilsarcheology.server.entity.mob.EntityDryosaurus;
import fossilsarcheology.server.entity.mob.EntityElasmotherium;
import fossilsarcheology.server.entity.mob.EntityGallimimus;
import fossilsarcheology.server.entity.mob.EntityGastornis;
import fossilsarcheology.server.entity.mob.EntityHenodus;
import fossilsarcheology.server.entity.mob.EntityIcthyosaurus;
import fossilsarcheology.server.entity.mob.EntityKelenken;
import fossilsarcheology.server.entity.mob.EntityLiopleurodon;
import fossilsarcheology.server.entity.mob.EntityMammoth;
import fossilsarcheology.server.entity.mob.EntityMosasaurus;
import fossilsarcheology.server.entity.mob.EntityNautilus;
import fossilsarcheology.server.entity.mob.EntityPachycephalosaurus;
import fossilsarcheology.server.entity.mob.EntityParasaurolophus;
import fossilsarcheology.server.entity.mob.EntityPhorusrhacos;
import fossilsarcheology.server.entity.mob.EntityPlesiosaurus;
import fossilsarcheology.server.entity.mob.EntityPterosaur;
import fossilsarcheology.server.entity.mob.EntityQuagga;
import fossilsarcheology.server.entity.mob.EntitySarcosuchus;
import fossilsarcheology.server.entity.mob.EntitySmilodon;
import fossilsarcheology.server.entity.mob.EntitySpinosaurus;
import fossilsarcheology.server.entity.mob.EntityStegosaurus;
import fossilsarcheology.server.entity.mob.EntitySturgeon;
import fossilsarcheology.server.entity.mob.EntityTherizinosaurus;
import fossilsarcheology.server.entity.mob.EntityTitanis;
import fossilsarcheology.server.entity.mob.EntityTriceratops;
import fossilsarcheology.server.entity.mob.EntityTyrannosaurus;
import fossilsarcheology.server.entity.mob.EntityVelociraptor;
import fossilsarcheology.server.enums.EnumMobType;
import fossilsarcheology.server.enums.EnumTimePeriod;
import fossilsarcheology.server.item.BirdEggItem;
import fossilsarcheology.server.item.DinoEggItem;
import fossilsarcheology.server.item.ItemFish;
import fossilsarcheology.server.item.MammalEmbryoItem;
import fossilsarcheology.server.item.forge.ForgeFoodItem;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.Item;
import net.minecraft.world.World;

public enum EnumPrehistoric {
    Nautilus(EntityNautilus.class, EnumMobType.FISH, EnumTimePeriod.MESOZOIC, EnumDiet.NONE, 0, true, 12934983, 0xF5F5F5),
    Coelacanth(EntityCoelacanth.class, EnumMobType.FISH, EnumTimePeriod.MESOZOIC, EnumDiet.NONE, 0, true, 3553601, 10199465),
    Alligator_Gar(EntityAlligatorGar.class, EnumMobType.FISH, EnumTimePeriod.MESOZOIC, EnumDiet.NONE, 0, true, 4408874, 11485745),
    Sturgeon(EntitySturgeon.class, EnumMobType.FISH, EnumTimePeriod.MESOZOIC, EnumDiet.NONE, 0, true, 6643035, 0xE6E3E3),
    Triceratops(EntityTriceratops.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 29, true, 6567213, 2431511, 0.8f),
    Velociraptor(EntityVelociraptor.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE_EGG, 10, true, 4852996, 0xC9C9C9, 0.5f),
    Tyrannosaurus(EntityTyrannosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE, 30, true, 10324596, 4993302, 0.9f),
    Pterosaur(EntityPterosaur.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCIVORE, 14, true, 0xD6D6D6, 0x3B3B3B, 0.4f),
    Plesiosaur(EntityPlesiosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCIVORE, 30, true, 14985326, 14776608),
    Mosasaurus(EntityMosasaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCCARNIVORE, 6, true, 8949136, 3820626),
    Stegosaurus(EntityStegosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 13, true, 10256696, 6625303, 0.7f),
    Dilophosaurus(EntityDilophosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE, 10, true, 5134641, 15880980, 0.5f),
    Brachiosaurus(EntityBrachiosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 29, true, 5395006, 0x222114),
    Spinosaurus(EntitySpinosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCCARNIVORE, 6, true, 8671530, 5648160, 0.8f),
    Compsognathus(EntityCompsognathus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE, 14, true, 13354948, 3813676, 0.2f),
    Ankylosaurus(EntityAnkylosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 29, true, 9067337, 2169619, 0.7f),
    Pachycephalosaurus(EntityPachycephalosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 9, true, 11970953, 8216122, 0.6f),
    Deinonychus(EntityDeinonychus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE_EGG, 14, true, 0x2B2424, 0xC8C8C8, 0.6f),
    Gallimimus(EntityGallimimus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.OMNIVORE, 31, true, 6701355, 6169880, 0.5f),
    Liopleurodon(EntityLiopleurodon.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCCARNIVORE, 6, true, 12568514, 1909022),
    Allosaurus(EntityAllosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE, 30, true, 9468780, 6242861, 0.8f),
    Sarcosuchus(EntitySarcosuchus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCCARNIVORE, 10, true, 4933929, 9276517, 0.7f),
    Ceratosaurus(EntityCeratosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.CARNIVORE, 30, true, 11842727, 0x776446, 0.6f),
    Dryosaurus(EntityDryosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 13, true, 7359526, 12959898, 0.6f),
    Therizinosaurus(EntityTherizinosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 13, true, 0x322212, 13278322, 0.8f),
    Icthyosaurus(EntityIcthyosaurus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.PISCIVORE, 12, true, 12759186, 4078908, 0.8f),
    Henodus(EntityHenodus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 12, true, 10256480, 4401178, 0.5f),
    Parasaurolophus(EntityParasaurolophus.class, EnumMobType.DINOSAUR, EnumTimePeriod.MESOZOIC, EnumDiet.HERBIVORE, 13, true, 8293936, 5002296, 1.0f),
    Confuciusornis(EntityConfuciusornis.class, EnumMobType.BIRD, EnumTimePeriod.MESOZOIC, EnumDiet.PISCIVORE, 10, true, 14345705, 0x8B8B8D),
    Dodo(EntityDodo.class, EnumMobType.BIRD, EnumTimePeriod.CENOZOIC, EnumDiet.HERBIVORE, 9, true, 6641489, 12493947),
    Gastornis(EntityGastornis.class, EnumMobType.BIRD, EnumTimePeriod.CENOZOIC, EnumDiet.HERBIVORE, 8, true, 3435614, 0xC8C8C8),
    Kelenken(EntityKelenken.class, EnumMobType.BIRD, EnumTimePeriod.CENOZOIC, EnumDiet.CARNIVORE, 8, true, 3747620, 15920085),
    Phorusrhacos(EntityPhorusrhacos.class, EnumMobType.BIRD, EnumTimePeriod.CENOZOIC, EnumDiet.CARNIVORE, 8, true, 6245950, 0xD4D4D4),
    Titanis(EntityTitanis.class, EnumMobType.BIRD, EnumTimePeriod.CENOZOIC, EnumDiet.CARNIVORE, 8, true, 0x484848, 0xEFEFEF),
    Mammoth(EntityMammoth.class, EnumMobType.MAMMAL, EnumTimePeriod.CENOZOIC, EnumDiet.HERBIVORE, 25, true, 4009497, 2365195),
    Smilodon(EntitySmilodon.class, EnumMobType.MAMMAL, EnumTimePeriod.CENOZOIC, EnumDiet.CARNIVORE, 10, true, 12094564, 15523790),
    Quagga(EntityQuagga.class, EnumMobType.MAMMAL, EnumTimePeriod.CENOZOIC, EnumDiet.HERBIVORE, 25, true, 7748644, 13875627),
    Elasmotherium(EntityElasmotherium.class, EnumMobType.MAMMAL, EnumTimePeriod.CENOZOIC, EnumDiet.HERBIVORE, 25, true, 7025179, 0x666666),
    Pig(EntityPig.class, EnumMobType.VANILLA, EnumTimePeriod.CURRENT, EnumDiet.OMNIVORE, 0, false, 0, 0),
    Cow(EntityCow.class, EnumMobType.VANILLA, EnumTimePeriod.CURRENT, EnumDiet.HERBIVORE, 0, false, 0, 0),
    Sheep(EntitySheep.class, EnumMobType.VANILLA, EnumTimePeriod.CURRENT, EnumDiet.HERBIVORE, 0, false, 0, 0),
    Horse(EntityHorse.class, EnumMobType.VANILLA, EnumTimePeriod.CURRENT, EnumDiet.HERBIVORE, 0, false, 0, 0),
    Chicken(EntityChicken.class, EnumMobType.CHICKEN, EnumTimePeriod.CURRENT, EnumDiet.HERBIVORE, 0, false, 0, 0);

    private static float sizeBaby;
    private static float sizeTeen;
    private static float sizeAdult;
    private final Class<? extends Entity> dinoClass;
    public EnumMobType type;
    public EnumDiet diet;
    public EnumTimePeriod timeperiod;
    public int MaxAge = 999;
    public int AdultAge = 6;
    public int TeenAge = 3;
    public double Health0 = 20.0;
    public double HealthMax = 20.0;
    public double Strength0 = 2.0;
    public double StrengthMax = 2.0;
    public double Speed0 = 0.25;
    public double SpeedMax = 0.3;
    public int BreedingTicks = 3000;
    public int AgingTicks = 12000;
    public int MaxHunger = 100;
    public float HungryLevel = 0.8f;
    public float Exp0 = 1.0f;
    public float ExpInc = 0.2f;
    public int Flags = 0;
    public Item orderItem;
    public Item fishItem;
    public Item foodItem;
    public Item cookedFoodItem;
    public Item DNAItem;
    public Item eggItem;
    public Item embryoItem;
    public Item birdEggItem;
    public Item bestBirdEggItem;
    public int growTime = 10000;
    public int mainSpawnColor;
    public int secondSpawnColor;
    public float eggScale;

    private EnumPrehistoric(Class class0, EnumMobType animalType, EnumTimePeriod timeperiod, EnumDiet diet, int f0, boolean init, int mainSpawnColor, int secondSpawnColor) {
        this.dinoClass = class0;
        this.type = animalType;
        this.timeperiod = timeperiod;
        this.diet = diet;
        this.Flags = f0;
        this.mainSpawnColor = mainSpawnColor;
        this.secondSpawnColor = secondSpawnColor;
        this.eggScale = 1.0f;
    }

    private EnumPrehistoric(Class class0, EnumMobType animalType, EnumTimePeriod timeperiod, EnumDiet diet, int f0, boolean init, int mainSpawnColor, int secondSpawnColor, float eggScale) {
        this.dinoClass = class0;
        this.type = animalType;
        this.timeperiod = timeperiod;
        this.diet = diet;
        this.Flags = f0;
        this.mainSpawnColor = mainSpawnColor;
        this.secondSpawnColor = secondSpawnColor;
        this.eggScale = eggScale;
    }

    public static void init() {
        int i;
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            EnumPrehistoric.values()[i].DNAItem = new Item().func_77655_b("dna" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/dna/" + EnumPrehistoric.values()[i].name() + "_DNA").func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].DNAItem, (String)("dna" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type == EnumMobType.FISH) {
                EnumPrehistoric.values()[i].eggItem = new ItemFish(EnumPrehistoric.values()[i], true).func_77655_b("egg" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/dinoEggs/" + EnumPrehistoric.values()[i].name() + "_Egg").func_77637_a(FATabRegistry.INSTANCE.tabFItems);
                GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].eggItem, (String)("egg" + EnumPrehistoric.values()[i].name()));
            }
            if (EnumPrehistoric.values()[i].type != EnumMobType.DINOSAUR) continue;
            EnumPrehistoric.values()[i].eggItem = new DinoEggItem(EnumPrehistoric.values()[i]).func_77655_b("egg" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/dinoEggs/" + EnumPrehistoric.values()[i].name() + "_Egg").func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].eggItem, (String)("egg" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.MAMMAL && EnumPrehistoric.values()[i].type != EnumMobType.VANILLA) continue;
            EnumPrehistoric.values()[i].embryoItem = new MammalEmbryoItem(i).func_77655_b("embryo" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/embryos/" + EnumPrehistoric.values()[i].name() + "_Syringe").func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].embryoItem, (String)("embryo" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.FISH) continue;
            EnumPrehistoric.values()[i].fishItem = new ItemFish(EnumPrehistoric.values()[i], false).func_77655_b("fish" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/embryos/" + EnumPrehistoric.values()[i].name() + "_Syringe").func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].fishItem, (String)("fish" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.BIRD) continue;
            EnumPrehistoric.values()[i].birdEggItem = new BirdEggItem(EnumPrehistoric.values()[i], false).func_77655_b("egg" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/birdEggs/Egg_" + EnumPrehistoric.values()[i].name()).func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].birdEggItem, (String)("egg" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.BIRD && EnumPrehistoric.values()[i].type != EnumMobType.CHICKEN) continue;
            EnumPrehistoric.values()[i].bestBirdEggItem = new BirdEggItem(EnumPrehistoric.values()[i], true).func_77655_b("eggCultivated" + EnumPrehistoric.values()[i].name()).func_111206_d("fossil:prehistoric/birdEggs/Egg_Cultivated_" + EnumPrehistoric.values()[i].name()).func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].bestBirdEggItem, (String)("eggCultivated" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].timeperiod == EnumTimePeriod.CURRENT || EnumPrehistoric.values()[i].type == EnumMobType.FISH) continue;
            EnumPrehistoric.values()[i].foodItem = new ForgeFoodItem(3, 0.3f, true, "prehistoric/food/" + EnumPrehistoric.values()[i].name() + "_Meat").func_77655_b("raw" + EnumPrehistoric.values()[i].name()).func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].foodItem, (String)("raw" + EnumPrehistoric.values()[i].name()));
        }
        for (i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].timeperiod == EnumTimePeriod.CURRENT || EnumPrehistoric.values()[i] == Nautilus) continue;
            EnumPrehistoric.values()[i].cookedFoodItem = new ForgeFoodItem(8, 0.8f, true, "prehistoric/cookedFood/" + EnumPrehistoric.values()[i].name() + "_Meat").func_77655_b("cooked" + EnumPrehistoric.values()[i].name()).func_77637_a(FATabRegistry.INSTANCE.tabFItems);
            GameRegistry.registerItem((Item)EnumPrehistoric.values()[i].cookedFoodItem, (String)("cooked" + EnumPrehistoric.values()[i].name()));
        }
    }

    public static boolean isDNA(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].DNAItem != i0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDinoEgg(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.DINOSAUR || EnumPrehistoric.values()[i].eggItem != i0) continue;
            return true;
        }
        return false;
    }

    public static boolean isFoodItem(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].foodItem != i0) continue;
            return true;
        }
        return false;
    }

    public static Item getDNA(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].bestBirdEggItem != i0 && EnumPrehistoric.values()[i].birdEggItem != i0 && EnumPrehistoric.values()[i].embryoItem != i0 && EnumPrehistoric.values()[i].foodItem != i0 && EnumPrehistoric.values()[i].eggItem != i0) continue;
            return EnumPrehistoric.values()[i].DNAItem;
        }
        return null;
    }

    public static boolean isEmbryo(Item item) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.MAMMAL || EnumPrehistoric.values()[i].embryoItem != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isBirdEgg(Item item) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.BIRD || EnumPrehistoric.values()[i].birdEggItem != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isBestBirdEgg(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.BIRD && EnumPrehistoric.values()[i].type != EnumMobType.CHICKEN || EnumPrehistoric.values()[i].bestBirdEggItem != i0) continue;
            return true;
        }
        return false;
    }

    public static Item getFoodItem(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].bestBirdEggItem != i0 && EnumPrehistoric.values()[i].birdEggItem != i0 && EnumPrehistoric.values()[i].embryoItem != i0 && EnumPrehistoric.values()[i].DNAItem != i0 && EnumPrehistoric.values()[i].eggItem != i0) continue;
            return EnumPrehistoric.values()[i].foodItem;
        }
        return null;
    }

    public static Item getEgg(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type == EnumMobType.DINOSAUR && (EnumPrehistoric.values()[i].foodItem == i0 || EnumPrehistoric.values()[i].DNAItem == i0)) {
                return EnumPrehistoric.values()[i].eggItem;
            }
            if (EnumPrehistoric.values()[i].type != EnumMobType.FISH || EnumPrehistoric.values()[i].DNAItem != i0) continue;
            return EnumPrehistoric.values()[i].eggItem;
        }
        return null;
    }

    public static Item getEmbryo(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type == EnumMobType.MAMMAL && (EnumPrehistoric.values()[i].DNAItem == i0 || EnumPrehistoric.values()[i].foodItem == i0)) {
                return EnumPrehistoric.values()[i].embryoItem;
            }
            if (EnumPrehistoric.values()[i].type != EnumMobType.VANILLA || EnumPrehistoric.values()[i].DNAItem != i0) continue;
            return EnumPrehistoric.values()[i].embryoItem;
        }
        return null;
    }

    public static Item getBirdEgg(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.BIRD || EnumPrehistoric.values()[i].bestBirdEggItem != i0 && EnumPrehistoric.values()[i].DNAItem != i0 && EnumPrehistoric.values()[i].foodItem != i0) continue;
            return EnumPrehistoric.values()[i].birdEggItem;
        }
        return null;
    }

    public static Item getBestBirdEgg(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type != EnumMobType.BIRD && EnumPrehistoric.values()[i].type != EnumMobType.CHICKEN || EnumPrehistoric.values()[i].birdEggItem != i0 && EnumPrehistoric.values()[i].DNAItem != i0 && EnumPrehistoric.values()[i].foodItem != i0) continue;
            return EnumPrehistoric.values()[i].bestBirdEggItem;
        }
        return null;
    }

    public static int getIndex(Item i0) {
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].bestBirdEggItem != i0 && EnumPrehistoric.values()[i].embryoItem != i0 && EnumPrehistoric.values()[i].birdEggItem != i0 && EnumPrehistoric.values()[i].DNAItem != i0 && EnumPrehistoric.values()[i].foodItem != i0 && EnumPrehistoric.values()[i].eggItem != i0) continue;
            return i;
        }
        return -1;
    }

    public static EnumPrehistoric getRandomMezoic() {
        ArrayList<EnumPrehistoric> list = new ArrayList<EnumPrehistoric>();
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].timeperiod != EnumTimePeriod.MESOZOIC) continue;
            list.add(EnumPrehistoric.values()[i]);
        }
        int index = new Random().nextInt(list.size());
        return (EnumPrehistoric)((Object)list.get(index));
    }

    public static Item getRandomMesozoicDNA() {
        ArrayList<Item> list = new ArrayList<Item>();
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].timeperiod != EnumTimePeriod.MESOZOIC) continue;
            list.add(EnumPrehistoric.values()[i].DNAItem);
        }
        int index = new Random().nextInt(list.size());
        return (Item)list.get(index);
    }

    public static EnumPrehistoric getRandomCenozoic() {
        ArrayList<EnumPrehistoric> list = new ArrayList<EnumPrehistoric>();
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].timeperiod != EnumTimePeriod.CENOZOIC) continue;
            list.add(EnumPrehistoric.values()[i]);
        }
        int index = new Random().nextInt(list.size());
        return (EnumPrehistoric)((Object)list.get(index));
    }

    public static EnumPrehistoric getRandomBioFossil(boolean tar) {
        ArrayList<EnumPrehistoric> list = new ArrayList<EnumPrehistoric>();
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].type == EnumMobType.VANILLA || EnumPrehistoric.values()[i].type == EnumMobType.CHICKEN || EnumPrehistoric.values()[i].type == EnumMobType.FISH) continue;
            if (tar) {
                if (EnumPrehistoric.values()[i].timeperiod != EnumTimePeriod.CENOZOIC || !EntityPrehistoric.class.isAssignableFrom(EnumPrehistoric.values()[i].dinoClass)) continue;
                list.add(EnumPrehistoric.values()[i]);
                continue;
            }
            if (EnumPrehistoric.values()[i].timeperiod != EnumTimePeriod.MESOZOIC && EnumPrehistoric.values()[i].timeperiod != EnumTimePeriod.PALEOZOIC) continue;
            list.add(EnumPrehistoric.values()[i]);
        }
        int index = new Random().nextInt(list.size());
        return (EnumPrehistoric)((Object)list.get(index));
    }

    public static EnumPrehistoric getRandom() {
        ArrayList<EnumPrehistoric> list = new ArrayList<EnumPrehistoric>();
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            list.add(EnumPrehistoric.values()[i]);
        }
        int index = ThreadLocalRandom.current().nextInt(list.size());
        return (EnumPrehistoric)((Object)list.get(index));
    }

    public Entity invokeClass(World world) {
        Entity entity = null;
        if (Entity.class.isAssignableFrom(this.dinoClass)) {
            try {
                entity = this.dinoClass.getDeclaredConstructor(World.class).newInstance(world);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        return entity;
    }

    public static int getBones() {
        ArrayList<EnumPrehistoric> list = new ArrayList<EnumPrehistoric>();
        for (int i = 0; i < EnumPrehistoric.values().length; ++i) {
            if (EnumPrehistoric.values()[i].timeperiod == EnumTimePeriod.CURRENT && EnumPrehistoric.values()[i].type == EnumMobType.FISH) continue;
            list.add(EnumPrehistoric.values()[i]);
        }
        return list.size();
    }

    private void setOrderItem(Item order) {
        this.orderItem = order;
    }

    private void setAges(int Teen, int Adult, int Max) {
        if (Teen > 0) {
            this.TeenAge = Teen;
        }
        if (Adult > 0) {
            this.AdultAge = Adult;
        }
        if (Max > 0) {
            this.MaxAge = Max;
        }
    }

    private void setDinoSize(float sizeBaby, float sizeTeen, float sizeAdult) {
        EnumPrehistoric.sizeBaby = sizeBaby;
        EnumPrehistoric.sizeTeen = sizeTeen;
        EnumPrehistoric.sizeAdult = sizeAdult;
    }

    private void setProperties(double H0, double HMax, double Str0, double StrMax, double Sp0, double SpMax, int Hunger) {
        if (H0 > 0.0) {
            this.Health0 = H0;
        }
        if (Str0 > 0.0) {
            this.Strength0 = Str0;
        }
        if (Sp0 > 0.0) {
            this.Speed0 = Sp0;
        }
        if (HMax > 0.0) {
            this.HealthMax = HMax;
        }
        if (StrMax > 0.0) {
            this.StrengthMax = StrMax;
        }
        if (SpMax > 0.0) {
            this.SpeedMax = SpMax;
        }
        if (Hunger > 0) {
            this.MaxHunger = Hunger;
        }
    }

    private void setAddProperties(int Breed, int Age, float HLevel) {
        if (Breed > 0) {
            this.BreedingTicks = Breed;
        }
        if (Age > 0) {
            this.AgingTicks = Age;
        }
        if (HLevel > 0.0f) {
            this.HungryLevel = HLevel;
        }
    }

    public boolean isAquatic() {
        return this == Plesiosaur || this == Mosasaurus || this == Liopleurodon || this == Icthyosaurus;
    }

    public Class getDinoClass() {
        return this.dinoClass;
    }

    public boolean isTameable() {
        return (this.Flags & 8) != 0;
    }

    public boolean isRideable() {
        return (this.Flags & 0x10) != 0;
    }

    public boolean isHerbivore() {
        return (this.Flags & 1) != 0;
    }

    public boolean isCarnivore() {
        return (this.Flags & 2) != 0;
    }

    static {
        sizeBaby = 1.0f;
        sizeTeen = 1.0f;
        sizeAdult = 1.0f;
    }
}

