/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.aquaculture.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import rebelkeithy.mods.aquaculture.items.AquacultureItems;
import rebelkeithy.mods.aquaculture.loot.BiomeType;
import rebelkeithy.mods.aquaculture.loot.FishLoot;

public class ItemFish
extends Item {
    public List<Fish> fish;

    public ItemFish() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.fish = new ArrayList<Fish>();
    }

    public void addFish(String name, int filletAmount, int minWeight, int maxWeight, BiomeType biome, int rarity) {
        this.addFish(name, filletAmount, minWeight, maxWeight, new BiomeType[]{biome}, rarity);
    }

    public void addFish(String name, int filletAmount, int minWeight, int maxWeight, BiomeType[] biomes, int rarity) {
        this.fish.add(new Fish(name, filletAmount, minWeight, maxWeight));
        for (BiomeType biome : biomes) {
            FishLoot.instance().addFish(this.getItemStackFish(name), biome, rarity);
        }
    }

    public void addFilletRecipes() {
        for (int i = 0; i < this.fish.size(); ++i) {
            Fish f = this.fish.get(i);
            if (f.filletAmount == 0) continue;
            GameRegistry.addShapelessRecipe((ItemStack)AquacultureItems.fishFillet.getItemStack(f.filletAmount), (Object[])new Object[]{new ItemStack((Item)this, 1, i)});
        }
    }

    public String getItemDisplayName(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("Prefix")) {
            return par1ItemStack.func_77978_p().func_74779_i("Prefix") + " " + super.func_77653_i(par1ItemStack);
        }
        return super.func_77653_i(par1ItemStack);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("Weight")) {
            float weight = par1ItemStack.func_77978_p().func_74760_g("Weight");
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            if ((bd = bd.round(new MathContext(3))).doubleValue() > 999.0) {
                par3List.add("Weight: " + df.format((int)bd.doubleValue()) + "lb");
            } else {
                par3List.add("Weight: " + bd + "lb");
            }
        }
    }

    public void assignRandomWeight(ItemStack stack, int heavyLineLvl) {
        if (stack == null) {
            return;
        }
        Fish f = this.fish.get(stack.func_77960_j());
        if (f.maxWeight == 1 && f.minWeight == 1) {
            return;
        }
        Random rand = new Random();
        float min = f.minWeight;
        min = (float)((double)min + (double)((float)f.maxWeight - min) * (0.1 * (double)heavyLineLvl));
        float weight = rand.nextFloat() * ((float)f.maxWeight * 1.1f - min) + min;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74776_a("Weight", weight);
        if ((double)weight <= (double)f.maxWeight / 10.0) {
            stack.func_77978_p().func_74778_a("Prefix", "Juvenile");
        }
        if (weight > (float)f.maxWeight) {
            stack.func_77978_p().func_74778_a("Prefix", "Massive");
        }
    }

    public ItemStack getItemStackFish(String name) {
        for (int i = 0; i < this.fish.size(); ++i) {
            if (!this.fish.get((int)i).name.equals(name)) continue;
            return new ItemStack((Item)this, 1, i);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        int j = MathHelper.func_76125_a((int)par1, (int)0, (int)this.fish.size());
        return this.fish.get((int)j).icon;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77960_j(), (int)0, (int)this.fish.size());
        String uname = super.func_77658_a() + "." + this.fish.get((int)i).name;
        uname = uname.replace(" ", "_");
        return uname;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < this.fish.size(); ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        for (Fish f : this.fish) {
            f.icon = par1IconRegister.func_94245_a("Aquaculture:" + f.name);
        }
    }

    public class Fish {
        public String name;
        public int filletAmount;
        public int minWeight;
        public int maxWeight;
        public IIcon icon;

        public Fish(String name, int amount, int min, int max) {
            this.name = name;
            this.filletAmount = amount;
            this.maxWeight = max;
            this.minWeight = min;
        }
    }
}

