/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.util.SearchResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeUtils {
    public static List<BiomeGenBase> getAllowedBiomes() {
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || BiomeUtils.biomeIsBlacklisted(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static SearchResult searchForBiome(World world, ItemStack stack, BiomeGenBase biome, int startX, int startY) {
        if (stack.func_77973_b() != NaturesCompass.naturesCompass) {
            return null;
        }
        int sampleSpace = ConfigHandler.sampleSpace;
        int maxDist = ConfigHandler.maxSearchDistance;
        if (maxDist <= 0 || sampleSpace <= 0) {
            return new SearchResult(0, 0, maxDist, false);
        }
        double adjustedSampleSpace = (double)sampleSpace / Math.sqrt(Math.PI);
        double adjustedPi = 2.0 * Math.sqrt(Math.PI);
        double dist = 0.0;
        int i = 0;
        while (dist < (double)maxDist) {
            double z;
            double root = Math.sqrt(i);
            dist = adjustedSampleSpace * root;
            double x = (double)startX + dist * Math.sin(adjustedPi * root);
            BiomeGenBase biomeAtSample = world.func_72807_a((int)x, (int)(z = (double)startY + dist * Math.cos(adjustedPi * root)));
            if (biomeAtSample == biome) {
                return new SearchResult((int)x, (int)z, maxDist, true);
            }
            ++i;
        }
        return new SearchResult(0, 0, maxDist, false);
    }

    public static int getDistanceToBiome(EntityPlayer player, int x, int z) {
        return (int)player.func_70011_f((double)x, player.field_70163_u, (double)z);
    }

    public static String getBiomeName(BiomeGenBase biome) {
        if (biome != null && biome.field_76791_y != null) {
            if (ConfigHandler.fixBiomeNames) {
                String original = biome.field_76791_y;
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            return biome.field_76791_y;
        }
        return "";
    }

    public static String getBiomeName(int biomeID) {
        return BiomeUtils.getBiomeName(BiomeGenBase.func_150568_d((int)biomeID));
    }

    public static boolean biomeIsBlacklisted(BiomeGenBase biome) {
        List<String> biomeBlacklist = ConfigHandler.getBiomeBlacklist();
        return biomeBlacklist.contains(String.valueOf(biome.field_76756_M)) || biomeBlacklist.contains(BiomeUtils.getBiomeName(biome)) || biomeBlacklist.contains(biome.field_76791_y);
    }
}

