/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private Button switchingButton;
    private Button multiworldTypeOptionButton;
    private Button renameButton;
    private Button deleteButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setBoxWidth(200);
        this.serverSelectionModeBox.setBoxWidth(200);
    }

    public void init(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft field_230706_i_, int field_230708_k_, int field_230709_l_) {
        this.multiworldTypeOptionButton = null;
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        MapDimension mapDimension = this.settingsDimension = mapWorld == null || mapWorld.getCurrentDimensionId() == null ? null : mapWorld.getCurrentDimension();
        if (this.settingsDimension != null && mapWorld.isMultiplayer()) {
            this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, field_230709_l_ - 20, b -> {
                this.active = !this.active;
                mapScreen.m_6575_(field_230706_i_, field_230708_k_, field_230709_l_);
            });
            mapScreen.addButton(this.switchingButton);
            if (this.active) {
                String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
                ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
                for (String string : this.settingsDimension.getMultiworldIdsCopy()) {
                    sortableList.add(new KeySortableByOther<String>(string, new Comparable[]{this.settingsDimension.getMultiworldName(string).toLowerCase()}));
                }
                Collections.sort(sortableList);
                ArrayList<String> dropdownValuesList = new ArrayList<String>();
                for (KeySortableByOther keySortableByOther : sortableList) {
                    dropdownValuesList.add((String)keySortableByOther.getKey());
                }
                int n = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
                if (n == dropdownValuesList.size()) {
                    dropdownValuesList.add(currentMultiworld);
                }
                this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
                List list = dropdownValuesList.stream().map(s -> this.settingsDimension.getMultiworldName((String)s)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
                if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                    list.add("\u00a78" + I18n.m_118938_((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
                }
                GuiDropDown createdDropdown = new GuiDropDown(list.toArray(new String[0]), field_230708_k_ / 2 - 100, 30, 200, n, false, (dd, i) -> {
                    if (i < this.mwDropdownValues.length) {
                        this.mapProcessor.setMultiworld(this.settingsDimension, this.mwDropdownValues[i]);
                        this.updateButtons();
                        return true;
                    }
                    field_230706_i_.m_91152_((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, null));
                    return false;
                }, true);
                dropdowns.add(createdDropdown);
                this.multiworldTypeOptionButton = new TooltipButton(0, field_230709_l_ - 45, 150, 20, (Component)new TextComponent(this.getMultiworldTypeButtonMessage()), b -> {
                    if (this.isMapSelectionOptionEnabled()) {
                        this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                        b.m_93666_((Component)new TextComponent(this.getMultiworldTypeButtonMessage()));
                    }
                }, this.settingsDimension.isFutureMultiworldServerBased() ? this.serverSelectionModeBox : this.mapSelectionBox);
                mapScreen.addButton(this.multiworldTypeOptionButton);
                this.renameButton = new Button(field_230708_k_ / 2 + 109, 26, 60, 20, (Component)new TranslatableComponent("gui.xaero_rename"), b -> field_230706_i_.m_91152_((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced())));
                mapScreen.addButton(this.renameButton);
                this.deleteButton = new Button(field_230708_k_ / 2 - 168, 26, 60, 20, (Component)new TranslatableComponent("gui.xaero_delete"), b -> {
                    if (this.settingsDimension.getFutureCustomSelectedMultiworld() != null) {
                        String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                        field_230706_i_.m_91152_((Screen)new ConfirmScreen(result -> {
                            if (result) {
                                String mapNameAndIdLine = I18n.m_118938_((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                field_230706_i_.m_91152_((Screen)new ConfirmScreen(result2 -> {
                                    if (result2) {
                                        Object object = this.mapProcessor.uiSync;
                                        synchronized (object) {
                                            if (this.mapProcessor.getMapWorld() == this.settingsDimension.getMapWorld()) {
                                                MapDimension currentDimension;
                                                MapDimension mapDimension = currentDimension = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
                                                if (this.settingsDimension == currentDimension && this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                    if (WorldMap.settings.debug) {
                                                        WorldMap.LOGGER.info("Delayed map deletion!");
                                                    }
                                                    this.mapProcessor.requestCurrentMapDeletion();
                                                } else {
                                                    if (WorldMap.settings.debug) {
                                                        WorldMap.LOGGER.info("Instant map deletion!");
                                                    }
                                                    this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                }
                                                this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                this.settingsDimension.saveConfigUnsynced();
                                                this.settingsDimension.futureMultiworldWritable = false;
                                                mapScreen.m_6575_(field_230706_i_, field_230708_k_, field_230709_l_);
                                            }
                                        }
                                    }
                                    field_230706_i_.m_91152_((Screen)mapScreen);
                                }, (Component)new TranslatableComponent("gui.xaero_delete_map_msg3"), (Component)new TextComponent(mapNameAndIdLine)));
                            } else {
                                field_230706_i_.m_91152_((Screen)mapScreen);
                            }
                        }, (Component)new TranslatableComponent("gui.xaero_delete_map_msg1"), (Component)new TranslatableComponent("gui.xaero_delete_map_msg2")));
                    }
                });
                mapScreen.addButton(this.deleteButton);
                this.updateButtons();
                this.multiworldTypeOptionButton.f_93623_ = this.isMapSelectionOptionEnabled();
                this.renameButton.f_93623_ = this.settingsDimension.getMapWorld().isMultiplayer();
                mapScreen.addButton(new Button(field_230708_k_ / 2 - 50, 50, 100, 20, (Component)new TranslatableComponent("gui.xaero_confirm"), b -> this.confirm(mapScreen, field_230706_i_, field_230708_k_, field_230709_l_)));
            }
        }
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private void updateButtons() {
        this.switchingButton.f_93623_ = this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
        this.deleteButton.f_93623_ = this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.m_118938_((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.m_6575_(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    public void preMapRender(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        MapDimension currentDim;
        MapDimension mapDimension = currentDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
        if (currentDim != this.settingsDimension) {
            this.active = false;
            mapScreen.m_6575_(minecraft, width, height);
        }
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.m_6575_(minecraft, width, height);
        }
        if (this.active && this.settingsDimension != null && dropdowns.get(0).isClosed() && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[dropdowns.get(0).getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.m_6575_(minecraft, width, height);
        }
    }

    public void renderText(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.m_118938_((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        minecraft.f_91062_.m_92750_(matrixStack, selectMapString, (float)(width / 2 - minecraft.f_91062_.m_92895_(selectMapString) / 2), 19.0f, -1);
    }

    public void postMapRender(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }
}

