/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.m_91087_();
    private int deathSymbolTexture;
    private Map<String, Integer> charSymbols = new HashMap<String, Integer>();
    private ImprovedFramebuffer symbolFramebuffer32;
    private ImprovedFramebuffer symbolFramebuffer64;
    private PoseStack matrixStack = new PoseStack();

    public int getDeathSymbolTexture() {
        if (this.deathSymbolTexture == 0) {
            this.createDeathSymbolTexture();
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture() {
        this.deathSymbolTexture = this.createCharSymbol(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSymbolTexture(String c) {
        Integer textureId;
        Map<String, Integer> map = this.charSymbols;
        synchronized (map) {
            textureId = this.charSymbols.get(c);
        }
        if (textureId == null) {
            textureId = this.createCharSymbol(false, c);
        }
        return textureId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createCharSymbol(boolean death, String c) {
        if (this.symbolFramebuffer32 == null) {
            this.symbolFramebuffer32 = new ImprovedFramebuffer(32, 32, false);
        }
        if (this.symbolFramebuffer64 == null) {
            this.symbolFramebuffer64 = new ImprovedFramebuffer(64, 32, false);
        }
        int frameWidth = 32;
        if (this.mc.f_91062_.m_92895_(c) / 2 > 4) {
            frameWidth = 64;
        }
        ImprovedFramebuffer symbolFramebuffer = frameWidth == 32 ? this.symbolFramebuffer32 : this.symbolFramebuffer64;
        int textureId = GlStateManager.m_84111_();
        GlStateManager.m_84544_((int)textureId);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)frameWidth, (int)32, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        symbolFramebuffer.m_83947_(true);
        symbolFramebuffer.f_83923_ = textureId;
        ImprovedFramebuffer.framebufferTexture2D(symbolFramebuffer.getType(), 36160, 36064, 3553, textureId, 0);
        symbolFramebuffer.m_83963_();
        symbolFramebuffer.m_83947_(true);
        RenderSystem.m_69424_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.m_69421_((int)16384, (boolean)Minecraft.f_91002_);
        Matrix4f ortho = Matrix4f.m_162203_((float)0.0f, (float)frameWidth, (float)0.0f, (float)32.0f, (float)-1.0f, (float)1000.0f);
        RenderSystem.m_157425_((Matrix4f)ortho);
        PoseStack shaderMatrixStack = RenderSystem.m_157191_();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.m_157182_();
        PoseStack matrixStack = this.matrixStack;
        matrixStack.m_85836_();
        matrixStack.m_85837_(1.0, 1.0, 0.0);
        if (!death) {
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            this.mc.f_91062_.m_92750_(matrixStack, c, 0.0f, 0.0f, -1);
        } else {
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)minimapTextures);
            RenderSystem.m_157429_((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)1, (int)1, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.m_157429_((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)0, (int)0, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStack.m_85849_();
        Misc.minecraftOrtho(this.mc);
        shaderMatrixStack.m_85849_();
        RenderSystem.m_157182_();
        symbolFramebuffer.m_83970_();
        symbolFramebuffer.bindDefaultFramebuffer(this.mc);
        GlStateManager.m_84430_((int)0, (int)0, (int)this.mc.m_91268_().m_85441_(), (int)this.mc.m_91268_().m_85442_());
        if (death) {
            this.deathSymbolTexture = textureId;
        } else {
            Map<String, Integer> map = this.charSymbols;
            synchronized (map) {
                this.charSymbols.put(c, textureId);
            }
        }
        return textureId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, Integer> map = this.charSymbols;
        synchronized (map) {
            Collection<Integer> valueSet = this.charSymbols.values();
            for (Integer textureId : valueSet) {
                WorldMap.glObjectDeleter.requestTextureDeletion(textureId);
            }
            this.charSymbols.clear();
        }
    }
}

