/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.exception.OpenGLException;
import xaero.map.file.IOHelper;
import xaero.map.graphics.PixelBuffers;
import xaero.map.graphics.TextureUploader;
import xaero.map.misc.ConsistentBitArray;
import xaero.map.region.LeveledRegion;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.BranchTextureRenderer;

public abstract class RegionTexture<T extends RegionTexture<T>> {
    public static final int PBO_UNPACK_LENGTH = 16384;
    public static final int PBO_PACK_LENGTH = 16384;
    private static final ThreadLocal<ConsistentBitArray> OLD_HEIGHT_VALUES_SUPPORT = ThreadLocal.withInitial(() -> new ConsistentBitArray(9, 4096));
    protected int textureVersion;
    protected int glColorTexture = -1;
    protected boolean textureHasLight;
    protected ByteBuffer colorBuffer;
    protected boolean bufferHasLight;
    protected int colorBufferFormat = -1;
    protected boolean colorBufferCompressed;
    protected int bufferedTextureVersion;
    protected int packPbo;
    protected int[] unpackPbo = new int[2];
    protected boolean shouldDownloadFromPBO;
    protected int timer;
    private boolean cachePrepared;
    protected boolean toUpload;
    protected LeveledRegion<T> region;
    protected ConsistentBitArray heightValues;
    protected ConsistentBitArray topHeightValues;

    public RegionTexture(LeveledRegion<T> region) {
        this.region = region;
        this.textureVersion = -1;
        this.bufferedTextureVersion = -1;
        this.heightValues = new ConsistentBitArray(13, 4096);
        this.topHeightValues = new ConsistentBitArray(13, 4096);
    }

    private void setupTextureParameters() {
        GL11.glTexParameteri((int)3553, (int)33084, (int)0);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)1.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    public void prepareBuffer() {
        if (this.colorBuffer != null) {
            this.colorBuffer.clear();
            BufferUtils.zeroBuffer((ByteBuffer)this.colorBuffer);
        } else {
            this.colorBuffer = this.createBuffer();
        }
    }

    public int bindColorTexture(boolean create, int magFilter) {
        boolean result = false;
        int texture = this.glColorTexture;
        if (texture == -1) {
            if (create) {
                texture = this.glColorTexture = GlStateManager.m_84111_();
                result = true;
            } else {
                return -1;
            }
        }
        GlStateManager.m_84544_((int)texture);
        if (result) {
            this.setupTextureParameters();
        }
        GlStateManager.m_84331_((int)3553, (int)10240, (int)magFilter);
        RenderSystem.m_157453_((int)0, (int)texture);
        return texture;
    }

    public long uploadBuffer(TextureUploader textureUploader, LeveledRegion<T> inRegion, BranchTextureRenderer branchTextureRenderer, int x, int y) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        long result = this.uploadBufferHelper(textureUploader, inRegion, branchTextureRenderer);
        if (!this.shouldDownloadFromPBO()) {
            this.setToUpload(false);
            if (this.getColorBufferFormat() == -1) {
                this.deleteBuffers();
            } else {
                this.setCachePrepared(true);
            }
        }
        return result;
    }

    private long uploadBufferHelper(TextureUploader textureUploader, LeveledRegion<T> inRegion, BranchTextureRenderer branchTextureRenderer) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        if (this.colorBufferFormat != -1) {
            int length = this.colorBuffer.remaining();
            this.writeToUnpackPBO(0, this.colorBuffer);
            this.updateTextureVersion(this.bufferedTextureVersion);
            boolean isCompressed = this.colorBufferCompressed;
            int internalFormat = this.colorBufferFormat;
            this.textureHasLight = this.bufferHasLight;
            this.colorBufferCompressed = false;
            this.colorBufferFormat = -1;
            this.bufferedTextureVersion = -1;
            this.bindColorTexture(true, 9728);
            OpenGLException.checkGLError();
            long totalEstimatedTime = 0L;
            totalEstimatedTime = isCompressed ? textureUploader.requestCompressed(this.glColorTexture, this.unpackPbo[0], 3553, 0, internalFormat, 64, 64, 0, 0L, length) : textureUploader.requestNormal(this.glColorTexture, this.unpackPbo[0], 3553, 0, internalFormat, 64, 64, 0, 0L, 32993, 32821);
            this.onCacheUpload();
            return totalEstimatedTime;
        }
        if (!this.shouldDownloadFromPBO) {
            return this.uploadNonCache(textureUploader, branchTextureRenderer);
        }
        int glTexture = this.glColorTexture;
        GlStateManager.m_84544_((int)glTexture);
        int isCompressed = 0;
        this.bindPackPBO();
        ByteBuffer mappedPBO = PixelBuffers.glMapBuffer(35051, 35000);
        OpenGLException.checkGLError();
        this.onDownloadedBuffer(mappedPBO, isCompressed);
        PixelBuffers.glUnmapBuffer(35051);
        OpenGLException.checkGLError();
        this.unbindPackPBO();
        OpenGLException.checkGLError();
        int format = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        OpenGLException.checkGLError();
        this.bufferHasLight = this.textureHasLight;
        this.colorBufferFormat = format;
        if (format == -1) {
            throw new RuntimeException("Invalid texture internal format returned by the driver.");
        }
        this.colorBufferCompressed = isCompressed == 1;
        this.shouldDownloadFromPBO = false;
        this.bufferedTextureVersion = this.textureVersion;
        return 0L;
    }

    protected abstract void onDownloadedBuffer(ByteBuffer var1, int var2);

    protected void bindPackPBO() {
        boolean created = false;
        if (this.packPbo == 0) {
            this.packPbo = PixelBuffers.glGenBuffers();
            created = true;
        }
        PixelBuffers.glBindBuffer(35051, this.packPbo);
        if (created) {
            PixelBuffers.glBufferData(35051, 16384L, 35041);
        }
    }

    private void bindUnpackPBO(int index) {
        boolean created = false;
        if (this.unpackPbo[index] == 0) {
            this.unpackPbo[index] = PixelBuffers.glGenBuffers();
            created = true;
        }
        PixelBuffers.glBindBuffer(35052, this.unpackPbo[index]);
        if (created) {
            PixelBuffers.glBufferData(35052, 16384L, 35040);
        }
    }

    protected void unbindPackPBO() {
        PixelBuffers.glBindBuffer(35051, 0);
    }

    private void unbindUnpackPBO() {
        PixelBuffers.glBindBuffer(35052, 0);
    }

    protected void writeToUnpackPBO(int pboIndex, ByteBuffer buffer) throws OpenGLException {
        this.bindUnpackPBO(pboIndex);
        ByteBuffer mappedPBO = PixelBuffers.glMapBuffer(35052, 35001);
        OpenGLException.checkGLError();
        mappedPBO.put(buffer);
        PixelBuffers.glUnmapBuffer(35052);
        this.unbindUnpackPBO();
    }

    public void deleteBuffers() {
        WorldMap.bufferDeallocator.deallocate(this.colorBuffer, WorldMap.settings.debug);
        this.colorBuffer = null;
        this.colorBufferFormat = -1;
        this.bufferedTextureVersion = -1;
    }

    public void deletePBOs() {
        if (this.packPbo > 0) {
            WorldMap.glObjectDeleter.requestBufferToDelete(this.packPbo);
        }
        this.packPbo = 0;
        for (int i = 0; i < this.unpackPbo.length; ++i) {
            if (this.unpackPbo[i] <= 0) continue;
            WorldMap.glObjectDeleter.requestBufferToDelete(this.unpackPbo[i]);
            this.unpackPbo[i] = 0;
        }
    }

    public void writeCacheMapData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<T> inRegion) throws IOException {
        output.write(this.colorBufferCompressed ? 1 : 0);
        output.writeInt(this.colorBufferFormat);
        int length = this.colorBuffer.remaining();
        output.writeInt(length);
        this.colorBuffer.get(usableBuffer, 0, length);
        this.colorBuffer.position(0);
        output.write(usableBuffer, 0, length);
        output.writeBoolean(this.bufferHasLight);
        long[] heightData = this.heightValues.getData();
        for (int i = 0; i < heightData.length; ++i) {
            output.writeLong(heightData[i]);
        }
        long[] topHeightData = this.topHeightValues.getData();
        for (int i = 0; i < topHeightData.length; ++i) {
            output.writeLong(topHeightData[i]);
        }
    }

    public void readCacheData(int minorSaveVersion, int majorSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<T> inRegion, MapProcessor mapProcessor, int x, int y) throws IOException {
        this.bufferedTextureVersion = minorSaveVersion < 7 || minorSaveVersion >= 9 && minorSaveVersion <= 11 ? 1 : inRegion.getCachedTextureVersions(x, y);
        if (minorSaveVersion == 6) {
            input.readInt();
        }
        int lightLevelsInCache = minorSaveVersion < 3 ? 4 : 1;
        for (int i = 0; i < lightLevelsInCache; ++i) {
            if (i == 0) {
                this.colorBufferCompressed = true;
                if (minorSaveVersion > 1) {
                    this.colorBufferCompressed = input.read() == 1;
                }
                this.colorBufferFormat = input.readInt();
            } else {
                if (minorSaveVersion > 1) {
                    input.read();
                }
                input.readInt();
            }
            int length = input.readInt();
            IOHelper.readToBuffer(usableBuffer, length, input);
            if (i != 0) continue;
            if (this.colorBuffer == null) {
                this.colorBuffer = this.createBuffer();
            }
            if (inRegion.getLevel() == 0 && length == 16384 && this.colorBufferCompressed) {
                this.colorBufferCompressed = false;
                this.colorBufferFormat = 32856;
                inRegion.setShouldCache(true, "broken texture compression fix");
                this.colorBuffer.clear();
                this.colorBuffer.limit(16384);
                continue;
            }
            this.colorBuffer.put(usableBuffer, 0, length);
            this.colorBuffer.flip();
        }
        if (minorSaveVersion >= 14) {
            this.bufferHasLight = input.readBoolean();
        } else if (minorSaveVersion > 2) {
            int lightLength = input.readInt();
            if (lightLength > 0) {
                IOHelper.readToBuffer(usableBuffer, lightLength, input);
            }
            this.bufferHasLight = false;
        }
        if (minorSaveVersion >= 13) {
            int i;
            long[] heightData = new long[majorSaveVersion == 0 ? 586 : 1024];
            for (int i2 = 0; i2 < heightData.length; ++i2) {
                heightData[i2] = input.readLong();
            }
            if (majorSaveVersion == 0) {
                ConsistentBitArray oldHeightArray = OLD_HEIGHT_VALUES_SUPPORT.get();
                oldHeightArray.setData(heightData);
                for (i = 0; i < 4096; ++i) {
                    int oldValue = oldHeightArray.get(i);
                    if (oldValue >> 8 == 0) continue;
                    this.putHeight(i, oldValue & 0xFF);
                }
            } else {
                this.heightValues.setData(heightData);
            }
            if (minorSaveVersion >= 17) {
                long[] topHeightData = new long[majorSaveVersion == 0 ? 586 : 1024];
                for (i = 0; i < topHeightData.length; ++i) {
                    topHeightData[i] = input.readLong();
                }
                if (majorSaveVersion == 0) {
                    ConsistentBitArray oldHeightArray = OLD_HEIGHT_VALUES_SUPPORT.get();
                    oldHeightArray.setData(topHeightData);
                    for (int i3 = 0; i3 < 4096; ++i3) {
                        int oldValue = oldHeightArray.get(i3);
                        if (oldValue >> 8 == 0) continue;
                        this.putTopHeight(i3, oldValue & 0xFF);
                    }
                } else {
                    this.topHeightValues.setData(topHeightData);
                }
            } else {
                long[] copyFrom = this.heightValues.getData();
                long[] topHeightData = new long[this.topHeightValues.getData().length];
                System.arraycopy(copyFrom, 0, topHeightData, 0, copyFrom.length);
                this.topHeightValues.setData(topHeightData);
            }
            if (minorSaveVersion == 16) {
                for (int i4 = 0; i4 < 64; ++i4) {
                    input.readLong();
                }
            }
        }
        this.toUpload = true;
    }

    public ByteBuffer createBuffer() {
        return BufferUtils.createByteBuffer((int)16384);
    }

    public void deleteTexturesAndBuffers() {
        int textureToDelete = this.getGlColorTexture();
        this.glColorTexture = -1;
        if (textureToDelete != -1) {
            WorldMap.glObjectDeleter.requestTextureDeletion(textureToDelete);
        }
        this.onTextureDeletion();
        if (this.getColorBuffer() != null) {
            this.deleteBuffers();
        }
        this.deletePBOs();
    }

    public ByteBuffer getColorBuffer() {
        return this.colorBuffer;
    }

    public void setShouldDownloadFromPBO(boolean shouldDownloadFromPBO) {
        this.shouldDownloadFromPBO = shouldDownloadFromPBO;
    }

    public int getColorBufferFormat() {
        return this.colorBufferFormat;
    }

    public boolean isColorBufferCompressed() {
        return this.colorBufferCompressed;
    }

    public boolean shouldDownloadFromPBO() {
        return this.shouldDownloadFromPBO;
    }

    public int getTimer() {
        return this.timer;
    }

    public void decTimer() {
        --this.timer;
    }

    public void resetTimer() {
        this.timer = 0;
    }

    public final int getGlColorTexture() {
        return this.glColorTexture;
    }

    public void onTextureDeletion() {
        this.updateTextureVersion(0);
    }

    public boolean shouldUpload() {
        return this.toUpload;
    }

    public void setToUpload(boolean value) {
        this.toUpload = value;
    }

    public boolean isCachePrepared() {
        return this.cachePrepared;
    }

    public void setCachePrepared(boolean cachePrepared) {
        this.cachePrepared = cachePrepared;
    }

    public boolean canUpload() {
        return true;
    }

    public boolean isUploaded() {
        return !this.shouldUpload();
    }

    public int getTextureVersion() {
        return this.textureVersion;
    }

    public int getBufferedTextureVersion() {
        return this.bufferedTextureVersion;
    }

    public LeveledRegion<T> getRegion() {
        return this.region;
    }

    protected void updateTextureVersion(int newVersion) {
        this.textureVersion = newVersion;
    }

    public int getHeight(int x, int z) {
        int index = (z << 6) + x;
        int value = this.heightValues.get(index);
        if (value >> 12 == 0) {
            return Short.MAX_VALUE;
        }
        return (value & 0xFFF) << 20 >> 20;
    }

    public void putHeight(int x, int z, int height) {
        int index = (z << 6) + x;
        this.putHeight(index, height);
    }

    public void putHeight(int index, int height) {
        int value = 0x1000 | height & 0xFFF;
        this.heightValues.set(index, value);
    }

    public void removeHeight(int x, int z) {
        int index = (z << 6) + x;
        this.heightValues.set(index, 0);
    }

    public int getTopHeight(int x, int z) {
        int index = (z << 6) + x;
        int value = this.topHeightValues.get(index);
        if (value >> 12 == 0) {
            return Short.MAX_VALUE;
        }
        return (value & 0xFFF) << 20 >> 20;
    }

    public void putTopHeight(int x, int z, int height) {
        int index = (z << 6) + x;
        this.putTopHeight(index, height);
    }

    public void putTopHeight(int index, int height) {
        int value = 0x1000 | height & 0xFFF;
        this.topHeightValues.set(index, value);
    }

    public void removeTopHeight(int x, int z) {
        int index = (z << 6) + x;
        this.topHeightValues.set(index, 0);
    }

    public boolean getTextureHasLight() {
        return this.textureHasLight;
    }

    public void addDebugLines(List<String> debugLines) {
        debugLines.add("shouldUpload: " + this.shouldUpload() + " timer: " + this.getTimer());
        debugLines.add(String.format("buffer exists: %s", this.getColorBuffer() != null));
        debugLines.add("glColorTexture: " + this.getGlColorTexture() + " textureHasLight: " + this.textureHasLight);
        debugLines.add("cachePrepared: " + this.isCachePrepared());
        debugLines.add("textureVersion: " + this.textureVersion);
        debugLines.add("colorBufferFormat: " + this.colorBufferFormat);
    }

    protected void onCacheUpload() {
    }

    public boolean shouldBeUsedForBranchUpdate(int usedVersion) {
        return (this.shouldHaveContentForBranchUpdate() ? this.textureVersion : 0) != usedVersion;
    }

    public boolean shouldHaveContentForBranchUpdate() {
        return true;
    }

    public abstract boolean hasSourceData();

    public abstract void preUpload(MapProcessor var1, BlockTintProvider var2, OverlayManager var3, LeveledRegion<T> var4, boolean var5, BlockStateShortShapeCache var6);

    public abstract void postUpload(MapProcessor var1, LeveledRegion<T> var2, boolean var3);

    protected abstract long uploadNonCache(TextureUploader var1, BranchTextureRenderer var2);
}

