/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.config;

import com.ezrol.terry.lib.huffstruct.Huffstruct;
import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.SettingsRoot;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.UuidTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.UUID;

public class ConfigurationFile {
    private byte[] currentData;
    private File location;
    private SettingsRoot settings;

    public ConfigurationFile(File loc) {
        this.location = loc;
        this.settings = null;
    }

    public static boolean safeFileName(String n) {
        return n.matches("[a-z0-9_]*");
    }

    public void restoreSettings() {
        if (this.currentData == null) {
            this.settings = new SettingsRoot(null);
            this.writeToDisk();
        } else {
            try {
                this.settings = new SettingsRoot(Huffstruct.loadData(this.currentData));
                for (WorldTypeNode n : this.settings.getWorldList()) {
                    for (String data : ((StringListTypeNode)n.getField(WorldTypeNode.Fields.DATA_PACKS)).getValue()) {
                        File datadir;
                        if (!ConfigurationFile.safeFileName(data) || (datadir = new File(DefaultWorldGenerator.modSettingsDir, data)).exists()) continue;
                        datadir.mkdir();
                    }
                }
            }
            catch (Exception e) {
                Log.error("Error parsing config: " + e);
                Log.info("using internal configuration");
                this.settings = new SettingsRoot(null);
                this.writeToDisk();
            }
        }
    }

    public void readFromDisk() {
        this.currentData = null;
        try {
            if (this.location != null && this.location.exists()) {
                this.currentData = Files.readAllBytes(this.location.toPath());
            } else {
                Log.info("Config file not found, using internal defaults (" + (this.location == null ? "NULL" : this.location.toString()) + ")");
            }
            this.restoreSettings();
        }
        catch (IOException e) {
            Log.error("Unable to read file: " + this.location.toString());
            Log.error("Assuming config file is blank");
            this.restoreSettings();
            this.writeToDisk();
        }
    }

    public SettingsRoot getSettings() {
        return this.settings;
    }

    public Optional<WorldTypeNode> lookupUUID(UUID id) {
        for (WorldTypeNode n : this.settings.getWorldList()) {
            if (!((UuidTypeNode)n.getField(WorldTypeNode.Fields.UUID)).getValue().equals(id)) continue;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    public void writeToDisk() {
        if (this.settings == null) {
            Log.error("Settings not generated yet");
        }
        byte[] tmp = Huffstruct.dumpData(this.settings);
        try {
            Files.write(this.location.toPath(), tmp, new OpenOption[0]);
            this.currentData = tmp;
            this.restoreSettings();
        }
        catch (IOException e) {
            Log.error("Unable to save configuration: " + e);
        }
    }
}

