/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.item;

import com.nekokittygames.mffs.api.IForceEnergyStorageBlock;
import com.nekokittygames.mffs.api.IPowerLinkItem;
import com.nekokittygames.mffs.api.PointXYZ;
import com.nekokittygames.mffs.common.Functions;
import com.nekokittygames.mffs.common.Linkgrid;
import com.nekokittygames.mffs.common.SecurityHelper;
import com.nekokittygames.mffs.common.SecurityRight;
import com.nekokittygames.mffs.common.item.ItemCard;
import com.nekokittygames.mffs.common.item.ModItems;
import com.nekokittygames.mffs.common.tileentity.TileEntityAreaDefenseStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityCapacitor;
import com.nekokittygames.mffs.common.tileentity.TileEntityExtractor;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import com.nekokittygames.mffs.common.tileentity.TileEntityProjector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardPowerLink
extends ItemCard
implements IPowerLinkItem {
    public IForceEnergyStorageBlock storage;

    public ItemCardPowerLink() {
        this.func_77655_b("modularforcefieldsystem.powerlink_card");
        this.setRegistryName("powerlink_card");
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
        if (this.Tick > 600) {
            TileEntityCapacitor cap;
            int Cap_ID = this.getValuefromKey("CapacitorID", itemStack);
            if (Cap_ID != 0 && (cap = Linkgrid.getWorldMap(world).getCapacitor().get(Cap_ID)) != null && !cap.getDeviceName().equals(ItemCard.getforAreaname(itemStack))) {
                ItemCard.setforArea(itemStack, cap.getDeviceName());
            }
            this.Tick = 0;
        }
        ++this.Tick;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (tileEntity instanceof TileEntityProjector && SecurityHelper.isAccessGranted(tileEntity, player, world, SecurityRight.EB)) {
                return Functions.setIteminSlot(stack, player, tileEntity, 0, "<Power-Link>") ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            if (tileEntity instanceof TileEntityExtractor && SecurityHelper.isAccessGranted(tileEntity, player, world, SecurityRight.EB)) {
                if (((TileEntityExtractor)tileEntity).func_70301_a(1).func_190926_b()) {
                    ((TileEntityExtractor)tileEntity).func_70299_a(1, stack.func_77946_l());
                    ((ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c)).func_190920_e(0);
                    Functions.ChattoPlayer(player, "linkCard.installed", new Object[0]);
                    return EnumActionResult.SUCCESS;
                }
                if (((TileEntityExtractor)tileEntity).func_70301_a(1).func_77973_b() == ModItems.EMPTY_CARD) {
                    ItemStack itemstackcopy = stack.func_77946_l();
                    ((TileEntityExtractor)tileEntity).func_70299_a(1, itemstackcopy);
                    Functions.ChattoPlayer(player, "linkCard.copied", new Object[0]);
                    return EnumActionResult.SUCCESS;
                }
                Functions.ChattoPlayer(player, "linkCard.notEmpty", new Object[0]);
                return EnumActionResult.FAIL;
            }
            if (tileEntity instanceof TileEntityAreaDefenseStation && SecurityHelper.isAccessGranted(tileEntity, player, world, SecurityRight.EB)) {
                return Functions.setIteminSlot(stack, player, tileEntity, 0, "<Power-Link>") ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            if (tileEntity instanceof TileEntityCapacitor && SecurityHelper.isAccessGranted(tileEntity, player, world, SecurityRight.EB)) {
                return Functions.setIteminSlot(stack, player, tileEntity, 2, "<Power-Link>") ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    public IForceEnergyStorageBlock getForceEnergyStorageBlock(ItemStack itemStack, TileEntityMachines tem, World world) {
        PointXYZ png;
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemCard && ((ItemCard)itemStack.func_77973_b()).isvalid(itemStack) && (png = this.getCardTargetPoint(itemStack)) != null) {
            if (png.dimensionId != world.field_73011_w.getDimension()) {
                return null;
            }
            if (world.func_175625_s(png.pos) instanceof TileEntityCapacitor) {
                TileEntityCapacitor cap = (TileEntityCapacitor)world.func_175625_s(png.pos);
                if (cap != null && cap.getPowerStorageID() == this.getValuefromKey("CapacitorID", itemStack) && this.getValuefromKey("CapacitorID", itemStack) != 0) {
                    if (!cap.getDeviceName().equals(ItemCard.getforAreaname(itemStack))) {
                        ItemCard.setforArea(itemStack, cap.getDeviceName());
                    }
                    if ((double)cap.getTransmitRange() >= PointXYZ.distance(tem.getMaschinePoint(), cap.getMaschinePoint())) {
                        return cap;
                    }
                    return null;
                }
            } else {
                TileEntityCapacitor cap;
                int Cap_ID = this.getValuefromKey("CapacitorID", itemStack);
                if (Cap_ID != 0 && (cap = Linkgrid.getWorldMap(png.getPointWorld()).getCapacitor().get(Cap_ID)) != null) {
                    this.setInformation(itemStack, cap.getMaschinePoint(), "CapacitorID", Cap_ID);
                    if ((double)cap.getTransmitRange() >= PointXYZ.distance(tem.getMaschinePoint(), cap.getMaschinePoint())) {
                        return cap;
                    }
                    return null;
                }
            }
            if (world.func_175726_f(png.pos).func_177410_o()) {
                ((ItemCard)itemStack.func_77973_b()).setinvalid(itemStack);
            }
        }
        return null;
    }

    @Override
    public int getAvailablePower(ItemStack itemStack, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.getStorageAvailablePower();
        }
        return 0;
    }

    @Override
    public int getMaximumPower(ItemStack itemStack, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.getStorageMaxPower();
        }
        return 1;
    }

    @Override
    public int getPowersourceID(ItemStack itemStack, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.getPowerStorageID();
        }
        return 0;
    }

    @Override
    public int getPercentageCapacity(ItemStack itemStack, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.getPercentageStorageCapacity();
        }
        return 0;
    }

    @Override
    public boolean consumePower(ItemStack itemStack, int powerAmount, boolean simulation, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.consumePowerfromStorage(powerAmount, simulation);
        }
        return false;
    }

    @Override
    public boolean insertPower(ItemStack itemStack, int powerAmount, boolean simulation, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.insertPowertoStorage(powerAmount, simulation);
        }
        return false;
    }

    @Override
    public int getfreeStorageAmount(ItemStack itemStack, TileEntityMachines tem, World world) {
        this.storage = this.getForceEnergyStorageBlock(itemStack, tem, world);
        if (this.storage != null) {
            return this.storage.getfreeStorageAmount();
        }
        return 0;
    }

    @Override
    public boolean isPowersourceItem() {
        return false;
    }
}

