/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.tileentity;

import com.nekokittygames.mffs.api.PointXYZ;
import com.nekokittygames.mffs.common.Linkgrid;
import com.nekokittygames.mffs.common.MFFSMaschines;
import com.nekokittygames.mffs.common.ModularForceFieldSystem;
import com.nekokittygames.mffs.common.NBTTagCompoundHelper;
import com.nekokittygames.mffs.common.container.ContainerControlSystem;
import com.nekokittygames.mffs.common.item.ItemCardDataLink;
import com.nekokittygames.mffs.common.item.ItemCardSecurityLink;
import com.nekokittygames.mffs.common.item.ModItems;
import com.nekokittygames.mffs.common.tileentity.TileEntityAdvSecurityStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityControlSystem
extends TileEntityMachines
implements ISidedInventory {
    public static int MACHINE_RANGE = 192;
    private TileEntityMachines remote = null;
    protected String RemoteDeviceName = "";
    protected String RemoteDeviceTyp = "";
    protected boolean RemoteActive = false;
    protected boolean RemoteSwitchValue = false;
    protected short RemoteSwitchModi = 0;
    protected boolean RemoteSecurityStationlink = false;
    protected boolean RemotehasPowersource = false;
    protected boolean RemoteGUIinRange = false;
    protected int RemotePowerleft = 0;

    public TileEntityControlSystem() {
        super(40);
    }

    @Override
    public List<String> getFieldsforUpdate() {
        LinkedList<String> NetworkedFields = new LinkedList<String>();
        NetworkedFields.clear();
        NetworkedFields.addAll(super.getFieldsforUpdate());
        NetworkedFields.add("RemoteDeviceName");
        NetworkedFields.add("RemoteDeviceTyp");
        NetworkedFields.add("RemoteActive");
        NetworkedFields.add("RemoteSwitchModi");
        NetworkedFields.add("RemoteSwitchValue");
        NetworkedFields.add("RemoteSecurityStationlink");
        NetworkedFields.add("RemotehasPowersource");
        NetworkedFields.add("RemotePowerleft");
        NetworkedFields.add("RemoteGUIinRange");
        return NetworkedFields;
    }

    @Override
    public void func_145843_s() {
        Linkgrid.getWorldMap(this.field_145850_b).getControlSystem().remove(this.getDeviceID());
        super.func_145843_s();
    }

    @Override
    public void dropPlugins() {
        for (int a = 0; a < this.inventory.size(); ++a) {
            this.dropPlugins(a);
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getTicker() == 20) {
                if (this.getLinkedSecurityStation() != null && !this.isActive()) {
                    this.setActive(true);
                }
                if (this.getLinkedSecurityStation() == null && this.isActive()) {
                    this.setActive(false);
                }
                this.refreshRemoteData();
                this.setTicker((short)0);
            }
            this.setTicker((short)(this.getTicker() + 1));
        }
        super.func_73660_a();
    }

    public TileEntityMachines getRemote() {
        return this.remote;
    }

    @Override
    public Container getContainer(InventoryPlayer inventoryplayer) {
        return new ContainerControlSystem(inventoryplayer.field_70458_d, this);
    }

    @Override
    public TileEntityAdvSecurityStation getLinkedSecurityStation() {
        return ItemCardSecurityLink.getLinkedSecurityStation(this, 0, this.field_145850_b);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public String func_70005_c_() {
        return "ControlSystem";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int getSlotStackLimit(int slt) {
        return 1;
    }

    @Override
    public boolean isItemValid(ItemStack par1ItemStack, int Slot2) {
        switch (Slot2) {
            case 0: {
                if (!(par1ItemStack.func_77973_b() instanceof ItemCardSecurityLink)) break;
                return true;
            }
        }
        return par1ItemStack.func_77973_b() instanceof ItemCardDataLink;
    }

    @Override
    public void onNetworkHandlerEvent(int key, String value) {
        EntityPlayer player;
        if (key == 103 && this.remote != null && this.getRemoteGUIinRange() && (player = this.field_145850_b.func_72924_a(value)) != null) {
            player.openGui((Object)ModularForceFieldSystem.instance, 0, this.field_145850_b, this.remote.func_174877_v().func_177958_n(), this.remote.func_174877_v().func_177956_o(), this.remote.func_174877_v().func_177952_p());
        }
        if (key == 102 && this.remote != null) {
            this.remote.toggelSwitchValue();
        }
        if (key == 101 && this.remote != null) {
            this.remote.toogleSwitchModi();
        }
        super.onNetworkHandlerEvent(key, value);
    }

    private void refreshRemoteData() {
        this.refreshRemoteData(1);
    }

    private void refreshRemoteData(int slot) {
        this.remote = this.getTargetMaschine(slot);
        if (this.remote != null) {
            if (!this.remote.isActive() == this.getRemoteActive()) {
                this.setRemoteActive(this.remote.isActive());
            }
            if (!this.remote.getDeviceName().equalsIgnoreCase(this.getRemoteDeviceName())) {
                this.setRemoteDeviceName(this.remote.getDeviceName());
            }
            if (this.remote.getSwitchModi() != this.getRemoteSwitchModi()) {
                this.setRemoteSwitchModi(this.remote.getSwitchModi());
            }
            if (!this.remote.getSwitchValue() == this.getRemoteSwitchValue()) {
                this.setRemoteSwitchValue(this.remote.getSwitchValue());
            }
            if (this.remote.getLinkedSecurityStation() == null) {
                this.setRemoteSecurityStationlink(false);
            } else {
                this.setRemoteSecurityStationlink(true);
            }
            if (!this.remote.hasPowerSource() == this.getRemotehasPowersource()) {
                this.setRemotehasPowersource(this.remote.hasPowerSource());
            }
            if (this.remote.getPercentageCapacity() != this.getRemotePowerleft()) {
                this.setRemotePowerleft(this.remote.getPercentageCapacity());
            }
            if (!MFFSMaschines.fromTE((TileEntity)this.remote).displayName.equalsIgnoreCase(this.getRemoteDeviceTyp())) {
                this.setRemoteDeviceTyp(MFFSMaschines.fromTE((TileEntity)this.remote).displayName);
            }
            if (PointXYZ.distance(this.getMaschinePoint(), this.remote.getMaschinePoint()) > (double)MACHINE_RANGE && this.getRemoteGUIinRange()) {
                this.setRemoteGUIinRange(false);
            }
            if (PointXYZ.distance(this.getMaschinePoint(), this.remote.getMaschinePoint()) <= (double)MACHINE_RANGE && !this.getRemoteGUIinRange()) {
                this.setRemoteGUIinRange(true);
            }
        } else {
            if (this.getRemoteActive()) {
                this.setRemoteActive(false);
            }
            if (this.getRemoteSwitchModi() != 0) {
                this.setRemoteSwitchModi((short)0);
            }
            if (!this.getRemoteDeviceName().equalsIgnoreCase("-")) {
                this.setRemoteDeviceName("-");
            }
            if (!this.getRemoteDeviceTyp().equalsIgnoreCase("-")) {
                this.setRemoteDeviceTyp("-");
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    private TileEntityMachines getTargetMaschine(int slot) {
        if (this.func_70301_a(slot) != null && this.func_70301_a(slot).func_77973_b() instanceof ItemCardDataLink) {
            TileEntityMachines device;
            int DeviceID = 0;
            NBTTagCompound tag = NBTTagCompoundHelper.getTAGfromItemstack(this.func_70301_a(slot));
            if (tag.func_74764_b("DeviceID")) {
                DeviceID = tag.func_74762_e("DeviceID");
            }
            if (DeviceID != 0 && (device = Linkgrid.getWorldMap(this.field_145850_b).getTileEntityMachines(ItemCardDataLink.getDeviceTyp(this.func_70301_a(slot)), DeviceID)) != null) {
                return device;
            }
            this.func_70299_a(slot, new ItemStack((Item)ModItems.EMPTY_CARD));
        }
        return null;
    }

    public boolean getRemoteGUIinRange() {
        return this.RemoteGUIinRange;
    }

    public void setRemoteGUIinRange(boolean b) {
        this.RemoteGUIinRange = b;
    }

    public int getRemotePowerleft() {
        return this.RemotePowerleft;
    }

    public void setRemotePowerleft(int i) {
        this.RemotePowerleft = i;
    }

    public boolean getRemotehasPowersource() {
        return this.RemotehasPowersource;
    }

    public void setRemotehasPowersource(boolean b) {
        this.RemotehasPowersource = b;
    }

    public boolean getRemoteSecurityStationlink() {
        return this.RemoteSecurityStationlink;
    }

    public void setRemoteSecurityStationlink(boolean b) {
        this.RemoteSecurityStationlink = b;
    }

    public boolean getRemoteSwitchValue() {
        return this.RemoteSwitchValue;
    }

    public void setRemoteSwitchValue(boolean b) {
        this.RemoteSwitchValue = b;
    }

    public short getRemoteSwitchModi() {
        return this.RemoteSwitchModi;
    }

    public void setRemoteSwitchModi(short s) {
        this.RemoteSwitchModi = s;
    }

    public boolean getRemoteActive() {
        return this.RemoteActive;
    }

    public void setRemoteActive(boolean b) {
        this.RemoteActive = b;
    }

    public String getRemoteDeviceTyp() {
        return this.RemoteDeviceTyp;
    }

    public void setRemoteDeviceTyp(String s) {
        this.RemoteDeviceTyp = s;
    }

    public String getRemoteDeviceName() {
        return this.RemoteDeviceName;
    }

    public void setRemoteDeviceName(String s) {
        this.RemoteDeviceName = s;
    }
}

