/*
 * Decompiled with CFR 0.152.
 */
package jobicade.hotswap;

import jobicade.hotswap.CommonProxy;
import jobicade.hotswap.HotSwap;
import jobicade.hotswap.InvTweaksSuppressor;
import jobicade.hotswap.ModifierKeyBinding;
import jobicade.hotswap.RegisterOrderKeyBinding;
import jobicade.hotswap.RotateMessage;
import jobicade.hotswap.SwapMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class ClientProxy
extends CommonProxy {
    private final KeyBinding rowDown = new RegisterOrderKeyBinding("key.hotswap.rotateRowDown", 35, "key.categories.hotswap");
    private final KeyBinding currentDown = new RegisterOrderKeyBinding("key.hotswap.rotateDown", 36, "key.categories.hotswap");
    private final KeyBinding currentUp = new RegisterOrderKeyBinding("key.hotswap.rotateUp", 37, "key.categories.hotswap");
    private final KeyBinding rowUp = new RegisterOrderKeyBinding("key.hotswap.rotateRowUp", 38, "key.categories.hotswap");
    private final ModifierKeyBinding currentScroll = new ModifierKeyBinding("key.hotswap.rotate", 56, "key.categories.hotswap", "hotswap.mouseWheel");
    private final ModifierKeyBinding rowScroll = new ModifierKeyBinding("key.hotswap.rotateRow", KeyModifier.CONTROL, 56, "key.categories.hotswap", "hotswap.mouseWheel");
    private final ModifierKeyBinding swap = new ModifierKeyBinding("key.hotswap.swap", 56, "key.categories.hotswap", "hotswap.slot");
    private InvTweaksSuppressor suppressor;

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rowDown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.currentDown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.currentUp);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rowUp);
        ClientRegistry.registerKeyBinding((KeyBinding)this.currentScroll);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rowScroll);
        ClientRegistry.registerKeyBinding((KeyBinding)this.swap);
        if (Loader.isModLoaded((String)"inventorytweaks")) {
            this.suppressor = new InvTweaksSuppressor();
            this.suppressor.init();
        }
    }

    @Override
    public void rotate(int rows, boolean wholeRow) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.trySuppressInvTweaks();
        if (HotSwap.rotateLocal((EntityPlayer)player, rows, wholeRow)) {
            HotSwap.NET_WRAPPER.sendToServer((IMessage)new RotateMessage(rows, wholeRow));
        }
    }

    @Override
    public void swap(int slot) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.trySuppressInvTweaks();
        if (HotSwap.swapLocal((EntityPlayer)player, slot)) {
            HotSwap.NET_WRAPPER.sendToServer((IMessage)new SwapMessage(slot));
        }
    }

    private void trySuppressInvTweaks() {
        if (this.suppressor != null) {
            this.suppressor.suppressInvTweaks();
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71415_G) {
            if (this.rowUp.func_151468_f()) {
                this.rotate(-1, true);
            } else if (this.rowDown.func_151468_f()) {
                this.rotate(1, true);
            } else if (this.currentUp.func_151468_f()) {
                this.rotate(-1, false);
            } else if (this.currentDown.func_151468_f()) {
                this.rotate(1, false);
            }
            if (this.swap.func_151470_d()) {
                KeyBinding[] keyBindsHotbar = Minecraft.func_71410_x().field_71474_y.field_151456_ac;
                for (int i = 0; i < keyBindsHotbar.length; ++i) {
                    if (!keyBindsHotbar[i].func_151468_f()) continue;
                    this.swap(i);
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        if (event.isCancelable() && !event.isCanceled() && event.getDwheel() != 0) {
            if (this.rowScroll.overrides(this.currentScroll)) {
                if (!this.tryScrollRow(event)) {
                    this.tryScrollCurrent(event);
                }
            } else if (!this.tryScrollCurrent(event)) {
                this.tryScrollRow(event);
            }
        }
    }

    private boolean tryScrollCurrent(MouseEvent event) {
        if (this.currentScroll.func_151470_d()) {
            this.rotate(Integer.signum(event.getDwheel()), false);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    private boolean tryScrollRow(MouseEvent event) {
        if (this.rowScroll.func_151470_d()) {
            this.rotate(Integer.signum(event.getDwheel()), true);
            event.setCanceled(true);
            return true;
        }
        return false;
    }
}

