/*
 * Decompiled with CFR 0.152.
 */
package jobicade.hotswap;

import java.util.AbstractList;
import java.util.List;

public class StepList<T>
extends AbstractList<T> {
    private final List<T> source;
    private final int offset;
    private final int step;

    public StepList(List<T> source, int offset, int step) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be negative");
        }
        if (step == 0) {
            throw new IllegalArgumentException("Step must be nonzero");
        }
        this.source = source;
        this.offset = offset;
        this.step = step;
    }

    @Override
    public T get(int index) {
        return this.source.get(this.offset + index * this.step);
    }

    @Override
    public T set(int index, T element) {
        return this.source.set(this.offset + index * this.step, element);
    }

    @Override
    public int size() {
        return Math.max(0, (this.source.size() - this.offset + this.step - 1) / this.step);
    }
}

