/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks;

import com.mordenkainen.equivalentenergistics.blocks.base.tile.TE;
import com.mordenkainen.equivalentenergistics.blocks.base.tile.TEList;
import com.mordenkainen.equivalentenergistics.blocks.condenser.BlockEMCCondenser;
import com.mordenkainen.equivalentenergistics.blocks.crafter.BlockEMCCrafter;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModBlocks {
    @GameRegistry.ObjectHolder(value="equivalentenergistics:emc_crafter")
    public static final BlockEMCCrafter CRAFTER = null;
    @GameRegistry.ObjectHolder(value="equivalentenergistics:emc_condenser")
    public static final BlockEMCCondenser CONDENSER = null;

    private ModBlocks() {
    }

    public static void register(IForgeRegistry<Block> registry) {
        ModBlocks.registerBlock(registry, new BlockEMCCrafter());
        ModBlocks.registerBlock(registry, new BlockEMCCondenser());
    }

    public static void registerItemBlocks(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)CRAFTER.createItemBlock());
        registry.register((IForgeRegistryEntry)CONDENSER.createItemBlock());
    }

    public static void registerModels() {
        CRAFTER.registerItemModel(Item.func_150898_a((Block)CRAFTER));
        CONDENSER.registerItemModel(Item.func_150898_a((Block)CONDENSER));
    }

    public static void registerBlock(IForgeRegistry<Block> registry, Block block) {
        registry.register((IForgeRegistryEntry)block);
        if (block instanceof ITileEntityProvider) {
            TE teInfo = block.getClass().getDeclaredAnnotation(TE.class);
            if (teInfo == null) {
                TEList teList = block.getClass().getDeclaredAnnotation(TEList.class);
                if (teList != null) {
                    for (TE te : teList.value()) {
                        GameRegistry.registerTileEntity(te.tileEntityClass(), (String)te.registryName());
                    }
                }
            } else {
                GameRegistry.registerTileEntity(teInfo.tileEntityClass(), (String)teInfo.registryName());
            }
        }
    }
}

